#ifndef TESTTHREAD_HPP
#define TESTTHREAD_HPP

#include "../globals.hpp"
#include "PlatformFramework.hpp"
#include "TestClient.hpp"
#include <iostream>

class CTestClient;

/// Ein Thread f�r den TestClient, der sich darum kuemmert regelmaessig
/// Updates vom Server zu empfangen

class CTestThread
{
public:
	/// Konstruktor f�r den Update-Thread. Erhaelt einen Zeiger auf
	/// den TestClient um auf diesem Methoden auszuf�hren

	CTestThread(CTestClient* pTestClient);

	/// Destruktor

	~CTestThread(void);
	
	/// Setzt den Thread-Zeiger fuer sich selbst. Ist noetig, damit
	/// SDL_WaitThread() mittels GetThreadPointer() an den Thread kommt

	void SetThreadPointer(SDL_Thread* pThread);

	/// SDL_WaitThread() braucht das, damit es an den Thread kommt und
	/// darauf warten kann, dass sich der Thread ordentlich beendet

	SDL_Thread* GetThreadPointer();

	/// Statische Funktion zum Starten des Threads. Der TestClient ruft
	/// SDL_CreateThread auf und uebergibt einen Zeiger auf diese Funktion
	/// @param pTestThread Zeiger auf ein CTestThread-Objekt

	static int Start(void* pTestThread);

	/// Endlosschleife fuehrt regelmaessig ein Update() auf ein CTestClient-Objekt
	/// aus.

	void Run();

	/// Beendet die Endlosschleife (ist also doch nicht so endlos wie ihr Name besagt!)

	void Terminate();

private:
CTestClient* m_pTestClient;	/// Zeiger auf CTestClient-Objekt ///

SDL_Thread* m_pThread;		/// Zeiger auf eigenen Thread ///

bool m_bTerminate;			/// Beendet die Endlosschleife bei true ///

};

#endif
