#include "PlatformFramework.hpp"

#include "../globals.hpp"
#include "Framework.hpp"
#include "../game/Game.hpp"

using namespace std;

/// main-Funktion: Programmeinstiegspunkt
/// Startet & Beendet das Spiel
/// Compile settings fuer VC++ 6:
/// - Konsolenanwendung!
///	- Linker: Linken mit SDL.lib SDLmain.lib OpenGL32.lib GLu32.lib glut32.lib GLaux.lib
///	- C/C++: Kategorie "Code-Generation" -> Laufzeitbibliothek auf "Multithreaded DLL"
/// Compile settings fuer MingW32:
/// - Konsolenanwendung!
///	- Linker: Linken mit mingw32 opengl32 glu32 lib/glut32.lib lib/libSDLmain.a lib/libSDL.dll.a lib/SDL_image.lib user32 gdi32 winmm
int main(int arc, char* argv[])
{
	//Framework initalisieren
	glutInit(&arc, argv);
	if (!g_pFramework->Init(SCREEN_RES_X, SCREEN_RES_Y, SCREEN_BPP, SCREEN_FULLSCREEN))
	{
		return 0;
	}

	//Neue Spielinstanz
	CGame Game;
	Game.Run();		//Hauptschleife
	Game.Quit();	//Wenn Hauptschleife verlassen: Beenden!

	//Speicher freigeben
	g_pFramework->Quit();
	g_pFramework->Del();

	return 0;
}
