#include "Player.hpp"

CPlayer::CPlayer(SPlayerObj* pPlayerObj)
{
	if (!g_pTexture->Load(TEX_TAXI, "Data/taxi.png"))
		cerr << "Textur " << TEX_TAXI << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_ENGINE, "Data/engine.png"))
		cerr << "Textur " << TEX_ENGINE << " konnte nicht geladen werden!";

	//Standardwerte laden
	m_pPlayerObj = pPlayerObj;
	m_pWorld = NULL;
	m_fFuelFactor = 0.0;

	Reset();
}

CPlayer::~CPlayer(void)
{
	//FREEMEM(m_pTex);
	//FREEMEM(m_pParticle);
}

/*
void CPlayer::SetWorldPointer(CWorld* pWorld)
{
	m_pWorld = pWorld;
	m_pParticle->SetWorldPointer(pWorld);
}*/

void CPlayer::Reset()
{
	m_fMaxSpeed = 0.05;
	m_fMaxFuel = 100.0f;
	m_fMaxDmg = 100.0f;
	m_nThrust = 333; // Schub
	m_fFriction = 1.005; // Reibung
	m_bSpecialKeyPressed = false;
	m_bExactCtrl = false;
	m_bEnableUpMovement = true;
	m_bEnableDownMovement = true;

	m_pPlayerObj->fAngleX = m_pPlayerObj->fAngleY = m_pPlayerObj->fAngleZ = 0.0f;
	m_pPlayerObj->fPosX = m_pPlayerObj->fPosY = m_pPlayerObj->fPosZ = 0.0f;
	//m_pPlayerObj->fSpinY = 0.0;
	m_pPlayerObj->PlayerColl.fPlayerHeight = 0.0f;
	m_pPlayerObj->fSpeedX = m_pPlayerObj->fSpeedZ = 0.0f;
	m_pPlayerObj->fDmg = 0.0f;
	m_pPlayerObj->fFuel = m_fMaxFuel;
	m_pPlayerObj->bPush = false;
	m_pPlayerObj->bUp = false;
	m_pPlayerObj->bDown = false;
	m_pPlayerObj->bShowExhaust = false;

	//Model laden
	LoadModel();

	/// Bounding Box erstellen (Hauptkoerper, Fluegel vorn und hinten)
	/// Positionsangaben sind jeweils relativ von Spielerposition
	/// in m_pPlayerObj und muessen daher nicht aktualisier werden
	/*m_pBoundingBox = new CBoundingBox();
	m_pBoundingBox->AddBox(-0.12, -0.12, -0.42, 0.12, 0.12, 0.38);*/
}

void CPlayer::SetPlayerPos(float x, float y, float z)
{
	m_pPlayerObj->fPosX = x;
	m_pPlayerObj->fPosY = y;
	m_pPlayerObj->fPosZ = z;
}

void CPlayer::SetPlayerAngle(float x, float y, float z)
{
	m_pPlayerObj->fAngleX = x;
	m_pPlayerObj->fAngleY = y;
	m_pPlayerObj->fAngleZ = z;
}

bool CPlayer::LoadModel()
{
	//Spielermodell laden
	g_pModel->Load(MODEL_TAXI, "Data/taxi.obj");

	//Duesenausstoss laden
	g_pModel->Load(MODEL_ENGINE, "Data/engine.obj");

	//Kollisions-"Box" festlegen
	m_pPlayerObj->PlayerColl.fPlayerHeight	= PLAYER_COLL_HEIGHT;
	m_pPlayerObj->PlayerColl.fPlayerWidth	= PLAYER_COLL_WIDTH;
	m_pPlayerObj->PlayerColl.fPlayerLength	= PLAYER_COLL_LENGTH;

	//Partikelengine initialisieren
	g_pParticle->initParticleEmitter(0.0,0.0,0.0);

	return true;
}

void CPlayer::Update(bool bProcessMoving)
{
	if (bProcessMoving)
		ProcessMoving();

	// Bewegt das Taxi
	float fTimeFactor =  g_pTimer->GetElapsed() * 30.0f;

	// Gravitation
	if (!m_bExactCtrl)
	{
		// Neigung
		if (m_pPlayerObj->fAngleX < 0)
			m_pPlayerObj->fAngleX += 0.6 * fTimeFactor;
		if (m_pPlayerObj->fAngleX > 0)
			m_pPlayerObj->fAngleX -= 0.6 * fTimeFactor;
		if (m_pPlayerObj->fAngleZ > 0)
			m_pPlayerObj->fAngleZ -= 0.6 * fTimeFactor;
		if (m_pPlayerObj->fAngleZ < 0)
			m_pPlayerObj->fAngleZ += 0.6 * fTimeFactor;

		// Schub
		if (m_pPlayerObj->bPush == true) {
			m_pPlayerObj->fSpeedX += -((float)cosf(m_pPlayerObj->fAngleY * DEG2RAD) / m_nThrust) * fTimeFactor;
			m_pPlayerObj->fSpeedZ += ((float)sinf(m_pPlayerObj->fAngleY * DEG2RAD) / m_nThrust) * fTimeFactor;
			m_pPlayerObj->bPush = false;
			m_pPlayerObj->bShowExhaust = true;

			if (!m_pPlayerObj->bDead)
                m_pPlayerObj->fFuel -= m_fFuelFactor * fTimeFactor;
		}

		// positive Steigung
		if (m_bEnableUpMovement && m_pPlayerObj->bUp == true && m_pPlayerObj->fPosY < 4.9)
		{
			m_pPlayerObj->fPosY += m_pPlayerObj->fPosY * fTimeFactor/80;
			m_pPlayerObj->fAngleZ -= 0.7 * fTimeFactor;
			m_pPlayerObj->bUp = false;

			if (!m_pPlayerObj->bDead)
                m_pPlayerObj->fFuel -= 0.333 * m_fFuelFactor * fTimeFactor;
		}

		// Negative Steigung
		if (m_bEnableDownMovement && m_pPlayerObj->bDown == true && m_pPlayerObj->fPosY > 1.2)
		{
			m_pPlayerObj->fPosY -= m_pPlayerObj->fPosY * fTimeFactor/80;
			m_pPlayerObj->fAngleZ += 0.7 * fTimeFactor;
			m_pPlayerObj->bDown = false;
			//m_pPlayerObj->fFuel-=0.08;
		}

		//Horizontale Bewegung
		m_pPlayerObj->fPosX += m_pPlayerObj->fSpeedX * fTimeFactor;
		m_pPlayerObj->fPosZ += m_pPlayerObj->fSpeedZ * fTimeFactor;

		m_pPlayerObj->fSpeedX = m_pPlayerObj->fSpeedX / (m_fFriction * fTimeFactor * 0.005 + 1.0);
		m_pPlayerObj->fSpeedZ = m_pPlayerObj->fSpeedZ / (m_fFriction * fTimeFactor * 0.005 + 1.0);

		//Spin
		/*m_pPlayerObj->fAngleY += m_pPlayerObj->fSpinY;

		if (m_pPlayerObj->fSpinY > 0.0)
		{
			m_pPlayerObj->fSpinY -= 0.2 * fTimeFactor;

			if (m_pPlayerObj->fSpinY < 0.0)
				m_pPlayerObj->fSpinY = 0.0;
		}

		if (m_pPlayerObj->fSpinY < 0.0)
		{
			m_pPlayerObj->fSpinY += 0.2 * fTimeFactor;

			if (m_pPlayerObj->fSpinY > 0.0)
				m_pPlayerObj->fSpinY = 0.0;
		}*/
	}

	UpdateCollPoints();
}

void CPlayer::UpdateCollPoints()
{
	//Translation der Kollisionspunkte
	//Oben rechts
	m_pPlayerObj->PlayerColl.vTestPoint[0].y = m_pPlayerObj->PlayerColl.fPlayerWidth * 0.5;
	m_pPlayerObj->PlayerColl.vTestPoint[0].x = m_pPlayerObj->PlayerColl.fPlayerLength * 0.5;
	//unten rechts
	m_pPlayerObj->PlayerColl.vTestPoint[1].y = m_pPlayerObj->PlayerColl.fPlayerWidth * 0.5;
	m_pPlayerObj->PlayerColl.vTestPoint[1].x = -m_pPlayerObj->PlayerColl.fPlayerLength * 0.5;
	//unten links
	m_pPlayerObj->PlayerColl.vTestPoint[2].y = -m_pPlayerObj->PlayerColl.fPlayerWidth * 0.5;
	m_pPlayerObj->PlayerColl.vTestPoint[2].x = -m_pPlayerObj->PlayerColl.fPlayerLength * 0.5;
	//oben links
	m_pPlayerObj->PlayerColl.vTestPoint[3].y = -m_pPlayerObj->PlayerColl.fPlayerWidth * 0.5;
	m_pPlayerObj->PlayerColl.vTestPoint[3].x = m_pPlayerObj->PlayerColl.fPlayerLength * 0.5;


	//Rotation der Kollisionspunkte
	float fAngle	= -m_pPlayerObj->fAngleY * DEG2RAD;
	for (int i = 0; i <= 3; i++)
	{
		m_pPlayerObj->PlayerColl.vTestPoint[i].Rotate(fAngle);
	}
}

void CPlayer::UpdateForShowCase()
{
	m_pPlayerObj->fAngleY	+= g_pTimer->GetElapsed() * 10.0;	//Einfache Drehung

	if (m_pPlayerObj->fAngleY > 360.0f)
		m_pPlayerObj->fAngleY -= 360.0f;
}

void CPlayer::LandingPosition()
{
	float fTimeFactor =  g_pTimer->GetElapsed() * 0.375;

	//Waehrend Landung nur Schub moeglich
	if (g_pFramework->KeyDown(SDLK_SPACE))
	{
		do
		{
			m_pPlayerObj->fPosY += m_pPlayerObj->fPosY * fTimeFactor;
			m_pPlayerObj->fAngleZ -= 56.0 * fTimeFactor;
		} while(m_pPlayerObj->fPosY < 0.2);
	}

	UpdateCollPoints();
}

/*
float CPlayer::GetGroundDistance()
{
	return (m_pPlayerObj->fPosY - (float)m_pWorld->GetCurrBlock()->nEndHeight);
}
*/

void CPlayer::Draw(bool bDrawCollPoints, bool bDrawPlayerInfo)
{
	glTranslatef(m_pPlayerObj->fPosX, m_pPlayerObj->fPosY, m_pPlayerObj->fPosZ);
	glPushMatrix();

		//Kollisionspunkte anzeigen
		if (bDrawCollPoints)
		{
			glDisable(GL_LIGHTING);
			glColor3f(1.0, 1.0, 1.0);
			for (int i = 0; i <= 3; i++)
			{
				//cout << "#### Collpoint.x: " << m_pPlayerObj->PlayerColl.vTestPoint[i].x << " y: " << m_pPlayerObj->PlayerColl.vTestPoint[i].y << endl;
				glPushMatrix();
					glTranslatef(m_pPlayerObj->PlayerColl.vTestPoint[i].x, 0.0, m_pPlayerObj->PlayerColl.vTestPoint[i].y);
					glutSolidSphere(0.05f, 10, 10);
				glPopMatrix();
			}
			glEnable(GL_LIGHTING);
			/*
			CBox* pBox;
			for (int i = 0; i < m_pBoundingBox->NumBoxes(); i++)
			{
				pBox = (*m_pBoundingBox)[i];
				cout << pBox->fLowerX << " " << pBox->fLowerY << " " << pBox->fLowerZ << endl;
				glPushMatrix();
					glTranslatef(
							pBox->fLowerX + pBox->fWidth / 2.0,
							pBox->fLowerY + pBox->fHeight / 2.0,
							pBox->fLowerZ + pBox->fDepth / 2.0);

					glScalef(
							pBox->fUpperX - pBox->fLowerX,
							pBox->fUpperY - pBox->fLowerY,
							pBox->fUpperZ - pBox->fLowerZ);

					glutWireCube(1.0);
				glPopMatrix();
			}*/
		}

		//Position des Spielerobjekts
		//glTranslatef(m_pPlayerObj->fPosX, m_pPlayerObj->fPosY, m_pPlayerObj->fPosZ);

		/// Schub initialisieren
		m_pPlayerObj->bPush = false;
		m_pPlayerObj->bUp = false;

		//Spotlight anbringen
		/*GLfloat fSpotLightPos[] = {0.0, 1.0, 0.0, 1.0};	//relativ zur letzten Transformation!
		GLfloat fSpotLightDir[] = {0.0, -1.0, 0.0};
		GLfloat fSpotLightColor[] = {0.8, 1.0, 0.8, 1.0};
		glLightfv(GL_LIGHT2, GL_SPOT_DIRECTION, fSpotLightDir);
		glLightfv(GL_LIGHT2, GL_DIFFUSE,  fSpotLightColor);
		glLightf(GL_LIGHT2, GL_SPOT_CUTOFF, 20.0);    	// gibt den Winkel an, der zwischen Richtung und max. Auswurf besteht
		glLightf(GL_LIGHT2, GL_SPOT_EXPONENT, 5.0);   	// beschreibt, wie stark die Lichtst�rke nach aussen hin abnimmt
		glLightfv(GL_LIGHT2, GL_POSITION, fSpotLightPos);

		glEnable(GL_LIGHT2);*/


		//Neigung des Spielerobjekts
		glRotatef(m_pPlayerObj->fAngleX, 1.0f, 0.0f, 0.0f);
		glRotatef(m_pPlayerObj->fAngleY, 0.0f, 1.0f, 0.0f);
		glRotatef(m_pPlayerObj->fAngleZ, 0.0f, 0.0f, 1.0f);

		//Duesen anzeigen!
		if (m_pPlayerObj->bShowExhaust == true)
		{
			//Textur benutzen
			g_pTexture->Use(TEX_ENGINE);

			glPushAttrib(GL_COLOR_BUFFER_BIT);
			glPushMatrix();
				glEnable(GL_BLEND);

				glTranslatef(0.47, -0.08, 0.0);

				//Duesenmodell runterskalieren
				glScalef(0.5f, 0.5f, 0.5f);

				//Duesenmodell malen
				g_pModel->Draw(MODEL_ENGINE);

				glDisable(GL_BLEND);
			glPopAttrib();
			glPopMatrix();

			m_pPlayerObj->bShowExhaust = false;
		}

		//Textur benutzen
		g_pTexture->Use(TEX_TAXI);

		//Modell runterskalieren
		glScalef(0.4f, 0.4f, 0.4f);

		//Modell malen
		g_pModel->Draw(MODEL_TAXI);
	glPopMatrix();

	//Name und event. andere Informationen ueber dem Spieler anzeigen:
	if (bDrawPlayerInfo)
	{
		glPushMatrix();
			glTranslatef(0.0, 0.25, -0.5);
			glScalef(0.15f, 0.15f, 0.15f);
			glRotatef(m_pWorld->GetCamAngle(),1.0,0.0,0.0);
			glRotatef(180.0, 0.0, 1.0, 0.0);
			g_pText3D->SetFont();
			glPushAttrib(GL_COLOR_BUFFER_BIT);
			glEnable(GL_BLEND);
			g_pText3D->DrawStr(m_pPlayerObj->szName);
			glDisable(GL_BLEND);
			glPopAttrib();
		glPopMatrix();
	}
}

void CPlayer::DrawAnimationOfDeath()
{
	g_pParticle->updateParticles(m_pPlayerObj->fPosX, m_pPlayerObj->fPosY + 1.5f, m_pPlayerObj->fPosZ);
}

void CPlayer::DrawAnimationOfCrash()
{
	float fTimeFactor = g_pTimer->GetElapsed() * 10.0;

	//Gewackel beim Absinken
	m_pPlayerObj->fAngleX += (float)((rand() % 1000 - 500) / 100.0) * fTimeFactor;
	m_pPlayerObj->fAngleY += (float)((rand() % 1000 - 500) / 100.0) * fTimeFactor;
	m_pPlayerObj->fAngleZ += (float)((rand() % 1000 - 500) / 100.0) * fTimeFactor;

	m_pPlayerObj->fPosY -= 0.1 * fTimeFactor;
}


void CPlayer::ProcessMoving()
{
	const float fSens = 0.5 * g_pTimer->GetElapsed();

	if (g_pFramework->KeyDown(SDLK_RIGHT))
	{
		//m_pPlayerObj->fSpinY = 0.0;

		if (m_bExactCtrl)
			m_pPlayerObj->fPosX -= 1.5 * fSens;
		else
		{
			m_pPlayerObj->fAngleY -= 300.0 * fSens;
			if (m_pPlayerObj->fAngleY < 0.0)
				m_pPlayerObj->fAngleY += 360.0;

			if(m_pPlayerObj->fAngleX > -20.0)
			{
				// Neigung abhaengig von der Geschwindigkeit
				m_pPlayerObj->fAngleX -= SQR((m_pPlayerObj->fSpeedX + m_pPlayerObj->fSpeedZ))* 8000 * fSens;
			}
		}
	}

	if (g_pFramework->KeyDown(SDLK_LEFT))
	{
		//m_pPlayerObj->fSpinY = 0.0;

		if (m_bExactCtrl)
			m_pPlayerObj->fPosX += 1.5 * fSens;
		else
		{
			m_pPlayerObj->fAngleY += 300.0 * fSens;
			if (m_pPlayerObj->fAngleY > 360.0)
				m_pPlayerObj->fAngleY -= 360.0;

			if(m_pPlayerObj->fAngleX < 20.0)
				m_pPlayerObj->fAngleX += SQR((m_pPlayerObj->fSpeedX + m_pPlayerObj->fSpeedZ))* 8000 * fSens;
		}
	}

	if (g_pFramework->KeyDown(SDLK_UP))
	{
		if (m_bExactCtrl)
			m_pPlayerObj->fPosZ += 1.5 * fSens;
		else
		{
			if(m_pPlayerObj->fAngleZ < 12.0)
			{
				m_pPlayerObj->fAngleZ += 60 * fSens;
				m_pPlayerObj->bPush = true;
			}
		}
	}

	if (g_pFramework->KeyDown(SDLK_DOWN))
	{
		if (m_bExactCtrl)
			m_pPlayerObj->fPosZ -= 1.5 * fSens;
	}

	if (g_pFramework->KeyDown(SDLK_SPACE))
	{
		m_pPlayerObj->bUp = true;
		if (m_bExactCtrl)
			m_pPlayerObj->fPosY += 1.5 * fSens;
	}

	if (g_pFramework->KeyDown(SDLK_LCTRL))
	{
		m_pPlayerObj->bDown = true;
		if (m_bExactCtrl)
			m_pPlayerObj->fPosY -= 1.5 * fSens;
	}

#ifdef _DEBUG
	if (!m_bSpecialKeyPressed && g_pFramework->KeyDown(SDLK_t))
	{
		m_bExactCtrl = !m_bExactCtrl;
		m_pPlayerObj->fSpeedX = 0.0f;
		m_pPlayerObj->fSpeedZ = 0.0f;
		m_bSpecialKeyPressed = true;
	}

	if (!g_pFramework->KeyDown(SDLK_t))
	{
		m_bSpecialKeyPressed = false;
	}
#endif
}
