#ifndef PLAYER_HPP
#define PLAYER_HPP

#include "../client/PlatformFramework.hpp"

#include "../globals.hpp"
#include "../client/Framework.hpp"
#include "../tools/Timer.hpp"
#include "../tools/Vec2D.hpp"
#include "../tools/Vec3D.hpp"
//#include "../tools/BoundingBox.hpp"
#include "../gfx/Model.hpp"
#include "../gfx/Particle.hpp"
#include "../gfx/Texture.hpp"
#include "../gfx/Text3D.hpp"

#include "World.hpp"

using namespace std;

class CParticle;
class CWorld;

/// Spielerobjekt
/// Zeichnet das Spielermodell und sorgt fuer Spieler-Welt Interaktion
class CPlayer
{
	public:
		/// Konstruktor: Texturen & Modell laden und Standardwerte laden
		/// @param pPlayerObj Zeiger auf aktuelle Spielerdaten
		CPlayer(SPlayerObj* pPlayerObj);

		/// Destruktor: Heap-Speicher freigeben
		~CPlayer();

		/// Zeiger auf World-Instanz setzen
		/// @param pWorld Zeiger auf World-Instanz
		void SetWorldPointer(CWorld* pWorld) { m_pWorld = pWorld; };

		/// Zeiger auf Spieledaten setzen
		/// @param pPlayerObj Zeiger auf aktuelle Spielerdaten
		void SetPlayer(SPlayerObj* pPlayerObj) {m_pPlayerObj = pPlayerObj; }

		/// Spielerposition setzen
		/// @param x X-Koord.
		/// @param y Y-Koord.
		/// @param z Z-Koord.
		void SetPlayerPos(float x, float y, float z);

		/// Spielerobjekt Drehung & Neigung setzen
		/// @param x Neigungsgrad um X-Achse
		/// @param y Neigungsgrad um Y-Achse
		/// @param z Neigungsgrad um Z-Achse
		void SetPlayerAngle(float x, float y, float z);

		/// Treibstoffverbrauch setzen
		/// @param f Neuer Treibstoffverbrauch
		void SetFuelFactor(float f) { m_fFuelFactor = f; };

		/// Jegliche Bewegung stoppen
		void Stop() { m_pPlayerObj->bPush = false, m_pPlayerObj->bUp = false; m_pPlayerObj->bDown = false; m_pPlayerObj->fSpeedX = 0.0; m_pPlayerObj->fSpeedZ = 0.0; }

		/// Spielermodell zeichnen
		/// @param Kollisionspunkte zeichnen?
		/// @param Spielername darunter zeichnen?
		void Draw(bool bDrawCollPoints = true, bool bDrawPlayerInfo = false);

		/// Animation des Todes. Muhahar!
		void DrawAnimationOfDeath();

		/// Animation des Abschmierens...
		void DrawAnimationOfCrash();

		/// Events ueberpruefen
		/// @param bProcessMoving Bewegungstasten abfragen oder ignorieren?
		void Update(bool bProcessMoving = true);

		/// Das Model einfach rotieren, keine Eingabe
		void UpdateForShowCase();

		/// Den Abstand vom Boden zurueck geben
		/// @return float Abstand vom Boden
		float GetGroundDistance();

		/// Standardwerte laden
		void Reset();
		
		/// Spieler befindet sich in Landepositon
		void LandingPosition();

		/// Schub nach oben oder Absinken aktivieren oder deaktivieren
		/// @param bUpMovement true = Schub nach oben, false = Absinken
		/// @param bSetting Aktivieren oder Deaktivieren
		void SetVerticalMovement(bool bUpMovement, bool bSetting)
		{
			if (bUpMovement)
				m_bEnableUpMovement = bSetting;
			else
				m_bEnableDownMovement = bSetting;
		}

	private:
		/// Bewegung realisieren & Tasten abfangen
		void ProcessMoving();

		/// Kollisionspunkte neu berechnen
		void UpdateCollPoints();

		/// Spielerobjekt laden
		/// @return Laden erfolgreich?
		bool LoadModel();

		/// Energieausstoss laden
		/// @return Laden erfolgreich?
		bool LoadEngineModel();
		
		SPlayerObj* m_pPlayerObj;	///< Enthält alle Spielerdaten
		CWorld* m_pWorld;			///< Zeiger auf das Level

		bool m_bEnableUpMovement;	///< Schub noch oben erlaubt?
		bool m_bEnableDownMovement;	///< Absinken erlaubt?

		float m_fMaxFuel;		///< Max. Wert fuer Treibstoff
		float m_fFuelFactor;	///< Faktor, der den Treibstoffverbrauch bestimmt. Ist beim MP anders als im SP
		float m_fMaxDmg;		///< Max. Wert fuer Schaden
		float m_fMaxSpeed;		///< Maximale Geschwindigkeit des Spielerobjekts

		int m_nThrust;				///< Schub
		float m_fFriction;			///< Reibung
		bool m_bSpecialKeyPressed;	///< Spezieller "Ein-mal-Tastendruck"?
		bool m_bExactCtrl;			///< Cheat: Exakte Fahrzeugkontrolle
};

#endif
