#include "PlayerCtrl.hpp"
#include "../gfx/Gui.hpp"

#include "Player.hpp"
#include "World.hpp"
#include "../tools/3DTools.hpp"

CPlayerCtrl::CPlayerCtrl(EProgramStatus* peProgStatus, EGameStatus* peGameStatus)
{
	m_peProgStatus = peProgStatus;
	m_peGameStatus = peGameStatus;

	m_nLocalPlayerID = 0;

	// Lokaler spieler
	m_pLocPlayerData = new SPlayerObj;
	m_pLocPlayerData->nID = m_nLocalPlayerID;
	// Map fuer Netzwerkspieler - im Singleplayer immer leer
	m_pmPlayers = new map<int, SPlayerObj>;

	m_pPlayerInstance = new CPlayer(m_pLocPlayerData);
	m_pPlayerInstance->SetFuelFactor(1.5);

	m_pLocPlayerData->nID = m_nLocalPlayerID;
	m_pLocPlayerData->szName = "Local Player"; //im SP immer dieser Name
	Reset();
}

CPlayerCtrl::~CPlayerCtrl(void)
{
	FREEMEM(m_pLocPlayerData);
	FREEMEM(m_pmPlayers);
	FREEMEM(m_pPlayerInstance);
}


void CPlayerCtrl::SetWorldPointer(CWorld* pWorld)
{
	m_pWorld = pWorld;
	m_pPlayerInstance->SetWorldPointer(pWorld);
}

void CPlayerCtrl::Reset()
{
	m_pLocPlayerData->fCrashAnimTimer = CRASH_ANIM_SECONDS;
	m_pLocPlayerData->fDeathAnimTimer = DEATH_ANIM_SECONDS;
	m_pLocPlayerData->nScore = 0;
	m_pLocPlayerData->nBonusScore = 0;
	m_pLocPlayerData->nLives = 3;
	m_pLocPlayerData->bDead = false;

	GetPlayer()->Reset();
	GetPlayer()->SetPlayerAngle(0.0, 90.0, 0.0);
}


void CPlayerCtrl::ResetAfterDeath(const int nDeathBlockX, const int nDeathBlockY, const int nDeathBlockZ, int nID)
{
	m_pLocPlayerData->nLives--;

	if (m_pLocPlayerData->nLives < 0)	//Game over!
	{
		*m_peProgStatus = MENU_GAME_OVER;
		*m_peGameStatus = GAME_STOPPED;

		return;
	}

	m_pLocPlayerData->fDeathAnimTimer = DEATH_ANIM_SECONDS;
	m_pLocPlayerData->fCrashAnimTimer = CRASH_ANIM_SECONDS;
	GetPlayer()->Reset();
	//m_pWorld->Reload();
	m_pWorld->SetPlayer(m_pLocPlayerData);	//Die Zeiger immer auf den aktuellen Spieler setzen!
	m_pWorld->SetupLevel();

	m_pWorld->SetPlayerOnBlock(nDeathBlockX, nDeathBlockY, nDeathBlockZ);

	m_pLocPlayerData->fAngleX = 0.0;
	m_pLocPlayerData->fAngleY = 90.0;
	m_pLocPlayerData->fAngleZ = 0.0;

	Update();
}


CPlayer* CPlayerCtrl::GetPlayer(int nID)
{
	SPlayerObj* pPlayerObj = GetPlayerData(nID);

	if (pPlayerObj != NULL)
	{
		m_pPlayerInstance->SetPlayer(pPlayerObj);
		return m_pPlayerInstance;
	}
	else
		return NULL;
}

SPlayerObj* CPlayerCtrl::GetPlayerData(int nID)
{
	if (nID == -1 || nID == m_nLocalPlayerID)
	{
		return m_pLocPlayerData;
	}
	else
	{
		map<int, SPlayerObj>::iterator iter = m_pmPlayers->find(nID);
		if (iter != m_pmPlayers->end())
		{
			return &iter->second;
		}
	}

	return NULL;
}

void CPlayerCtrl::CalcPlayerBonusScore()
{
    m_pLocPlayerData->fPlayingTime = m_pGui->GetPlayingTime();
	m_pLocPlayerData->nBonusScore = (int)((100.0 / m_pLocPlayerData->fPlayingTime) + m_pLocPlayerData->nLives * 500.0 + m_pLocPlayerData->fFuel * 10.0);
}

void CPlayerCtrl::Draw(bool bDrawAxis)
{
	DrawPlayer(m_nLocalPlayerID, bDrawAxis);

	//Wenig Treibstoff! Warnung anzeigen!
	if (m_pLocPlayerData->fFuel <= 20.0)
	{
		m_pGui->DrawWarning("- Wenig Treibstoff! -", SCREEN_RES_X - 500, SCREEN_RES_Y  - 500, 0.7);
	}
}

void CPlayerCtrl::DrawPlayer(int i, bool bDrawAxis, bool bDrawName)
{
	glPushMatrix();
		SPlayerObj* pPlayer = GetPlayerData(i);
		if (pPlayer == NULL)
		{
			return;
		}

		if (pPlayer->bDead)	//Geistermodus
		{
			glColor4f(0.0f, 1.0f, 0.3, 0.25);	//Transparenz nimmt ab
			glEnable(GL_BLEND);
			glDisable(GL_LIGHTING);   // Licht deaktivieren
			glDisable(GL_TEXTURE_2D);
		}
		else if (pPlayer->fDeathAnimTimer < DEATH_ANIM_SECONDS) //Transparenz erhoehen fuer die Todesanimation
		{
			bDrawName = false;
			glColor4f(0.0f, 1.0f, 0.3, pPlayer->fDeathAnimTimer / DEATH_ANIM_SECONDS);	//Transparenz nimmt ab
			glEnable(GL_BLEND);
			glDisable(GL_LIGHTING);   // Licht deaktivieren
			glDisable(GL_TEXTURE_2D);
		}

		m_pPlayerInstance->SetPlayer(pPlayer);
		m_pPlayerInstance->Draw(bDrawAxis, bDrawName);

		//Transparenz Einstellungen zuruecksetzen
		if (pPlayer->fDeathAnimTimer < DEATH_ANIM_SECONDS || pPlayer->bDead)
		{
			glDisable(GL_BLEND);
			glEnable(GL_LIGHTING);
			glEnable(GL_TEXTURE_2D);
			glColor4f(1.0f, 1.0f, 1.0f, 0.5f);
		}

		if (bDrawAxis)
			C3DTools::drawAxis(0.5, false);
	glPopMatrix();
}

void CPlayerCtrl::DrawCrash(int i)
{
	ECollision eCollSide1 = NONE;
	ECollision eCollSide2 = NONE;
	int nTemp;
	int nDeathBlockX, nDeathBlockY, nDeathBlockZ;	//Respawn-Block

	SPlayerObj* pPlayer = GetPlayerData(i);

	//Abschmieren!
	GetPlayer(i)->Stop();

	pPlayer->fCrashAnimTimer -= g_pTimer->GetElapsed();

	m_pWorld->SetPlayer(pPlayer);	//Die Zeiger immer auf den aktuellen Spieler setzen!

	if (m_pWorld->PlayerCollides(&eCollSide1, &eCollSide2, &nTemp))
	{
		DrawDeath(i);
	}
	else
	{
		GetPlayer(i)->DrawAnimationOfCrash();
	}

	if (i == -1)
		m_pWorld->SetCamDistance(m_pWorld->GetCamDistance() - (pPlayer->fCrashAnimTimer * 0.02));

	if (pPlayer->fCrashAnimTimer <= 0.0)
	{
		//Animation zu Ende
		m_pWorld->GetCurrBlock(&nDeathBlockX, &nDeathBlockY, &nDeathBlockZ);
		ResetAfterDeath(nDeathBlockX, nDeathBlockY, nDeathBlockZ, i);
	}
}

void CPlayerCtrl::DrawDeath(int i)
{
	int nDeathBlockX, nDeathBlockY, nDeathBlockZ;	//Respawn-Block
	SPlayerObj* pPlayer = GetPlayerData(i);
	GetPlayer(i)->Stop();
	GetPlayer(i)->DrawAnimationOfDeath();
	pPlayer->fDeathAnimTimer -= g_pTimer->GetElapsed();

	m_pWorld->SetPlayer(pPlayer);	//Die Zeiger immer auf den aktuellen Spieler setzen!

	if (i == -1)
		m_pWorld->SetCamDistance(m_pWorld->GetCamDistance() - pPlayer->fDeathAnimTimer * 0.02);

	if (pPlayer->fDeathAnimTimer <= 0.0)
	{
		//Todesanimation zu Ende
		m_pWorld->GetCurrBlock(&nDeathBlockX, &nDeathBlockY, &nDeathBlockZ);
		ResetAfterDeath(nDeathBlockX, nDeathBlockY, nDeathBlockZ, i);
	}
}

void CPlayerCtrl::Update()
{
	ECollision eCollSide1 = NONE;
	ECollision eCollSide2 = NONE;
	int nTemp;	//F�r PlayerCollides()
	//int nDeathBlockX, nDeathBlockY, nDeathBlockZ;	//Respawn-Block

	CPlayer* pLocalPlayer = GetPlayer();

	pLocalPlayer->SetVerticalMovement(true, true);
	pLocalPlayer->SetVerticalMovement(false, true);

	m_pWorld->SetPlayer(m_pLocPlayerData);	//Die Zeiger immer auf den aktuellen Spieler setzen!

	//Kein Treibstoff oder Traxi schrott!
	if (m_pLocPlayerData->fFuel <= 0.0)
	{
		DrawCrash();
	}
	else if (m_pWorld->PlayerLanded()) //Landung: Wenn Auto steht, dann ist kein Update notwendig
	{
		if (m_pWorld->PlayerReachesGoal())
		{
			*m_peGameStatus = GAME_STOPPED;
			*m_peProgStatus = MENU_LEVEL_END;
			CalcPlayerBonusScore();
		}
		m_pGui->DrawWarning("- Gelandet! Zum Starten Leertaste druecken! -", SCREEN_RES_X - 600, SCREEN_RES_Y  - 530, 0.0);
		pLocalPlayer->LandingPosition();
	}
	else if (m_pWorld->PlayerCollides(&eCollSide1, &eCollSide2, &nTemp))	//Kollision!
	{
		DrawDeath();
	}
	else if(m_pWorld->PlayerReachesSpecialField(SPECIAL_BLOCK_FUEL))	//Auftanken!
	{
		m_pLocPlayerData->fFuel = 100.0;
		pLocalPlayer->Update();
	}
	else if(m_pWorld->PlayerReachesSpecialField(SPECIAL_BLOCK_BONUS))	//Bonus!
	{
		m_pLocPlayerData->nScore += 100;
		pLocalPlayer->Update();
	}
	else	//Alles normal: Spieler fliegt
	{
 		pLocalPlayer->Update();
	}
}
