#include "PlayerCtrlMP.hpp"
#include "../client/Client.hpp"
#include "Player.hpp"
#include "../gfx/Gui.hpp"

CPlayerCtrlMP::CPlayerCtrlMP(CClient* pClient, EProgramStatus* peProgStatus, EGameStatus* peGameStatus) : CPlayerCtrl(peProgStatus, peGameStatus)
{
	m_pClient = pClient;
	m_pPlayerInstance->SetFuelFactor(0.15);
	m_nLocalPlayerID = pClient->GetLocalPlayerID();
	pClient->SetLocalPlayerObj(m_pLocPlayerData);

	FREEMEM(m_pmPlayers);
	m_pmPlayers = pClient->GetPlayerObj();
	m_bGoalReached = false;
}


CPlayerCtrlMP::~CPlayerCtrlMP(void)
{
	FREEMEM(m_pLocPlayerData);
	//FREEMEM(m_pmPlayers);	//macht CClient!
	m_pmPlayers = NULL;
	FREEMEM(m_pPlayerInstance);
}


void CPlayerCtrlMP::SetWorldPointer(CWorld* pWorld)
{
	m_pWorld = pWorld;
	m_pPlayerInstance->SetWorldPointer(pWorld);
	m_pWorld->SetAdjustPlayer(true);
	m_pWorld->SetPlayerMapPointer(m_pmPlayers);
}

void CPlayerCtrlMP::Reset()
{
	m_pLocPlayerData->fCrashAnimTimer = CRASH_ANIM_SECONDS;
	m_pLocPlayerData->fDeathAnimTimer = DEATH_ANIM_SECONDS;
	m_pLocPlayerData->nScore = 0;
	m_pLocPlayerData->nBonusScore = 0;
	m_pLocPlayerData->nLives = 0;
	m_pLocPlayerData->bDead = false;

	GetPlayer()->Reset();
	GetPlayer()->SetPlayerAngle(0.0, 90.0, 0.0);

	m_bGoalReached = false;

	//Die lokalen Daten anderer Spieler wieder zurueck setzen:
	map<int, SPlayerObj>::iterator iter;
	m_pClient->LockMutex();
	for (iter = m_pmPlayers->begin(); iter != m_pmPlayers->end(); iter++)
	{
		iter->second.fCrashAnimTimer = CRASH_ANIM_SECONDS;
		iter->second.fDeathAnimTimer = DEATH_ANIM_SECONDS;
		iter->second.bDead = false;
	}
	m_pClient->UnlockMutex();
}

void CPlayerCtrlMP::Draw(bool bDrawAxis)
{
	/* JEDEN Spieler anzeigen, ausser den lokalen: */
	m_pClient->LockMutex();
	map<int, SPlayerObj>::iterator iter;
	for (iter = m_pmPlayers->begin(); iter != m_pmPlayers->end(); iter++)
	{
		if (!iter->second.bDead)
			CPlayerCtrl::DrawPlayer(iter->first, bDrawAxis, true);
	}
	m_pClient->UnlockMutex();

	//Den lokalen gesondert Zeichnen:
	CPlayerCtrl::Draw(bDrawAxis);
}

void CPlayerCtrlMP::ResetAfterDeath(const int nDeathBlockX, const int nDeathBlockY, const int nDeathBlockZ, int nID)
{
	SPlayerObj* pPlayer = GetPlayerData(nID);
	pPlayer->fDeathAnimTimer = DEATH_ANIM_SECONDS;
	pPlayer->fCrashAnimTimer = CRASH_ANIM_SECONDS;
	GetPlayer(nID)->Reset();
	//m_pWorld->Reload();
	m_pWorld->SetPlayer(pPlayer);	//Die Zeiger immer auf den aktuellen Spieler setzen!
	m_pWorld->SetupLevel();

	m_pWorld->SetPlayerOnBlock(nDeathBlockX, nDeathBlockY, nDeathBlockZ);

	pPlayer->fAngleX = 0.0;
	pPlayer->fAngleY = 90.0;
	pPlayer->fAngleZ = 0.0;

	pPlayer->bDead = true;
	if (nID == m_nLocalPlayerID || nID == -1)
	{
		m_pClient->Die();
	}

	Update();
}

void CPlayerCtrlMP::Update()
{
	//UPDATE f�r jeden Spieler, au�er den lokalen...
	m_pClient->LockMutex();
	map<int, SPlayerObj>::iterator iter;
	for (iter = m_pmPlayers->begin(); iter != m_pmPlayers->end(); iter++)
	{
		GetPlayer(iter->first)->Update(false);

		if (iter->second.fPosX != 0.0 && iter->second.fPosY != 0.0 && iter->second.fPosZ != 0.0	//Workaround, fuer uninitialisierte Spieler
			&& (iter->second.fDmg >= 100.0 || iter->second.fFuel <= 0.0))
		{
			DrawDeath(iter->first);
		}
	}
	m_pClient->UnlockMutex();

	//... der wird gesondert behandelt:
	ECollision eCollSide1 = NONE;
	ECollision eCollSide2 = NONE;
	int nCollPlayerID = 0;	//ID des Spielers, mit dem kollidiert wurde
	//int nDeathBlockX, nDeathBlockY, nDeathBlockZ;	//Respawn-Block

	CPlayer* pLocalPlayer = GetPlayer();
	SPlayerObj* pCollPlayer;

	pLocalPlayer->SetVerticalMovement(true, true);
	pLocalPlayer->SetVerticalMovement(false, true);

	m_pWorld->SetPlayer(m_pLocPlayerData);	//Die Zeiger immer auf den aktuellen Spieler setzen!

	if (!m_pLocPlayerData->bDead)	//Nur fuer lebendige Spieler:
	{
		if (m_pLocPlayerData->fDmg >= 100.0 || m_pLocPlayerData->fFuel <= 0.0) //Traxi kaputt
		{
			DrawDeath();
		}
		else if (m_pWorld->PlayerLanded()) //Landung
		{
			if (m_pWorld->PlayerReachesGoal())
			{
				m_pGui->DrawWarning("- Geschafft! Du hast diese Runde gewonnen! -", SCREEN_RES_X - 600, SCREEN_RES_Y  - 530, 0.0);
				pLocalPlayer->Stop();

				if (!m_bGoalReached)	//ein mal schicken reicht!
				{
					m_pClient->GoalReached();
					m_bGoalReached = true;
				}
			}
			else
			{
				m_pGui->DrawWarning("- Gelandet! Zum Starten Leertaste druecken! -", SCREEN_RES_X - 600, SCREEN_RES_Y  - 530, 0.0);
				pLocalPlayer->LandingPosition();
			}
		}
		else if(m_pWorld->PlayerReachesSpecialField(SPECIAL_BLOCK_FUEL))	//Auftanken!
		{
			m_pLocPlayerData->fFuel = 100.0;
			pLocalPlayer->Update();
		}
		else if(m_pWorld->PlayerReachesSpecialField(SPECIAL_BLOCK_BONUS))	//Ein Stern! -> Im Multiplayermodus heisst dass, das man repariert wird
		{
			m_pLocPlayerData->fDmg = 0.0;
			pLocalPlayer->Update();
		}
		else	//Alles normal: Spieler fliegt
		{
			m_pClient->LockMutex();
			if (m_pWorld->PlayerCollides(&eCollSide1, &eCollSide2, &nCollPlayerID))	//Kollision!
			{
				m_pClient->UnlockMutex();

				if (nCollPlayerID > 0 && (eCollSide1 != ABOVE && eCollSide1 != BENEATH))	//wir sind mit einem Spieler kollidiert!
				{
					pCollPlayer = GetPlayerData(nCollPlayerID);
					m_pLocPlayerData->fDmg += fabsf(m_pLocPlayerData->fSpeedX - pCollPlayer->fSpeedX)
						+ fabsf(m_pLocPlayerData->fSpeedZ - pCollPlayer->fSpeedZ) * 100.0;	//der Schaden durch den anderen kommt noch mit dazu!

					//Falls sich beide kaum noch bewegen: "Entkeilen"!
					if (fabsf(m_pLocPlayerData->fSpeedX) + fabsf(m_pLocPlayerData->fSpeedZ) < 0.001
						&& fabsf(pCollPlayer->fSpeedX) + fabsf(pCollPlayer->fSpeedZ) < 0.001)
					{
						m_pLocPlayerData->fPosX += (float)((rand() % 101) - 50) / 500.0f;
						m_pLocPlayerData->fPosZ += (float)((rand() % 101) - 50) / 500.0f;
					}
				}
				else
				{
					//Schaden bei normaler Wand-Kollision:
					m_pLocPlayerData->fDmg += fabsf(m_pLocPlayerData->fSpeedX) + fabsf(m_pLocPlayerData->fSpeedZ) * 100.0;	//ist sogar physikalisch korrekt: Kraefte werden wie Vektoren addiert
				}

				if (eCollSide1 == LEFT || eCollSide1 == RIGHT ||
					eCollSide2 == LEFT || eCollSide2 == RIGHT)
				{

					m_pLocPlayerData->fSpeedX *= -0.8;
					m_pLocPlayerData->fSpeedZ *= 0.8;
				}
				else if (eCollSide1 == TOP || eCollSide1 == BOTTOM ||
						eCollSide2 == TOP || eCollSide2 == BOTTOM)
				{
					m_pLocPlayerData->fSpeedX *= 0.8;
					m_pLocPlayerData->fSpeedZ *= -0.8;
				}
				else if (eCollSide1 == ABOVE || eCollSide2 == ABOVE)
				{
					pLocalPlayer->SetVerticalMovement(true, false);
					pLocalPlayer->SetVerticalMovement(false, true);
				}
				else if (eCollSide1 == BENEATH || eCollSide2 == BENEATH)
				{
					pLocalPlayer->SetVerticalMovement(false, false);
					pLocalPlayer->SetVerticalMovement(true, true);
				}

				pLocalPlayer->Update(false);
			}
			else
			{
				m_pClient->UnlockMutex();
				pLocalPlayer->Update();
			}
		}
	}
	else	//Tote Spieler sind im Geistermodus:
	{
		m_pGui->DrawWarning("- Du bist tot! Du kannst aber noch weiter als Geist zuschauen! -", SCREEN_RES_X - 600, SCREEN_RES_Y  - 530, 0.0);
		pLocalPlayer->Update();
	}
}

