#ifndef PLAYERCTRLMP_HPP
#define PLAYERCTRLMP_HPP

#include "../globals.hpp"
#include "PlayerCtrl.hpp"

class CClient;
class CWorld;

/// Klasse zum Anzeigen und Aktualisieren mehrerer Spielerdaten, hier im
/// Multiplayer
class CPlayerCtrlMP : public CPlayerCtrl
{
	public:
		/// Konstruktor. Setzt die Standardwerte fuer das MP-Spiel
		/// @param peProgStatus Programmstatus
		/// @param peGameStatus Spielstatus
		CPlayerCtrlMP(CClient* pClient, EProgramStatus* peProgStatus, EGameStatus* peGameStatus);

		/// Dekonstruktor. Raeumt auf.
		~CPlayerCtrlMP();

		/// Alle Spieler zeichnen
		/// @param bDrawAxis Zu Debugzwecken die Achsen dazu zeichnen
		void Draw(bool bDrawAxis = false);

		/// Alle Spieler aktualisieren
		void Update();

		/// Zeiger auf die Level-Instanz setzen
		/// @param pWorld Zeiger auf die Level-Instanz
		void SetWorldPointer(CWorld* pWorld);

		/// Zuruecksetzen aller Spieler auf Standardwerte
		void Reset();

	private:
		/// Zuruecksetzen eines Spielers auf Standardwerte nach dem Tod -> Geistermodus
		/// @param nDeathBlockX Block des Todes - X Koord.
		/// @param nDeathBlockY Block des Todes - Y Koord.
		/// @param nDeathBlockZ Block des Todes - Z Koord.
		/// @param nID Fuer einen Spieler mit dieser ID, standard den lokalen Spieler
		void ResetAfterDeath(const int nDeathBlockX, const int nDeathBlockY, const int nDeathBlockZ, int nID = -1);

		CClient* m_pClient;		///< Zeiger auf Client-Instanz
		bool m_bGoalReached;	///< Wird true, sobald dieser Spieler das Ziel erreicht hat
};

#endif
