#include "SaveGame.hpp"

CSaveGame::CSaveGame(void)
{
	m_saveData.nUnlockedLevel = 0;
	m_saveData.sPlayerName = "player";
}

CSaveGame::~CSaveGame(void)
{
}

bool CSaveGame::Load(const char* szFile, const char* szHighscoreFile)
{
	ifstream readFile(szFile, ios::binary);
	SSaveData tmpSaveData;

	if (!readFile)
		return false;

	//Laden der Benutzereinstellungen als serialisiertes SSaveData struct
#if defined(WIN32) && defined(_MSC_VER)
	readFile.read((char*) &m_saveData, sizeof(m_saveData));
#else
	readFile.read((char*) &m_saveData.nUnlockedLevel, sizeof(int));
	readFile >> m_saveData.sPlayerName;
#endif

	readFile.close();
	DEBUG_PRINTL("Unlocked to level " << m_saveData.nUnlockedLevel);
	DEBUG_PRINTL("Player name " << m_saveData.sPlayerName);

	//Highscore muss extra geladen werden, da extra Format
	ifstream readHighscoreFile(szHighscoreFile);
	string sLine;
	char szLevel[256];
	int nPoints = 0;

	m_mapHighscore.clear();

	if (!readHighscoreFile)
		return false;

	while (!readHighscoreFile.eof())
    {
		getline(readHighscoreFile, sLine);
		sscanf(sLine.c_str(), "%s %d", szLevel, &nPoints);
		m_mapHighscore.insert(pair<string,int>(szLevel, nPoints));
    }

	readHighscoreFile.close();

	return true;
}

bool CSaveGame::UpdateHighscore(const char* szLevel, const int nPoints)
{
	string sLevel(szLevel);
	map<string,int>::iterator it;
	it = m_mapHighscore.find(sLevel);

	//Update der HS nur, wenn...
	if (nPoints >= 0 &&	//... Punkte positiv
		((it != m_mapHighscore.end() && it->second < nPoints)	//... Punkte h�her als aktuelle
		|| it == m_mapHighscore.end())) //... nicht das Ende der Map
	{
		m_mapHighscore[sLevel] = nPoints;
		return true;
	}

	return false;
}

bool CSaveGame::Save(const char* szFile, const char* szHighscoreFile)
{
	ofstream writeFile(szFile, ios::binary);

	if (!writeFile)
		return false;

	//Speichern der Benutzereinstellungen als serialisiertes SSaveData struct
#if defined(WIN32) && defined(_MSC_VER)
	writeFile.write((char*) &m_saveData, sizeof(m_saveData));
#else
	writeFile.write((char*) &m_saveData.nUnlockedLevel, sizeof(int));
	writeFile << m_saveData.sPlayerName;
#endif

	writeFile.close();

	//Highscore Map muss extra abgespeichert werden
	ofstream highscoreFile(szHighscoreFile);

	if (!highscoreFile)
		return false;

	map<string, int>::iterator it;

	for (it = m_mapHighscore.begin(); it != m_mapHighscore.end(); it++)
	{
		if (it->first.length() > 1 && it->second > 0)
			highscoreFile << it->first << " " << it->second << endl;
	}

	highscoreFile.close();

	return true;
}
