#ifndef SAVEGAME_HPP
#define SAVEGAME_HPP

#include "../globals.hpp"
#include <iostream>
#include <map>
#include <fstream>
#include <string>

using namespace std;

/// Struktur der zu serialisierenden Daten
struct SSaveData
{
	int nUnlockedLevel;	///< Bis zu diesem Level wurde freigeschalten
	string sPlayerName;	///< Spielername
};

/// Klasse zum Abspeichern von Spielerinfos wie Highscore und Levelfortschritt
class CSaveGame
{
	public:
		/// Konstruktor: Initialisierung
		CSaveGame(void);

		/// Dekonstruktor: Speicherfreigabe
		~CSaveGame(void);

		/// Abspeichern in Dateien. Highscore wird seperat von Benutzereinstellungen gespeichert
		bool Save(const char* szFile, const char* szHighscoreFile);

		/// Laden aus Dateien. Highscore wird seperat von Benutzereinstellungen gespeichert
		bool Load(const char* szFile, const char* szHighscoreFile);

		/// Bis zu diesem Level wurde freigeschalten
		SSaveData* GetSaveDataPointer() { return &m_saveData; }

		/// Highscore fuer jede Leveldatei wird die maximale bisher erreichte Punkteanzahl gespeichert
		/// Highscore realisiert als Map von <Level-Dateiname, Score>
		map<string, int>& GetHighscore() { return m_mapHighscore; }

		/// Highscore aktualisieren, falls neuer Highscoreeintrag
		bool UpdateHighscore(const char* szLevel, const int nPoints);

	private:
		SSaveData m_saveData;				///< Gespeicherte Daten als struct
		map<string, int> m_mapHighscore;	///< Highscore realisiert als Map von <Level-Dateiname, Score>
};

#endif
