#include "World.hpp"

CWorld::CWorld()
{
	m_pPlayerObj	= NULL;
	//m_Blocks.arBlock = NULL;
	m_pCurrBlock	= NULL;
	m_pmPlayers		= NULL;

	m_vCamPos.x		= 0.0f;
	m_vCamPos.y		= 0.0f;
	m_vCamPos.z		= 0.0f;
	/*m_vCamView.x	= 0.0f;
	m_vCamView.y	= 0.0f;
	m_vCamView.z	= 0.0f;*/

	/*m_nStartBlockX	= 0;
	m_nStartBlockY	= 0;
	m_nStartBlockZ	= 0;*/
	m_nEndBlockX	= 0;
	m_nEndBlockY	= 0;
	m_nEndBlockZ	= 0;

	m_fFuelAnimAngle = 0.0;

	m_nTransBlockCounter = 0;

	m_bAdjustPlayer = false;

	m_nPlayerStartPos = 0;

	//Alle Texturen und Modells laden... (Ja alle, das ist Verschwendung...)
	if (!g_pTexture->Load(TEX_WALL, "Data/Wall.png"))
		cerr << "Textur " << TEX_WALL << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_WHITE, "Data/Wall_white.png"))
		cerr << "Textur " << TEX_WALL_WHITE << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_BLUE, "Data/Wall_blue.png"))
		cerr << "Textur " << TEX_WALL_BLUE << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_RED, "Data/Wall_red.png"))
		cerr << "Textur " << TEX_WALL_RED << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_BLUEGRID, "Data/Wall_bluegrid.png"))
		cerr << "Textur " << TEX_WALL_BLUEGRID << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_BLUETECH, "Data/Wall_bluetech.png"))
		cerr << "Textur " << TEX_WALL_BLUETECH << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_BRIGHTBLUE, "Data/Wall_brightblue.png"))
		cerr << "Textur " << TEX_WALL_BRIGHTBLUE << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_TECH, "Data/Wall_tech.png"))
		cerr << "Textur " << TEX_WALL_TECH << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_WALL_GREENNUMBERS, "Data/Wall_greennumbers.png"))
		cerr << "Textur " << TEX_WALL_GREENNUMBERS << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_SKY1, "Data/sky1.png"))
		cerr << "Textur " << TEX_SKY1 << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_SKY2, "Data/sky2.png"))
		cerr << "Textur " << TEX_SKY2 << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_SKY3, "Data/sky3.png"))
		cerr << "Textur " << TEX_SKY3 << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_SKY4, "Data/sky4.png"))
		cerr << "Textur " << TEX_SKY4 << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_STARTPLATFORM, "Data/platform.png"))
		cerr << "Textur " << TEX_STARTPLATFORM << " konnte nicht geladen werden!";

	if (!g_pModel->Load(MODEL_STARTPLATFROM, "Data/platform.obj"))
		cerr << "Modell " << MODEL_STARTPLATFROM << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_FUEL, "Data/fuel.png"))
		cerr << "Textur " << TEX_FUEL << " konnte nicht geladen werden!";

	if (!g_pModel->Load(MODEL_FUEL, "Data/fuel.obj"))
		cerr << "Modell " << MODEL_FUEL << " konnte nicht geladen werden!";

	if (!g_pTexture->Load(TEX_STAR, "Data/star.png"))
		cerr << "Textur " << TEX_STAR << " konnte nicht geladen werden!";

	if (!g_pModel->Load(MODEL_STAR, "Data/star.obj"))
		cerr << "Modell " << MODEL_STAR << " konnte nicht geladen werden!";
}

CWorld::~CWorld(void)
{
	Clear();
}


bool CWorld::Reload()
{
	return LoadFromFile(m_szFile, false);
}

void CWorld::Clear()
{
	int iBlockX, iBlockY;

	//Jeden Block loeschen
	for (iBlockX = 0; iBlockX < (int)m_Blocks.size(); iBlockX++)
	{
		for (iBlockY = 0; iBlockY < (int)m_Blocks.at(iBlockX).size(); iBlockY++)
		{
			m_Blocks.at(iBlockX).at(iBlockY).clear();
		}

		m_Blocks.at(iBlockX).clear();
	}

	m_Blocks.clear();
}

bool CWorld::LoadFromFile(char* szFile, bool bInitPlayer)
{
	Clear();

	ifstream ifsWorldFile(szFile);

	//Leveldatei setzen fuer event. Reload
	strncpy(m_szFile, szFile, 256);

	if (!ifsWorldFile.is_open())
		return false;

	int iBlockX = 0, iBlockY = 0, iBlockZ  = 0;

	vector< vector< SBlock > > currRow;
	vector<SBlock> currField;
	SBlock currBlock;
	string sLine;
	vector<string> vBlocks;	//String Tokens f�r Bl�cke

	m_vStartBlocks.clear();

	//Zeile f�r Zeile einlesen
	while(!ifsWorldFile.eof())
	{
		getline(ifsWorldFile, sLine);
		CFileTools::TrimStr(sLine);

		//Zeile nicht leer und kein Kommentar? Dann einlesen!
		if (sLine.length() > 0 && sLine.at(0) != '/')
		{
			if (sLine.at(0) == '}')	//Ende einer Reihe
			{
				//Reihe in Vektor speichern
				m_Blocks.push_back(currRow);
				currRow.clear();
				iBlockY = 0;
				iBlockX++;
			}
			else if (sLine.at(0) != '{')	//Normale Blockdefinition
			{
				CFileTools::TokenizeStr(sLine, vBlocks, ";");	//Einzelne Blocklisten f�r dieses Feld sind mit Semikolon getrennt

				if (vBlocks.size() > 0)
				{
					//Token f�r Token, also Block f�r Block verarbeiten
					//Blocklistenformat: (<anfangsh�he>, <endh�he>, <textur>, <spezial>)
					for (iBlockZ = 0; iBlockZ < (int)vBlocks.size(); iBlockZ++)
					{
						sscanf(
							vBlocks.at(iBlockZ).c_str(),
							"(%d, %d, %d, %d)",
							&currBlock.nBeginHeight,
							&currBlock.nEndHeight,
							&currBlock.nTexture,
							&currBlock.nSpecial
						);

						//Spezialbl�cke merken
						if (currBlock.nSpecial == SPECIAL_BLOCK_START)
						{
							SBlockCoord startBlockCoord = { iBlockX, iBlockY, iBlockZ };
							m_vStartBlocks.push_back(startBlockCoord);
						}
						if (currBlock.nSpecial == SPECIAL_BLOCK_END)
						{
							m_nEndBlockX = iBlockX;
							m_nEndBlockY = iBlockY;
							m_nEndBlockZ = iBlockZ;
						}

						//Aktuellen Block in Vektor speichern
						currField.push_back(currBlock);
					}

					//Aktuelles Feld mit Bl�cken in Vektor speichern
					currRow.push_back(currField);
					currField.clear();
					iBlockY++;

					vBlocks.clear(); //Nicht vergessen: Tokens wieder leeren f�r die n�chste Zeile!
				}
			}
		}
	}

	/*for (int x = 0; x < m_Blocks.size(); x++)
	{
		for (int y = 0; y < m_Blocks.at(x).size(); y++)
		{
			for (int z = 0; z < m_Blocks.at(x).at(y).size(); z++)
			{
				cout << x << ", " << y << ", " << z << ": " << m_Blocks.at(x).at(y).at(z).nBeginHeight << ", " << m_Blocks.at(x).at(y).at(z).nEndHeight << ", " << m_Blocks.at(x).at(y).at(z).nTexture << ", " << m_Blocks.at(x).at(y).at(z).nSpecial << endl;
			}
		}
	}*/

	ifsWorldFile.close();

	// Position & Kamera initialisieren
	if (bInitPlayer)
	{
		if (!SetupLevel())
			return false;
	}

	// Bl�cke in CallList speichern
	//GenCallList();

	//Skybox generieren
	GenSkyBox();

	return true;
}

bool CWorld::SetupLevel()
{
	m_vCamPos.x		= 3.0f;
	m_vCamPos.y		= 0.0f;
	m_vCamPos.z		= 0.0f;
	m_fCamDistance	= 5.0f;
	m_fCamAngle		= 60.0f;

	if (m_nPlayerStartPos + 1 > m_vStartBlocks.size())
	{
		cerr << "Error: Startpositionsindex ist zu gross fuer diese Map!" << endl;
		return false;
	}

	SetPlayerOnBlock(m_vStartBlocks[m_nPlayerStartPos].x,
		m_vStartBlocks[m_nPlayerStartPos].y, m_vStartBlocks[m_nPlayerStartPos].z);

	return true;
}

void CWorld::SetPlayerOnBlock(int nBlockX, int nBlockY, int nBlockZ)
{
	m_pPlayerObj->fPosX = (float)nBlockX;
	m_pPlayerObj->fPosZ = (float)nBlockY;
	m_pPlayerObj->fPosY = (float) ((GetBlock(nBlockX, nBlockY, nBlockZ)->nEndHeight)) + m_pPlayerObj->PlayerColl.fPlayerHeight;
}

void CWorld::DrawWorld()
{
		//Boden	malen
		float fWidth = (float)m_Blocks.size() - 0.5f;
		float fLength = (float)m_Blocks.at(0).size() - 0.5f;

		glDisable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		glColor3f(0.0f, 0.0f, 0.0f);
		glBegin(GL_QUADS);
			glTexCoord2f(0.0, 0.0); glVertex3f(-20.0, 0.0, 20.0);
			glTexCoord2f(0.0, 10.0); glVertex3f( 20.0, 0.0, 20.0);
			glTexCoord2f(10.0, 10.0); glVertex3f( 20.0, 0.0, -20.0);
			glTexCoord2f(10.0, 0.0); glVertex3f( -20.0, 0.0, -20.0);
		glEnd();
		glColor3f(1.0f, 1.0f, 1.0f);
		glEnable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);

		//Bloecke
		int iBlockX, iBlockY, iBlockZ;
		for (iBlockX = 0; iBlockX < (int)m_Blocks.size(); iBlockX++)
		{
			for (iBlockY = 0; iBlockY < (int)m_Blocks.at(iBlockX).size(); iBlockY++)
			{
				for (iBlockZ = 0; iBlockZ < (int)m_Blocks.at(iBlockX).at(iBlockY).size(); iBlockZ++)
				{
					DrawBlock(iBlockX, iBlockY, iBlockZ);
				}
			}
		}
}

void CWorld::GenSkyBox()
{
	float fSkyBoxSize = 5.0f;

	m_nSkyBoxCallList = glGenLists(1);
	glNewList(m_nSkyBoxCallList, GL_COMPILE);
		//Block zeichnen
		g_pTexture->Use(TEX_SKY3);
		glBegin(GL_QUADS);
				// Front Face
				glNormal3f( 0.0f, 0.0f, 1.0f);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f(-fSkyBoxSize, -fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f( fSkyBoxSize, -fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f( fSkyBoxSize,  fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f(-fSkyBoxSize,  fSkyBoxSize,  fSkyBoxSize);
		glEnd();

		g_pTexture->Use(TEX_SKY1);
		glBegin(GL_QUADS);
				// Back Face
				glNormal3f( 0.0f, 0.0f, -1.0f);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f(-fSkyBoxSize, -fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f(-fSkyBoxSize,  fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f( fSkyBoxSize,  fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f( fSkyBoxSize, -fSkyBoxSize, -fSkyBoxSize);
		glEnd();

		g_pTexture->Use(TEX_SKY1);
		glBegin(GL_QUADS);
				// Top Face
				glNormal3f( 0.0f, 1.0f, 0.0f);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f(-fSkyBoxSize,  fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f(-fSkyBoxSize,  fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f( fSkyBoxSize,  fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f( fSkyBoxSize,  fSkyBoxSize, -fSkyBoxSize);
		glEnd();

		g_pTexture->Use(TEX_SKY2);
		glBegin(GL_QUADS);
				// Bottom Face
				glNormal3f( 0.0f, -1.0f, 0.0f);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f(-fSkyBoxSize, -fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f( fSkyBoxSize, -fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f( fSkyBoxSize, -fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f(-fSkyBoxSize, -fSkyBoxSize,  fSkyBoxSize);
		glEnd();

		g_pTexture->Use(TEX_SKY2);
		glBegin(GL_QUADS);
				// Right face
				glNormal3f( 1.0f, 0.0f, 0.0f);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f( fSkyBoxSize, -fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f( fSkyBoxSize,  fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f( fSkyBoxSize,  fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f( fSkyBoxSize, -fSkyBoxSize,  fSkyBoxSize);
		glEnd();

		g_pTexture->Use(TEX_SKY4);
		glBegin(GL_QUADS);
				// Left Face
				glNormal3f( -1.0f, 0.0f, 0.0f);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f(-fSkyBoxSize, -fSkyBoxSize, -fSkyBoxSize);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f(-fSkyBoxSize, -fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f(-fSkyBoxSize,  fSkyBoxSize,  fSkyBoxSize);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f(-fSkyBoxSize,  fSkyBoxSize, -fSkyBoxSize);
		glEnd();
	glEndList();
}

void CWorld::Draw()
{
	m_nTransBlockCounter = 0;

	//SkyBox anzeigen
	DrawSkyBox();

	//Kamerasteuerung
	gluLookAt(m_vCamPos.x, m_vCamPos.y, m_vCamPos.z, m_pPlayerObj->fPosX, m_pPlayerObj->fPosY, m_pPlayerObj->fPosZ, 0.0, 1.0, 0.0);

	//Bloecke die im Weg sind sollen transparent werden. Diese herausfinden...
	FindTransparentBlocks();

	//Welt malen
	DrawWorld();
}

void CWorld::DrawSkyBox()
{
	//Fuer die Skybox wird Beleuchtung und Z-Buffer ausgeschalten und man stellt gluLookAt so ein,
	//das man sich immer in der Mitte der Box befindet. Dadurch bewegt sich die Box nicht mit
	//und es entsteht ein authentisches Gefuehl des unendlich entfernten Horizonts
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);

	glPushMatrix();
		glLoadIdentity();

		//Man ist immer in der Mitte der Box und schaut in Richtung Spieler-Modell
		gluLookAt(0.0, 0.0, 0.0, m_pPlayerObj->fPosX - m_vCamPos.x, m_pPlayerObj->fPosY - m_vCamPos.y, m_pPlayerObj->fPosZ - m_vCamPos.z, 0.0, 1.0, 0.0);

		glCallList(m_nSkyBoxCallList);
	glPopMatrix();

	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);
}

void CWorld::DrawTransparentObjects()
{
	for (int i = m_nTransBlockCounter - 1; i >= 0; i--)
	{
		DrawBlock(m_arTransBlocks[i][0], m_arTransBlocks[i][1], m_arTransBlocks[i][2], true);
	}
}

void CWorld::FindTransparentBlocks()
{
	CVec2D vIntersect;
	CVec2D vPlayerPos2D;
	CVec2D vBlockPos2D;
	CVec2D vCamPos2D;
	float fBeginHeight, fEndHeight, fHalfWidth, fBeginHeightForIntersect;

	vPlayerPos2D.x	= m_pPlayerObj->fPosX;
	vPlayerPos2D.y	= m_pPlayerObj->fPosZ;
	vCamPos2D.x		= m_vCamPos.x;
	vCamPos2D.y		= m_vCamPos.z;
	fHalfWidth		= 0.5;

	int iBlockX, iBlockY, iBlockZ;
	float fIntersectHeightSq = 0.0f;
	//Block fuer Block...
	for (iBlockX = 0; iBlockX < (int)m_Blocks.size(); iBlockX++)
	{
		for (iBlockY = 0; iBlockY < (int)m_Blocks.at(iBlockX).size(); iBlockY++)
		{
			vBlockPos2D.x	= (float)iBlockX;
			vBlockPos2D.y	= (float)iBlockY;

			iBlockZ = -1;
			for (iBlockZ = 0; iBlockZ < (int)m_Blocks.at(iBlockX).at(iBlockY).size(); iBlockZ++)
			{
				fBeginHeight	= (float)m_Blocks.at(iBlockX).at(iBlockY).at(iBlockZ).nBeginHeight;
				fEndHeight		= (float)m_Blocks.at(iBlockX).at(iBlockY).at(iBlockZ).nEndHeight;

				//Testen, ob Block im Weg ist:
				if (//m_pPlayerObj->fPosY > fBeginHeight &&		//Block muss h�her liegen als Spielerobjekt
					m_pPlayerObj->fPosY < fEndHeight &&		//Block muss h�her liegen als Spielerobjekt
					m_pPlayerObj->fPosY < m_vCamPos.y &&	//Kamera muss von oben darauf schauen
					CVec2D::LineHitsCircle(vPlayerPos2D, vCamPos2D, vBlockPos2D, 1.0f, &vIntersect))	//In der 2D-Ansicht von oben, muss der Block mit der Strecke zwischen Kamera und Spielerposition geschnitten werden
				{
					//Das Quadrat der Schnitth�he der Strecke zwischen Kamera und Spieler mit dem Block berechnen
					//Streckensatz: H�he Kamera / Abstand Kamera-Spieler = H�he Schnitt / Abstand Schnitt-Spieler
					//H�he Schnitt     =          Hoehe Kamera                *              Abstand Schnitt-Spieler     /        Abstand Kamera-Spieler
					fIntersectHeightSq = (SQR(m_vCamPos.y - m_pPlayerObj->fPosY) * (vPlayerPos2D - vIntersect).SqrLength()) / (vCamPos2D - vPlayerPos2D).SqrLength();

					/*fBeginHeightForIntersect = fBeginHeight - 3.0;
					if (fBeginHeightForIntersect < 0.0)
						fBeginHeightForIntersect = 0.0;*/

					//cout << "Schitthoehe: " << fIntersectHeightSq << /* " | Beginnhoehe: " << SQR(fBeginHeightForIntersect) <<*/ " | Endhoehe: " << SQR(fEndHeight + 1.0) << endl;

					//Wenn die Schnitth�he mit dem Block kleiner ist, als der Block, wurder der Block geschnitten!
					if (/*fIntersectHeightSq >= SQR(fBeginHeightForIntersect)
						&&*/ fIntersectHeightSq <= SQR(fEndHeight + 1.0)
						&& m_nTransBlockCounter <= 255)
					{
						//Im Array der transparenten Bl�cke speichern und Arraygr��e hochz�hlen
						m_arTransBlocks[m_nTransBlockCounter][0] = iBlockX;
						m_arTransBlocks[m_nTransBlockCounter][1] = iBlockY;
						m_arTransBlocks[m_nTransBlockCounter][2] = iBlockZ;
						m_nTransBlockCounter++;
					}
				}
			}
		}
	}
}

void CWorld::DrawBlock(int iBlockX, int iBlockY, int iBlockZ, bool bDrawTransp)
{
	float fHalfWidth	= 0.5;
	float fBeginHeight	= (float)m_Blocks.at(iBlockX).at(iBlockY).at(iBlockZ).nBeginHeight;
	float fEndHeight	= (float)m_Blocks.at(iBlockX).at(iBlockY).at(iBlockZ).nEndHeight;
	float fHeight		= (fEndHeight - fBeginHeight);
	float fHalfHeight	= fHeight * 0.5;
	float fBlockX		= (float)iBlockX;
	float fBlockY		= (float)iBlockY;

	//Transparente Bl�cke nicht zeichnen?
	if (!bDrawTransp)
	{
		for (int i = 0; i < m_nTransBlockCounter; i++)
		{
			if (m_arTransBlocks[i][0] == iBlockX
				&& m_arTransBlocks[i][1] == iBlockY
				&& m_arTransBlocks[i][2] == iBlockZ)
			{
				return;
			}
		}
	}

	//Zeichnen!
	glPushMatrix();
		//An die richtige Position setzen
		glTranslatef(
			fBlockX,
			fBeginHeight + fHalfHeight,
			fBlockY
		);

		//Transparent zeichnen?
		//glPushAttrib(GL_COLOR_BUFFER_BIT);
		if (bDrawTransp)
		{
			glEnable(GL_BLEND);
		}

		//Eventuell Modells auf die Felder setzen
		switch (m_Blocks.at(iBlockX).at(iBlockY).at(iBlockZ).nSpecial)
		{
			//Bonusfeld
			case SPECIAL_BLOCK_BONUS:
				glPushMatrix();
					glTranslatef(0.0, fHalfHeight + 0.25, 0.0);
					glRotatef(m_fFuelAnimAngle, 0.0, 1.0, 0.0);	//Dreh-Animation
					glScalef(0.28, 0.28, 0.28);
					g_pTexture->Use(TEX_STAR);
					g_pModel->Draw(MODEL_STAR);
				glPopMatrix();
			break;

			//Tankfeld
			case SPECIAL_BLOCK_FUEL:
				glPushMatrix();
					glTranslatef(0.0, fHalfHeight + 0.25, 0.0);
					glRotatef(m_fFuelAnimAngle, 0.0, 1.0, 0.0);	//Dreh-Animation
					glRotatef(30.0, 1.0, 0.0, 0.0);
					glScalef(0.2, 0.2, 0.2);
					g_pTexture->Use(TEX_FUEL);
					g_pModel->Draw(MODEL_FUEL);
				glPopMatrix();
			break;

			//Startplattform hat momentan das selbe Modell wie Zielplattform
			case SPECIAL_BLOCK_START:
			case SPECIAL_BLOCK_END:
				glPushMatrix();
					glTranslatef(0.0, fHalfHeight + 0.01, 0.0);
					glScalef(0.5, 0.5, 0.5);
					g_pTexture->Use(TEX_STARTPLATFORM);
					g_pModel->Draw(MODEL_STARTPLATFROM);
				glPopMatrix();
			break;
		}

		//Textur setzen
		g_pTexture->Use(m_Blocks.at(iBlockX).at(iBlockY).at(iBlockZ).nTexture);

		//Block zeichnen
		glBegin(GL_QUADS);
				// Front Face
				glNormal3f( 0.0f, 0.0f, 1.0f);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f(-fHalfWidth, -fHalfHeight,  fHalfWidth);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f( fHalfWidth, -fHalfHeight,  fHalfWidth);
				glTexCoord2f(1.0f, fHeight);			glVertex3f( fHalfWidth,  fHalfHeight,  fHalfWidth);
				glTexCoord2f(0.0f, fHeight);			glVertex3f(-fHalfWidth,  fHalfHeight,  fHalfWidth);
				// Back Face
				glNormal3f( 0.0f, 0.0f, -1.0f);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f(-fHalfWidth, -fHalfHeight, -fHalfWidth);
				glTexCoord2f(1.0f, fHeight);			glVertex3f(-fHalfWidth,  fHalfHeight, -fHalfWidth);
				glTexCoord2f(0.0f, fHeight);			glVertex3f( fHalfWidth,  fHalfHeight, -fHalfWidth);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f( fHalfWidth, -fHalfHeight, -fHalfWidth);
				// Top Face
				glNormal3f( 0.0f, 1.0f, 0.0f);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f(-fHalfWidth,  fHalfHeight, -fHalfWidth);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f(-fHalfWidth,  fHalfHeight,  fHalfWidth);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f( fHalfWidth,  fHalfHeight,  fHalfWidth);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f( fHalfWidth,  fHalfHeight, -fHalfWidth);
				// Bottom Face
				glNormal3f( 0.0f, -1.0f, 0.0f);
				glTexCoord2f(1.0f, 1.0f);				glVertex3f(-fHalfWidth, -fHalfHeight, -fHalfWidth);
				glTexCoord2f(0.0f, 1.0f);				glVertex3f( fHalfWidth, -fHalfHeight, -fHalfWidth);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f( fHalfWidth, -fHalfHeight,  fHalfWidth);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f(-fHalfWidth, -fHalfHeight,  fHalfWidth);
				// Right face
				glNormal3f( 1.0f, 0.0f, 0.0f);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f( fHalfWidth, -fHalfHeight, -fHalfWidth);
				glTexCoord2f(1.0f, fHeight);			glVertex3f( fHalfWidth,  fHalfHeight, -fHalfWidth);
				glTexCoord2f(0.0f, fHeight);			glVertex3f( fHalfWidth,  fHalfHeight,  fHalfWidth);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f( fHalfWidth, -fHalfHeight,  fHalfWidth);
				// Left Face
				glNormal3f( -1.0f, 0.0f, 0.0f);
				glTexCoord2f(0.0f, 0.0f);				glVertex3f(-fHalfWidth, -fHalfHeight, -fHalfWidth);
				glTexCoord2f(1.0f, 0.0f);				glVertex3f(-fHalfWidth, -fHalfHeight,  fHalfWidth);
				glTexCoord2f(1.0f, fHeight);			glVertex3f(-fHalfWidth,  fHalfHeight,  fHalfWidth);
				glTexCoord2f(0.0f, fHeight);			glVertex3f(-fHalfWidth,  fHalfHeight, -fHalfWidth);
		glEnd();

		if (bDrawTransp)
		{
			glDisable(GL_BLEND);
		}
		//glPopAttrib();
	glPopMatrix();
}

bool CWorld::PlayerLanded()
{
	float fGoalRadius = 0.3f;

	if((SQR((float)m_vStartBlocks[m_nPlayerStartPos].x - m_pPlayerObj->fPosX) + SQR((float)m_vStartBlocks[m_nPlayerStartPos].y - m_pPlayerObj->fPosZ) <= SQR(fGoalRadius)
		&& (m_pPlayerObj->fPosY - (float)(GetBlock(m_vStartBlocks[m_nPlayerStartPos].x, m_vStartBlocks[m_nPlayerStartPos].y, m_vStartBlocks[m_nPlayerStartPos].z)->nEndHeight)) <= fGoalRadius))
		return true;

	if (PlayerReachesGoal()) return true;

	return false;
}

bool CWorld::PlayerReachesGoal()
{
	float fGoalRadius = 0.3f;

	return (SQR((float)m_nEndBlockX - m_pPlayerObj->fPosX) + SQR((float)m_nEndBlockY - m_pPlayerObj->fPosZ) <= SQR(fGoalRadius)
		&& (m_pPlayerObj->fPosY - (float)(GetBlock(m_nEndBlockX, m_nEndBlockY, m_nEndBlockZ)->nEndHeight)) <= fGoalRadius);
}

bool CWorld::PlayerReachesSpecialField(const int nSpecialType)
{
	float fGoalRadius = 0.5f;

	if(m_pCurrBlock->nSpecial == nSpecialType &&
		(SQR((float)m_nPlayerBlockX - m_pPlayerObj->fPosX) + SQR((float)m_nPlayerBlockY - m_pPlayerObj->fPosZ) <= SQR(fGoalRadius))
		&& (m_pPlayerObj->fPosY - (float)m_pCurrBlock->nEndHeight <= fGoalRadius))
	{
		m_pCurrBlock->nSpecial = SPECIAL_BLOCK_NONE;

		return true;
	}

	return false;
}


bool CWorld::PlayerCollides(ECollision* peCollSide1, ECollision* peCollSide2, int* pnCollPlayerID)
{
	*peCollSide1 = NONE;
	*peCollSide2 = NONE;
	int nCollPlayerID = -1;

	if (!m_pCurrBlock)	//Spieler ausserhalb des Spielfeldes!
	{
		*peCollSide1 = OUT_OF_FIELD;
		DEBUG_PRINTL("Kollision: Ausserhalb des Spielfeldes | " << m_nPlayerBlockX << ", " << m_nPlayerBlockY);
		return true;
	}

	//Spieler kollidiert mit Boden unter sich?
	if ((float)m_pCurrBlock->nEndHeight >= m_pPlayerObj->fPosY - m_pPlayerObj->PlayerColl.fPlayerHeight * 0.5)
	{
		*peCollSide1 = BENEATH;
		DEBUG_PRINTL("Kollision: Boden | " << (float)m_pCurrBlock->nEndHeight << ", " << m_pPlayerObj->fPosY - m_pPlayerObj->PlayerColl.fPlayerHeight * 0.5);
		return true;
	}

	//Spieler kollidiert mit Block ueber sich?
	SBlock* pAboveBlock = GetBlock(m_nPlayerBlockX, m_nPlayerBlockY, m_nPlayerBlockZ + 1);

	if (pAboveBlock != NULL)	//Es gibt einen Block drueber
	{
		if ((float)pAboveBlock->nBeginHeight <= m_pPlayerObj->fPosY + m_pPlayerObj->PlayerColl.fPlayerHeight * 0.5)
		{
			*peCollSide1 = ABOVE;
			DEBUG_PRINTL("Kollision: Block darueber | " << (float)pAboveBlock->nBeginHeight << ", " << m_pPlayerObj->fPosY + m_pPlayerObj->PlayerColl.fPlayerHeight * 0.5);
			return true;
		}
	}

	//Spieler kollidiert mit Spieler im selben Block?
	SPlayerObj* pCollPlayer;

	if (m_pmPlayers
		&& ((pCollPlayer = PlayerVsPlayerCollision(m_nPlayerBlockX, m_nPlayerBlockY)) != NULL))
	{
		if (pCollPlayer->fPosY - (m_pPlayerObj->fPosY + m_pPlayerObj->PlayerColl.fPlayerHeight) > -0.1)
		{
			//*peCollSide1 = ABOVE;
			m_pPlayerObj->fPosY = pCollPlayer->fPosY - m_pPlayerObj->PlayerColl.fPlayerHeight;
		}
		else
		{
			//*peCollSide1 = BENEATH;
			m_pPlayerObj->fPosY = pCollPlayer->fPosY + m_pPlayerObj->PlayerColl.fPlayerHeight;
		}

		if (pCollPlayer->fPosX - m_pPlayerObj->fPosX > 0)
			*peCollSide1 = RIGHT;
		else
			*peCollSide1 = LEFT;

		*pnCollPlayerID = pCollPlayer->nID;
		return true;
	}

	//Spieler kollidiert mit umliegenden Bloecken?

	//1. Rechts:
	if (CHECK_SIDE(1, 0, BLOCK_LEFT, 0))
	{
		*peCollSide1 = RIGHT;
		DEBUG_PRINTL("Kollision: Rechts");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}

	//2. Unten rechts:
	if (CHECK_SIDE(1, 1, BLOCK_LEFT, BLOCK_TOP))
	{
		*peCollSide1 = RIGHT;
		*peCollSide2 = BOTTOM;
		DEBUG_PRINTL("Kollision: Unten rechts");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}

	//3. Unten ("dahinter"):
	if (CHECK_SIDE(0, 1, BLOCK_TOP, 0))
	{
		*peCollSide1 = BOTTOM;
		DEBUG_PRINTL("Kollision: Unten");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}

	//4. Unten links:
	if (CHECK_SIDE(-1, 1, BLOCK_RIGHT, BLOCK_TOP))
	{
		*peCollSide1 = LEFT;
		*peCollSide2 = BOTTOM;
		DEBUG_PRINTL("Kollision: Unten links");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}

	//5. Links:
	if (CHECK_SIDE(-1, 0, BLOCK_RIGHT, 0))
	{
		*peCollSide1 = LEFT;
		DEBUG_PRINTL("Kollision: Links");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}


	//6. Oben links:
	if (CHECK_SIDE(-1, -1, BLOCK_RIGHT, BLOCK_BOTTOM))
	{
		*peCollSide1 = LEFT;
		*peCollSide2 = TOP;
		DEBUG_PRINTL("Kollision: Oben links");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}

	//7. Oben ("davor"):
	if (CHECK_SIDE(0, -1, BLOCK_BOTTOM, 0))
	{
		*peCollSide2 = TOP;
		DEBUG_PRINTL("Kollision: Oben");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}

	//8. Oben rechts:
	if (CHECK_SIDE(1, -1, BLOCK_LEFT, BLOCK_BOTTOM))
	{
		*peCollSide1 = RIGHT;
		*peCollSide2 = TOP;
		DEBUG_PRINTL("Kollision: Oben rechts");

		*pnCollPlayerID = nCollPlayerID;
		return true;
	}

	return false;
}

int CWorld::PlayerSideCollides(const int nBlockXOffset, const int nBlockYOffset, const int nBlockSide, const int nBlockSide2)
{
	int nTestFieldX = m_nPlayerBlockX + nBlockXOffset;
	int nTestFieldY = m_nPlayerBlockY + nBlockYOffset;
	int nCollPlayerID = -1;

	//Es gibt keinen Block neben an, sondern nur da Ende des Levels, daher...
	if (nTestFieldX < 0 || nTestFieldX >= (int)m_Blocks.size() ||
		nTestFieldY < 0 || nTestFieldY >= (int)m_Blocks.at(nTestFieldX).size())
	{
		if (PlayerBoxCollides(nBlockSide, nBlockSide2))	//...ist die Hoehe des Blocks egal
		{
			DEBUG_PRINTL(" ->Aussenwand!");
			return 0;
		}
	}
	else	//Ein Vektor von Bloecken steht nebenan...
	{
		vector<SBlock>* pvTestBlocks;
		pvTestBlocks = &m_Blocks.at(nTestFieldX).at(nTestFieldY);

		for (int i = 0; i < (int)pvTestBlocks->size(); i++)
		{
			if (pvTestBlocks->at(i).nEndHeight > m_pCurrBlock->nEndHeight &&		//...Kollision kann nur auftreten, wenn der Test Block h�her liegt...
				//vTestBlocks.at(i).nBeginHeight >= m_pCurrBlock->nEndHeight &&
				m_pPlayerObj->fPosY <= ((float)pvTestBlocks->at(i).nEndHeight) &&		//...der Spieler nicht �ber dem Test Block schwebt..
				m_pPlayerObj->fPosY >= ((float)pvTestBlocks->at(i).nBeginHeight) &&		//...und aucht nicht darunter..
				PlayerBoxCollides(nBlockSide, nBlockSide2) > -1)		//...und mit einem Testpunkt die Seite streift
			{
				DEBUG_PRINTL(" ->Block nebenan");
				return 0;
			}
		}

		///...bzw. ein oder mehrere Spieler
		if (m_pmPlayers)
		{
			SPlayerObj* pCollPlayer = PlayerVsPlayerCollision(nTestFieldX, nTestFieldY);

			if (pCollPlayer)
				return pCollPlayer->nID;
		}
	}

	return -1;
}

SPlayerObj* CWorld::PlayerVsPlayerCollision(int nTestFieldX, int nTestFieldY)
{
	int nPlayerX, nPlayerY, nPlayerZ;
	SPlayerObj sOtherPlayer;
	CVec2D vAbsPosLocalPlayer(m_pPlayerObj->fPosX, m_pPlayerObj->fPosZ), vAbsPosTempPlayer;
	//CVec2D vTestPoint(m_pPlayerObj->PlayerColl.fPlayerWidth * 0.5, m_pPlayerObj->PlayerColl.fPlayerLength * 0.5);
	CVec2D vIntersect;
	float fPlayerHeight = m_pPlayerObj->PlayerColl.fPlayerHeight;

	map<int, SPlayerObj>::iterator iter;
	for (iter = m_pmPlayers->begin(); iter != m_pmPlayers->end(); iter++)
	{
		sOtherPlayer = iter->second;

		if (sOtherPlayer.nID == m_pPlayerObj->nID || sOtherPlayer.bDead)
			continue;

		FindPlayerBlock(sOtherPlayer.fPosX, sOtherPlayer.fPosY, sOtherPlayer.fPosZ, &nPlayerX, &nPlayerY, &nPlayerZ);

		if (nPlayerX == nTestFieldX && nPlayerY == nTestFieldY
			&& m_pPlayerObj->fPosY + fPlayerHeight >= sOtherPlayer.fPosY
			&& m_pPlayerObj->fPosY <= sOtherPlayer.fPosY + fPlayerHeight)
		{
			DEBUG_PRINTL(" ->Spieler auf Block " << m_nPlayerBlockX << ", " << m_nPlayerBlockY << " gegen " << nTestFieldX << ", " << nTestFieldY);

			vAbsPosTempPlayer.x = sOtherPlayer.fPosX;
			vAbsPosTempPlayer.y = sOtherPlayer.fPosZ;

					/*if (CVec2D::RotRectHitsRotRect(vAbsPosLocalPlayer,
												   vAbsPosLocalPlayer + vTestPoint,
												   m_pPlayerObj->fAngleY,
												   vAbsPosTempPlayer,
												   vAbsPosTempPlayer + vTestPoint,
												   sOtherPlayer.fAngleY))
					{
						cout << "  ->Spielerkollision!" << endl;
					}*/

			//jede Linie des Rechtecks des eigenen Spielers wird mit jeder
			//des anderen Spielers auf Schnittpunkt getestet... d.h 16 Tests
			//es gibt vermutlich effizientere Möglichkeiten...
			for (int j = 0; j <= 3; j++)
			{
				for (int k = 0; k <= 3; k++)
				{
					// Nur so klappts unter Linux
					CVec2D vP1 = vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[j];
					CVec2D vP2 = vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[(j + 1) % 4];
					CVec2D vP3 = vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[k];
					CVec2D vP4 = vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[(k + 1) % 4];

					if (CVec2D::LineHitsLine(vP1, vP2, vP3, vP4, &vIntersect))
					{
						DEBUG_PRINTL("  ->Spielerkollision bei " << vIntersect.x << ", " << vIntersect.y);
						DEBUG_PRINTL("  ->Mit " << (vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[j]).x << ", " << (vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[j]).y << " | "
								<< (vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[(j + 1) % 4]).x << ", " << (vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[(j + 1) % 4]).y);
						DEBUG_PRINTL("  ->Und " << (vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[k]).x << ", " << (vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[k]).y << " | "
								<< (vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[(k + 1) % 4]).x << ", " << (vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[(k + 1) % 4]).y);

							/*glPushMatrix();
									glDisable(GL_LIGHTING);
									glColor3f(1.0,1.0,1.0);
									glBegin(GL_LINES);
										glVertex3f((vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[j]).x, m_pPlayerObj->fPosY, (vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[j]).y);
										glVertex3f((vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[(j + 1) % 4]).x, m_pPlayerObj->fPosY, (vAbsPosLocalPlayer + m_pPlayerObj->PlayerColl.vTestPoint[(j + 1) % 4]).y);
									//glEnd();
									glColor3f(0.0,1.0,0.0);
									//glBegin(GL_LINE);
										glVertex3f((vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[k]).x, m_pPlayerObj->fPosY, ( vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[k]).y);
										glVertex3f((vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[(k + 1) % 4]).x, m_pPlayerObj->fPosY, (vAbsPosTempPlayer + sOtherPlayer.PlayerColl.vTestPoint[(k + 1) % 4]).y);
									glEnd();
									glEnable(GL_LIGHTING);
								glPopMatrix();*/

						return &sOtherPlayer;
					}
				}
			}
		}
	}

	return NULL;
}


int CWorld::PlayerBoxCollides(const int nBlockSide1, const int nBlockSide2)
{
	CVec2D	vPoint;
	bool	bCollOnSide1 = false;
	bool	bCollOnSide2 = false;

	//Jeden Eckpunkt der Kollisions-"Box" betrachten
	for (int i = 0; i <= 3; i++)
	{
		vPoint = m_pPlayerObj->PlayerColl.vTestPoint[i];
		vPoint.x += m_pPlayerObj->fPosX;
		vPoint.y += m_pPlayerObj->fPosZ;

		bCollOnSide1 = PlayerBoxPointCollides(&vPoint, nBlockSide1);

		//Auf eine Seite testen!
		if (nBlockSide2 == BLOCK_NOSIDE && bCollOnSide1)
		{
			if (m_bAdjustPlayer)
				AdjustPlayer(&vPoint, nBlockSide1);

			return i;
		}
		//Auf zwei Seiten testen!
		else if (nBlockSide2 != BLOCK_NOSIDE && bCollOnSide1 && PlayerBoxPointCollides(&vPoint, nBlockSide2))
		{
			if (m_bAdjustPlayer)
			{
				AdjustPlayer(&vPoint, nBlockSide1);
				AdjustPlayer(&vPoint, nBlockSide2);
			}

			return i;
		}

		bCollOnSide1 = false;
		bCollOnSide2 = false;
	}

	return -1;
}


inline void CWorld::AdjustPlayer(CVec2D* pvPoint, const int nBlockSide)
{
	//Auf welche Seite des Blocks wird getestet?
	switch (nBlockSide)
	{
		case BLOCK_LEFT:
			m_pPlayerObj->fPosX  -= pvPoint->x - (m_nPlayerBlockX + 0.5);
		break;

		case BLOCK_TOP:
			m_pPlayerObj->fPosZ  -= pvPoint->y - (m_nPlayerBlockY + 0.5);
		break;

		case BLOCK_RIGHT:
			m_pPlayerObj->fPosX  += (m_nPlayerBlockX - 0.5) - pvPoint->x;
		break;

		case BLOCK_BOTTOM:
			m_pPlayerObj->fPosZ  += (m_nPlayerBlockY - 0.5) - pvPoint->y;
		break;
	}
}


inline bool CWorld::PlayerBoxPointCollides(CVec2D* pvPoint, const int nBlockSide)
{
	//Auf welche Seite des Blocks wird getestet?
	switch (nBlockSide)
	{
		case BLOCK_LEFT:
			if (pvPoint->x >= ((float)m_nPlayerBlockX + 0.5))
			{
				//cout << "Kollision: Block rechts | " << vPoint.x << ", " << ((float)nBlockX - 0.5) * BLOCK_SCALE  << endl;
				//m_pPlayerObj->fPosX  -= pvPoint->x - (m_nPlayerBlockX + 0.5);
				return true;
			}
		break;

		case BLOCK_TOP:
			if (pvPoint->y >= ((float)m_nPlayerBlockY + 0.5))
			{
				//cout << "Kollision: Block unten | " << vPoint.y << ", " << ((float)nBlockY - 0.5) * BLOCK_SCALE  << endl;
				//m_pPlayerObj->fPosZ  -= pvPoint->y - (m_nPlayerBlockY + 0.5);
				return true;
			}
		break;

		case BLOCK_RIGHT:
			if (pvPoint->x <= ((float)m_nPlayerBlockX - 0.5))
			{
				//cout << "Kollision: Block links | " << vPoint.x << ", " << ((float)nBlockX + 0.5) * BLOCK_SCALE  << endl;
				//m_pPlayerObj->fPosX  += (m_nPlayerBlockX - 0.5) - pvPoint->x;
				return true;
			}
		break;

		case BLOCK_BOTTOM:
			if (pvPoint->y <= ((float)m_nPlayerBlockY - 0.5))
			{
				//cout << "Kollision: Block oben | " << vPoint.y << ", " << ((float)nBlockY + 0.5) * BLOCK_SCALE  << endl;
				//m_pPlayerObj->fPosZ  += (m_nPlayerBlockY - 0.5) - pvPoint->y;
				return true;
			}
		break;
	}

	return false;
}

SBlock* CWorld::GetBlock(const int nBlockX, const int nBlockY, const int nBlockZ)
{
	//Blockkoord. au�erhalb des Spielfeldes?
	if (nBlockX < 0 || nBlockY < 0 || nBlockZ < 0 ||
		nBlockX >= (int)m_Blocks.size() || nBlockY >= (int)m_Blocks.at(nBlockX).size() || nBlockZ >= (int)m_Blocks.at(nBlockX).at(nBlockY).size())
	{
		return NULL;
	}

	return &m_Blocks.at(nBlockX).at(nBlockY).at(nBlockZ);
}

void CWorld::Update()
{
	ProcessMoving();

	//Kamera bewegen
	MoveCam();

	//Animationsvariablen inkrementieren
	m_fFuelAnimAngle += g_pTimer->GetElapsed() * 10.0;
	if (m_fFuelAnimAngle > 360.0)
		m_fFuelAnimAngle -= 360.0;

	//Block herausfinden, �ber dem sich der Spieler gerade befindet
	FindPlayerBlock(m_pPlayerObj->fPosX, m_pPlayerObj->fPosY, m_pPlayerObj->fPosZ, &m_nPlayerBlockX, &m_nPlayerBlockY, &m_nPlayerBlockZ);

	m_pCurrBlock = GetBlock(m_nPlayerBlockX, m_nPlayerBlockY, m_nPlayerBlockZ);
}

void CWorld::FindPlayerBlock(const float fPosX, const float fPosY, const float fPosZ, int* pnBlockX, int* pnBlockY, int* pnBlockZ)
{
	*pnBlockX = (int) (fPosX + 0.5f);
	*pnBlockY = (int) (fPosZ + 0.5f);
	*pnBlockZ = 0;
	SBlock* currBlock;

	int iBlockZ = -1;
	do
	{
		iBlockZ++;
		currBlock = GetBlock(*pnBlockX, *pnBlockY, iBlockZ);
		if (currBlock != NULL &&
			(float)currBlock->nEndHeight <= fPosY)
		{
			*pnBlockZ = iBlockZ;
		}
	} while (currBlock != NULL && iBlockZ < (int)m_Blocks.at(*pnBlockX).at(*pnBlockY).size());
}

void CWorld::MoveCam()
{
	//Kamera hinter dem Objekt positionieren
	m_vCamPos.x		= m_pPlayerObj->fPosX;
	m_vCamPos.y		= CAM_HEIGHT + sinf(m_fCamAngle * DEG2RAD) * m_fCamDistance;
	if (m_vCamPos.y < m_pPlayerObj->fPosY + 0.5)
		m_vCamPos.y = m_pPlayerObj->fPosY + 0.5;
	m_vCamPos.z		= m_pPlayerObj->fPosZ - cosf(m_fCamAngle * DEG2RAD) * m_fCamDistance;
}

void CWorld::ProcessMoving()
{
	const float fSens = 1.0;

	//Nach vorn gehen
	if (g_pFramework->KeyDown(SDLK_w) && m_fCamDistance > CAM_MIN_DISTANCE)
	{
		m_fCamDistance -= 0.1f * fSens;
	}

	//Nach hinten gehen
	if (g_pFramework->KeyDown(SDLK_s) && m_fCamDistance < CAM_MAX_DISTANCE)
	{
		m_fCamDistance += 0.1f * fSens;
	}

	//Nach oben
	if (g_pFramework->KeyDown(SDLK_e) && m_fCamAngle < CAM_MAX_ANGLE)
	{
		m_fCamAngle += 1.0f * fSens;
	}

	//Nach unten
	if (g_pFramework->KeyDown(SDLK_d) && m_fCamAngle > CAM_MIN_ANGLE)
	{
		m_fCamAngle -= 1.0f * fSens;
	}
}
