#include <algorithm>

#include "Gui.hpp"
#include "../game/Game.hpp"

CGui::CGui(CGame* pGame, SPlayerObj* pPlayerObj)
{
	m_pGame = pGame;
	m_pPlayerObj = pPlayerObj;
	m_fFlashingTimer = 0.0;
	m_nLastStatsRefresh = 0;

	if (m_pGame->IsMPlayer())
		m_nLocalPlayerID = m_pGame->GetClient()->GetLocalPlayerID();
	else
		m_nLocalPlayerID = 0;
}

CGui::~CGui(void)
{

}

float CGui::GetPlayingTime()
{
    return m_pGame->GetLevelTimer();
}

void CGui::Update()
{
	if (m_pGame->IsMPlayer())
	{
		vector<SPlayer> vPlayers;

		//Stats update
		if (m_nLastStatsRefresh + STATS_REFRESH_TIME < SDL_GetTicks())
		{
			vPlayers = m_pGame->GetClient()->GetPlayer();
			m_vPlayerStats.clear();

			m_pGame->GetClient()->LockMutex();
			for (int i = 0; i < vPlayers.size(); i++)
			{
				//wir muessen das kopieren, denn wir wollen ja nicht die Reihenfolge von m_vPlayers in CClient aendern!
				m_vPlayerStats.push_back(vPlayers[i]);
			}
			m_pGame->GetClient()->UnlockMutex();

			sort(m_vPlayerStats.begin(), m_vPlayerStats.end(), CClient::SortPlayerStats);
			m_nLastStatsRefresh = SDL_GetTicks();
		}
	}
}

void CGui::Draw()
{
	Update();

	C2DTools::Enter2DMode();
		g_pText->SetFont();	//Zuruecksetzen auf Standard!
			//FPS anzeigen
			int nFPS = (int) (1 / g_pTimer->GetElapsed());
			if (nFPS > 99)
				nFPS = 99;
			else if (nFPS < 0)
				nFPS = 0;

			g_pText->SetFont(GLUT_BITMAP_HELVETICA_18, 1.0, 0.0, 0.0);
			g_pText->DrawStr((GLsizei) SCREEN_RES_X-130,(GLsizei) SCREEN_RES_Y-60, "%d fps", nFPS);

			//Zeit anzeigen
			g_pText->SetFont(GLUT_BITMAP_HELVETICA_18, 1.0, 1.0, 1.0);
			float fLevelTimer = m_pGame->GetLevelTimer();
			int nMin = (int)(fLevelTimer / 60.0);
			int nSec = (int)(fLevelTimer - nMin * 60);
			g_pText->DrawStr((GLsizei) 20,(GLsizei) SCREEN_RES_Y-60, "%02d:%02d", nMin, nSec);

			//Level anzeigen
			g_pText->SetFont();
			if (m_pGame->IsMPlayer())
				g_pText->DrawStr(20,(GLsizei) SCREEN_RES_Y-30, "Level: %02d/%02d", m_pGame->GetCurrentLevel() + 1, m_pGame->GetClient()->GetRunningGame()->nNumLevels);
			else
				g_pText->DrawStr(20,(GLsizei) SCREEN_RES_Y-30, "Level: %02d", m_pGame->GetCurrentLevel());

			//Leben anzeigen
			if (!m_pGame->IsMPlayer())
				g_pText->DrawStr((GLsizei) SCREEN_RES_X-130,(GLsizei) SCREEN_RES_Y-30,"Lives: %d", m_pPlayerObj->nLives);

			if (m_pGame->IsMPlayer())
			{
				//Spielerstats anzeigen
				for (int i = 0; i < m_vPlayerStats.size(); i++)
				{
					if (m_vPlayerStats[i].sInfo.nID == m_nLocalPlayerID)
						g_pText->SetFont(GLUT_BITMAP_8_BY_13, 0.0, 1.0, 0.0);
					else
						g_pText->SetFont(GLUT_BITMAP_8_BY_13, 0.0, 0.8, 0.0);

					g_pText->DrawStr(20, (GLsizei) SCREEN_RES_Y - (80 + 20 * i),
						"#%d: %s (%d)",
						(i+1), m_vPlayerStats[i].sInfo.szName, (int)m_vPlayerStats[i].sIngameInfo.nRoundsWon
					);
				}
				g_pText->SetFont();

				//Damage als Balken anzeigen
				if (!m_pPlayerObj->bDead)
				{
					g_pText->DrawStr(20, 40, "Dmg:");

					glColor4f(0.0, 0.8, 0.0, 1.0);
					C2DTools::DrawLine(79, 37, 181, 37);
					C2DTools::DrawLine(79, 37, 79, 50);
					C2DTools::DrawLine(79, 50, 181, 50);
					C2DTools::DrawLine(181, 37, 181, 50);

					glEnable(GL_BLEND);
						float fDmg = m_pPlayerObj->fDmg;

						glColor4f(fDmg / 100.0, (1.0 - fDmg / 100.0), 0.0, 0.9);
						C2DTools::DrawRect(80, 38, (int)fDmg, 12);
					glDisable(GL_BLEND);
				}
			}

			//Fuel als Balken anzeigen
			if (!m_pPlayerObj->bDead)
			{
				g_pText->DrawStr(20,20, "Fuel:");

				glColor4f(0.0, 0.8, 0.0, 1.0);
				C2DTools::DrawLine(79, 17, 181, 17);
				C2DTools::DrawLine(79, 17, 79, 30);
				C2DTools::DrawLine(79, 30, 181, 30);
				C2DTools::DrawLine(181, 17, 181, 30);

				glEnable(GL_BLEND);
					float fFuel = m_pPlayerObj->fFuel;

					glColor4f((1.0 - fFuel / 100.0), fFuel / 100.0, 0.0, 0.9);
					C2DTools::DrawRect(80, 18, (int)fFuel, 12);
				glDisable(GL_BLEND);

				//Abstand zum Boden als vertikalen Balken anzeigen
				glEnable(GL_BLEND);
				float fGroundDist = m_pPlayerObj->fPosY;

					//Kasten drumherum
					glColor4f(0.0, 0.8, 0.0, 1.0);
					C2DTools::DrawLine(SCREEN_RES_X - 21, 10, SCREEN_RES_X - 8, 10);
					C2DTools::DrawLine(SCREEN_RES_X - 21, 110, SCREEN_RES_X - 8, 110);
					C2DTools::DrawLine(SCREEN_RES_X - 21, 10, SCREEN_RES_X - 21, 110);
					C2DTools::DrawLine(SCREEN_RES_X - 8, 10, SCREEN_RES_X - 8, 110);

					//Abstand einteilen
					glColor4f(1.0, 1.0, 1.0, 0.9);
					for (int iLevel = 1; iLevel < 5; iLevel++)
					{
						C2DTools::DrawLine(SCREEN_RES_X - 21, 10 + iLevel * 25, SCREEN_RES_X - 8, 10 + iLevel * 25);
					}

					if (fGroundDist > 0.0)
					{
						glColor4f(0.0, 1.0, 0.0, 0.9);
						C2DTools::DrawRect(SCREEN_RES_X - 20, 10, 12, (int)((fGroundDist - 1.0) / 4.0 * 100.0));
					}
				glDisable(GL_BLEND);
			}

			//Score anzeigen
			if (!m_pGame->IsMPlayer())
			{
				g_pText->DrawStr((GLsizei) SCREEN_RES_X-130,20,"Score: %d", m_pPlayerObj->nScore);
			}

		g_pText->SetFont();	//Zur�cksetzen auf Standard!
	C2DTools::Leave2DMode();
}

void CGui::DrawWarning(const char *szText, int nXPos, int nYPos, float fFlashingTime)
{
	m_fFlashingTimer += g_pTimer->GetElapsed();

	if (m_fFlashingTimer >= fFlashingTime)	//immer nur f�r eine Sekunde anzeigen -> Blinkeffekt
	{
		C2DTools::Enter2DMode();
			g_pText->SetFont(GLUT_BITMAP_HELVETICA_18, 0.0, 1.0, 0.0);	//leuchtend rot & gro�!
			g_pText->DrawStr((GLsizei)nXPos,(GLsizei)nYPos, szText);
		C2DTools::Leave2DMode();

		if (m_fFlashingTimer >= 2 * fFlashingTime)	//Zur�cksetzen
			m_fFlashingTimer -= 2 * fFlashingTime;
	}
}
