#ifndef GUI_HPP
#define GUI_HPP

#include <vector>

#include "../globals.hpp"
#include "../client/PlatformFramework.hpp"
#include "../client/Client.hpp"
#include "../tools/2DTools.hpp"
#include "../tools/Vec3D.hpp"
#include "../tools/Timer.hpp"
#include "../net/NetworkTypes.hpp"

#include "Text.hpp"

#define STATS_REFRESH_TIME	1000

class CGame;
struct SPlayer;

using namespace std;

/// GUI-Klasse
/// Zeichnet das GUI mit Anzeigen wie Leben, Punkte, Zeit, FPS usw.
class CGui
{
	public:
		/// Konstruktor: Standardwerte laden
		/// @param pGame Zeiger auf Spielinstanz
		/// @param pPlayerObj Zeiger auf Spielerdaten
		CGui(CGame* pGame, SPlayerObj* pPlayerObj);

		/// Destruktor: Heap-Speicher freigeben
		~CGui();

		/// GUI anzeigen
		void Draw();

		/// Blinkende Warnung anzeigen
		/// @param szText Anzeigetext
		/// @param nXPos X-Position
		/// @param nYPos Y-Position
		/// @param float fFlashingTime Blinkfrequenz
		void DrawWarning(const char* szText, int nXPos, int nYPos, float fFlashingTime = 1.0);

		/// Spielerstatistiken zurueck geben
		/// @return Vektor von Spielstatistiken (fuer die Endstatistiken-Anzeige!)
		vector<SPlayer>& GetPlayerStats() { Update(); return m_vPlayerStats; }

        /// Die vergangene Spielzeit zurueck geben
        /// @return vergangene Spielzeit
		float GetPlayingTime();

		/// Aktualisieren der Spielerstatistiken im MP-Modus
		void Update();

	private:
		CGame* m_pGame;				///< Zeiger auf Spielinstanz
		SPlayerObj* m_pPlayerObj;	///< Zeiger auf Spielerinstanz
		float m_fFlashingTimer;		///< Timer fuer Blinkanzeigen

		int m_nLastStatsRefresh;		///< Zeitpunkt des letzten Updates der Spielerstatistiken
		vector<SPlayer> m_vPlayerStats;	///< Spielerstatistiken
		int m_nLocalPlayerID;			///< ID des lokalen Spielers, damit dieser hervorgehoben werden kann
};

#endif
