#include "Model.hpp"

CModel::CModel(void)
{
	//Speicher zur Initialisierung auf 0 setzen
	memset(m_nCallLists, 0, sizeof(GLuint) * MODELS_NUM);
}

CModel::~CModel(void)
{

}

bool CModel::Load(const int nModelNum, char* szObjFile)
{
	if (nModelNum < 0 || nModelNum > MODELS_NUM - 1 || m_nCallLists == 0)	//Falls Index ung�ltig oder Modell schon eingelesen: false
		return false;

	GLMmodel* pModel;

	//Model laden
	pModel = glmReadOBJ(szObjFile);			//UV-Texturiertes Modell im OBJ-Format
	glmUnitize(pModel);

	//Normalen erstellen
	glmFacetNormals(pModel);
    glmVertexNormals(pModel, 90.0);

	//In CallList speichern
	m_nCallLists[nModelNum] = glmList(pModel, GLM_SMOOTH|GLM_TEXTURE);

	//Kann wieder gel�scht werden
	
	glmDelete(pModel);

	return true;
}

void CModel::Draw(const int nModelNum)
{
	if (nModelNum < 0 || nModelNum > MODELS_NUM - 1)
	{
		return;
	}

	glCallList(m_nCallLists[nModelNum]);
}
