#ifndef MODEL_HPP
#define MODEL_HPP

#include "../client/PlatformFramework.hpp"

#include "../tools/glm.hpp"
#include "../tools/Singleton.hpp"

/// Modelanzahl
const int MODELS_NUM = 5;

const int MODEL_TAXI = 0;	///< Taxi-Modell
const int MODEL_ENGINE = 1;	///< Engine-Modell
const int MODEL_STARTPLATFROM = 2;	///< Startplattform-Modell
const int MODEL_FUEL = 3; ///< Tankkanister-Modell
const int MODEL_STAR = 4; ///< Stern-Modell

#define g_pModel CModel::Get()

/// Singleton-Klasse zum zentralen Einlesen und Anzeigen von Modells.
/// Benutzt die glm-Funktionen zum Einlesen der OBJ-Dateien
class CModel :	public TSingleton<CModel>
{
	public:
		/// Konstruktor: Speicherinitialisierung
		CModel(void);

		/// Dekonstruktor: Speicher freigabe
		~CModel(void);

		/// Model laden
		/// @param nModelNum Model Nummer (MODEL_* Konstante)
		/// @param szObjFile Pfad zur .obj Datei
		/// @return Falls Index ungueltig oder Modell schon eingelesen, bzw. Einlesen fehlgeschlagen false, sonst true
		bool Load(const int nModelNum, char* szObjFile);

		/// Modell malen
		/// @param nModelNum Model Nummer (MODEL_* Konstante)
		void Draw(const int nModelNum);

	private:
		GLuint		m_nCallLists[MODELS_NUM];	///< CallList fuer die Modelle
};

#endif
