#include "Particle.hpp"

CParticle::CParticle(void)
{
	m_pWorld = NULL;

	if (!g_pTexture->Load(TEX_SMOKE, "Data/particle.png"))
		cout << "Textur " << TEX_SMOKE << " konnte nicht geladen werden!";
}

CParticle::~CParticle(void)
{
	//FREEMEM(m_pTex);

}

particleValues* particles = new particleValues[particleCount];

void CParticle::initParticleEmitter(float x, float y, float z)
{
	for(int i=0;i!=particleCount;i++)
    {
		particles[i].direction=0;
		particles[i].acceleration=0;
		particles[i].deceleration=0.0025;
		particles[i].size=randomBetweenf(0.1, 0.25);

		particles[i].xPos=x;
		particles[i].xVec=0.2*randomBetweenf(-0.5, 0.5);

		particles[i].yPos=y;
		particles[i].yVec=0.2*randomBetweenf(-0.5, 0.5);

		particles[i].zPos=z;
		particles[i].zVec=0.2*randomBetweenf(-0.5, 0.5);

		particles[i].xVecInitial=particles[i].xVec;
		particles[i].yVecInitial=particles[i].yVec;
		particles[i].zVecInitial=particles[i].zVec;
		particles[i].life=randomBetweeni(0, particleLife);

	}
}

void CParticle::updateParticles(float x, float y, float z)
{
	for(int i=0;i!=particleCount;i++)
    {
		particles[i].life-=1;
		if (particles[i].life<1) {
			particles[i].xVec=particles[i].xVecInitial;
			particles[i].yVec=particles[i].yVecInitial;
			particles[i].zVec=particles[i].zVecInitial;
			particles[i].life=randomBetweeni(0, particleLife);
			particles[i].size=randomBetweenf(0.01, 0.25);
		}
		float fTimeFactor =  g_pTimer->GetElapsed() * 30.0f;
		particles[i].xVec+=particles[i].xVec*(fTimeFactor/randomBetweeni(20, 40));
		particles[i].xPos=x+particles[i].xVec;

		particles[i].yVec+=particles[i].yVec*(fTimeFactor/randomBetweeni(20, 40));
		particles[i].yPos=y-1.5+particles[i].yVec;

		particles[i].zVec+=particles[i].zVec*(fTimeFactor/randomBetweeni(20, 40));
		particles[i].zPos=z+particles[i].zVec;

		particles[i].direction+=((((((int)(0.5 - 0.1 + 0.1) * rand()%11) + 1) - 1 + 1) * rand()%11) + 1);
		particles[i].deceleration+=0.0025;
		glPushMatrix();
		//glPushAttrib(GL_COLOR_BUFFER_BIT);
		glEnable(GL_BLEND);
		glColor4f(1.0, 1.0, 1.0, 0.1);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
			glDisable(GL_DEPTH_TEST);
			//glDisable(GL_LIGHTING);
			glPushMatrix();
				glTranslatef (particles[i].xPos,particles[i].yPos,particles[i].zPos);
				glRotatef(m_pWorld->GetCamAngle(),1.0,0.0,0.0);
				glScalef(particles[i].size,particles[i].size,1.0);
				// alpha=atan(sqrt(particles[i].xPos*particles[i].xPos+particles[i].yPos*particles[i].yPos)/particles[i].zPos);
				/// Winkel holen
				//float alpha = m_pWorld->GetCamAngle();
				//cout << m_pWorld->GetCamAngle() << endl;

				drawRectangle();
			glPopMatrix();
			//glEnable(GL_LIGHTING);
			glEnable(GL_DEPTH_TEST);
			glDisable(GL_BLEND);
		//glPopAttrib();
		glPopMatrix();
	}
}

void CParticle::drawRectangle()
{
	g_pTexture->Use(TEX_SMOKE);
	//glDisable(GL_TEXTURE_2D);
	glBegin(GL_QUADS);
		glNormal3f( -1.0f, 0.0f, 0.0f);
		glColor4ub(255, 255, 255, 100); // letzter Wert Alpha
		glTexCoord2f(0.0f, 0.0f); glVertex3f(0.0f, 0.0f, 0.0);// Bottom Left Of The    Texture and Quad
		glTexCoord2f(1.0f, 0.0f); glVertex3f(1.0f, 0.0f, 0.0);// Bottom Right Of    The Texture and Quad
		glTexCoord2f(1.0f, 1.0f); glVertex3f(1.0f, 1.0f, 0.0);// Top Right Of The    Texture and Quad
		glTexCoord2f(0.0f, 1.0f); glVertex3f(0.0f, 1.0f, 0.0);// Top Left Of The Texture    and Quad
	glEnd();
	//glEnable(GL_TEXTURE_2D);
}

int CParticle::randomBetweeni(int min, int max) {
  int range = max - min;
  return min + (int)floor((rand()/(float)RAND_MAX) * range);
}

float CParticle::randomBetweenf(float min, float max) {
  return min + (rand()/(float)RAND_MAX) * (max-min);
}
