#ifndef PARTICLE_HPP
#define PARTICLE_HPP

#include "../client/PlatformFramework.hpp"

#include "../game/World.hpp"
#include "../client/Framework.hpp"
#include "../tools/Timer.hpp"
#include "../tools/Vec2D.hpp"
#include "../tools/Vec3D.hpp"
#include "../tools/Singleton.hpp"

#include "Texture.hpp"

using namespace std;

int const particleCount=200;
int const particleLife=100;


struct particleValues
{
	float xPos,yPos,zPos;
	float xVecInitial,yVecInitial,zVecInitial;
	float xVec,yVec,zVec;
	float direction,acceleration,deceleration,size;
	int life;
};

class CWorld;

#define g_pParticle CParticle::Get()

/// Partikelengine
class CParticle : public TSingleton<CParticle>
{
	public:
		/// Konstruktor
		CParticle();

		/// Destruktor: Heap-Speicher freigeben
		~CParticle();

		/// Zeiger auf World-Instanz setzen
		void SetWorldPointer(CWorld* pWorld) { m_pWorld = pWorld; };

		/// Initialisierung Emitter
		void initParticleEmitter(float x, float y, float z);

		/// Textur auf Quadrat mappen
		void drawRectangle();

		/// Partikel bewegen
		void updateParticles(float x, float y, float z);
		
		int randomBetweeni(int min, int max);

		float randomBetweenf(float min, float max);

	private:
		CWorld* m_pWorld;	///< Zeiger auf World-Instanz
		
};

#endif
