#include "Text.hpp"

CText::CText(void)
{
	m_fontStyle = GLUT_BITMAP_9_BY_15;
	m_fColor[0] = 1.0;
	m_fColor[1] = 1.0;
	m_fColor[2] = 1.0;
}

CText::~CText(void)
{

}

void CText::SetFont(void* glutFontStyle, float fColorR, float fColorG, float fColorB)
{
	m_fontStyle = glutFontStyle;
	m_fColor[0] = fColorR;
	m_fColor[1] = fColorG;
	m_fColor[2] = fColorB;
}


void CText::DrawStr(int x, int y, const char *string, ...)
{
	char* character;

	va_list args;
    char buffer[255];

    va_start(args, string);
    vsprintf(buffer, string, args);
    va_end(args);

	glColor3fv(m_fColor);	//Achtung! glColor muss vor glRasterPos stehen!

	glRasterPos2i(x, y);

	for (character=buffer; *character != '\0'; character++)
	{
		glutBitmapCharacter(m_fontStyle, *character);
	}

	glColor3f(1.0, 1.0, 1.0);
}
