#ifndef TEXT_HPP
#define TEXT_HPP

#include <string.h>
#include <iostream>

#include "../client/PlatformFramework.hpp"

#include "../globals.hpp"
#include "../tools/Singleton.hpp"

using namespace std;

#define g_pText CText::Get()

class CText : public TSingleton<CText>
{
	public:
		/// Konstruktor: initialisieren
		CText();
		/// Destruktur: Speicher freigeben
		~CText();

		/// Textausgabe: Erwartet als Eingabe eine x und eine y Angabe,
		/// sowie einen printf-artig formatierten String.
		/// Positioniert wird ausgehend von links
		/// unten (Nullpunkt). Die Einheiten entsprechen der Fenster-
		/// groesse.
		void DrawStr(int x, int y, const char* string, ...);

		/// Font-Style setzen
		/// @param glutFontStyle GLUT_BITMAP_* Konstante
		/// @param fColorR Farbanteil rot
		/// @param fColorG Farbanteil gruen
		/// @param fColorB Farbanteil blau
		void SetFont(void* glutFontStyle = GLUT_BITMAP_9_BY_15, float fColorR = 1.0, float fColorG = 1.0, float fColorB = 1.0);

	private:
		GLvoid *m_fontStyle;	///< Aktueller Font
		float m_fColor[3];		///< Aktuelle Farbe
};

#endif
