#include "Text3D.hpp"

CText3D::CText3D(void)
{
	//Standards laden
	SetFont();

	//Font initialisieren
	float	cx;											// Holds Our X Character Coord
	float	cy;											// Holds Our Y Character Coord

	m_fontList = glGenLists(FONT_CHARACTERS);
	g_pTexture->Load(TEX_FONT, "Data/font.png");

	for (int loop = 0; loop < FONT_CHARACTERS; loop++)						// Loop Through All 256 Lists
	{
		cx = float(loop%16)/16.0f;						// X Position Of Current Character
		cy = float(loop/16)/16.0f;						// Y Position Of Current Character

		glNewList(m_fontList + loop, GL_COMPILE);				// Start Building A List
			glBegin(GL_QUADS);							// Use A Quad For Each Character
				glTexCoord2f(cx,1-cy-0.0625f);			// Texture Coord (Bottom Left)
				glVertex2i(0,0);						// Vertex Coord (Bottom Left)
				glTexCoord2f(cx+0.0625f,1-cy-0.0625f);	// Texture Coord (Bottom Right)
				glVertex2i(16,0);						// Vertex Coord (Bottom Right)
				glTexCoord2f(cx+0.0625f,1-cy);			// Texture Coord (Top Right)
				glVertex2i(16,16);						// Vertex Coord (Top Right)
				glTexCoord2f(cx,1-cy);					// Texture Coord (Top Left)
				glVertex2i(0,16);						// Vertex Coord (Top Left)
			glEnd();									// Done Building Our Quad (Character)
			glTranslated(10,0,0);						// Move To The Right Of The Character
		glEndList();									// Done Building The Display List
	}								
}

CText3D::~CText3D(void)
{
	glDeleteLists(m_fontList, FONT_CHARACTERS);							// Delete All 256 Display Lists
}

void CText3D::SetFont(bool bCenter, bool bCursive, float fColorR, float fColorG, float fColorB)
{
	m_bCenter = bCenter;
	m_bCursive = bCursive;
	m_fColor[0] = fColorR;
	m_fColor[1] = fColorG;
	m_fColor[2] = fColorB;
}

void CText3D::DrawStr(const char *string, ...)
{
	char* character;

	va_list args;
    char buffer[255];

    va_start(args, string);
    vsprintf(buffer, string, args);
    va_end(args);

    glPushAttrib(GL_TEXTURE_BIT | GL_COLOR_BUFFER_BIT);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_LIGHTING);
	
	g_pTexture->Use(TEX_FONT);
	glListBase(m_fontList - 32 + (128 * (int) m_bCursive));	//Kursive oder normale Zeichen ausw�hlen?
	glColor3fv(m_fColor);

	int nLen = strlen(buffer);

	glPushMatrix();
		glScalef(0.0625f, 0.0625f, 0.0625f);
		if (m_bCenter)
		{
			glTranslatef(-4.0 * ((float)nLen), 0.0, 0.0);
		}
		glCallLists(nLen, GL_UNSIGNED_BYTE, buffer);	//Text zeichnen!
	glPopMatrix();

	glColor3f(1.0, 1.0, 1.0);

	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glPopAttrib();
}

