#ifndef TEXT3D_HPP
#define TEXT3D_HPP

#include <string.h>
#include <iostream>

#include "../client/PlatformFramework.hpp"

#include "../globals.hpp"
#include "../tools/Singleton.hpp"

#include "Texture.hpp"

using namespace std;

#define FONT_CHARACTERS 256

#define g_pText3D CText3D::Get()

/// Klasse zum Anzeigen von Text im 3D-Raum
/// @see http://nehe.gamedev.net/data/lessons/lesson.asp?lesson=17
/// @author Markus Konrad, Giuseppe D'Agata, Jeff Molofee
class CText3D : public TSingleton<CText3D>
{
	public:
		/// Konstruktor: initialisieren
		CText3D();
		/// Destruktur: Speicher freigeben
		~CText3D();

		/// Textausgabe im 3D-Raum, je nach aktueller Transformations-
		/// matrix.
		void DrawStr(const char *string, ...);

		/// Font-Style setzen
		///	@param bCenter Zentrieren?
		/// @param bCursive Kursiv?
		/// @param fColorR Farbanteil rot
		/// @param fColorG Farbanteil gruen
		/// @param fColorB Farbanteil blau
		void SetFont(bool bCenter = true, bool bCursive = false, float fColorR = 1.0, float fColorG = 1.0, float fColorB = 1.0);

	private:
		float m_fColor[3];		///< Aktuelle Farbe
		bool m_bCursive;		///< Kursiv?
		bool m_bCenter;			///< Zentrieren?
		GLuint	m_fontList;		///< Base Display List For The Font
};

#endif
