#include "Texture.hpp"

CTexture::CTexture()
{
	memset(m_Textures, 0, sizeof(GLuint*) * MAX_TEX);	//alles auf 0 setzen
	glGenTextures(MAX_TEX, m_Textures);
}

CTexture::~CTexture()
{
	glDeleteTextures(MAX_TEX, m_Textures);
}


bool CTexture::Load(const int nTexNum, char* szTexFile)
{
	if (nTexNum > MAX_TEX)
		return false;

	SDL_Surface* img = NULL;
	SDL_Surface* conv = NULL;
    img = IMG_Load(szTexFile);

    conv = SDL_CreateRGBSurface(SDL_SWSURFACE, img->w, img->h, 32, 0x000000ff, 0x0000ff00, 0x00ff0000, 0xff000000);
    SDL_BlitSurface(img, 0, conv, 0);

	//Textur bekannt machen
	glBindTexture(GL_TEXTURE_2D, m_Textures[nTexNum]);

	//Mipmapping Parameter setzen
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR_MIPMAP_NEAREST);
	glTexParameteri(GL_TEXTURE_2D, GL_GENERATE_MIPMAP, GL_TRUE);
	//gluBuild2DMipmaps(GL_TEXTURE_2D, 3, img->w, img->h, GL_BGR, GL_UNSIGNED_BYTE, img->pixels);

	//Mipmap erstellen
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, conv->w, conv->h, 0, GL_RGBA, GL_UNSIGNED_BYTE, conv->pixels);


	//Bildspeicher wieder freigeben
	SDL_FreeSurface(img);
	SDL_FreeSurface(conv);

	if (!m_Textures[nTexNum])
	{
		return false;
	}

	m_TexturesList[nTexNum] = glGenLists(1);
	glNewList(m_TexturesList[nTexNum], GL_COMPILE);
		glBindTexture(GL_TEXTURE_2D, m_Textures[nTexNum]);
	glEndList();

	return true;
}


bool CTexture::Use(const int nTexNum)
{
	if (nTexNum > MAX_TEX || !m_Textures[nTexNum])
		return false;

	//Textur verwenden
	glCallList(m_TexturesList[nTexNum]);
	//glBindTexture(GL_TEXTURE_2D, m_Textures[nTexNum]);
	
	return true;
}
