#ifndef TEXTURE_HPP
#define TEXTURE_HPP

#include <cstdio>
#include <iostream>
#include <fstream>

#include "../client/PlatformFramework.hpp"

#include "../tools/Singleton.hpp"

/// Maximale Texturanzahl
const int MAX_TEX = 255;

// ------------------ Texturen: ------------------ //

const int TEX_WALL = 0;	///< Standardwand
const int TEX_WALL_WHITE = 1;	///< Alternative Wand
const int TEX_WALL_BLUE = 2;	///< Alternative Wand Blau
const int TEX_WALL_RED = 3;	///< Alternative Wand Rot

const int TEX_TAXI = 4; ///< Fuer das Taxi-Modell
const int TEX_SMOKE = 5; ///< Fuer die Todesanimation
const int TEX_ENGINE = 6; ///< Duesenantrieb
const int TEX_STARTPLATFORM = 7; ///< Fuer die Startplattform
const int TEX_FUEL = 8; ///< Fuer den Treibstoffkanister
const int TEX_STAR = 9; ///< Fuer das Sternchen

const int TEX_SKY1 = 11;	///< SkyboxSeite 1
const int TEX_SKY2 = 12;	///< SkyboxSeite 2
const int TEX_SKY3 = 13;	///< SkyboxSeite 3
const int TEX_SKY4 = 14;	///< SkyboxSeite 4

const int TEX_WALL_BLUEGRID = 20;
const int TEX_WALL_BLUETECH = 21;
const int TEX_WALL_BRIGHTBLUE = 22;
const int TEX_WALL_DARKRED = 23;
const int TEX_WALL_GREENNUMBERS = 24;
const int TEX_WALL_ORANGE = 25;
const int TEX_WALL_TECH = 26;

const int TEX_FONT = 100;

#define g_pTexture CTexture::Get()

/// Texturmanager: Laed Texturen und stellte diese
/// zum Gebrauch zur Verfuegung
/// ACHTUNG: Texturen muessen um 180 Grad gedreht und horizontal gespiegelt werden!!
class CTexture : public TSingleton<CTexture>
{
	public:
		/// Konstruktor: Texturspeicher initialisieren
		CTexture();
		/// Destruktur: Texturspeicher freigeben
		~CTexture();

		/// Bestimmte Textur laden (Bitmap-Bild)
		/// @param nTexNum		Textur-Nummer (TEX_* Konstante)
		/// @param szTexFile	BMP-Datei
		/// @return Textur erfolgreich geladen?
		bool Load(const int nTexNum, char* szTexFile);

		/// Textur verwenden
		/// @param Textur-Nummer (TEX_* Konstante)
		/// @return Verwendung moeglich?
		bool Use(const int nTexNum);

	private:
		/// Texturspeicher
		GLuint m_Textures[MAX_TEX + 1];
		
		/// Display List - Textur-ID map
		GLuint m_TexturesList[MAX_TEX + 1];
};

#endif
