#ifndef GLOBALS_HPP
#define GLOBALS_HPP

#include "tools/Vec2D.hpp"

#define SCREEN_RES_X 800
#define SCREEN_RES_Y 600
#define SCREEN_BPP 32
#ifdef _DEBUG
	#define SCREEN_FULLSCREEN false
	#include <iostream>
	#define DEBUG_PRINTL(n) std::cout << __FILE__ << ":" << __LINE__ << " " << n << std::endl;
	#define DEBUG_PRINT(n) std::cout << n;
#else
	#define SCREEN_FULLSCREEN false
	#define DEBUG_PRINTL(n)
	#define DEBUG_PRINT(n)
#endif
#define WINDOW_TITLE "TRAXI 2.0"
#define FREEMEM(x)   if (x != NULL) { delete (x); x = NULL; }
#define FREEMEM_ARRAY(x)   if (x != NULL) { delete[] (x); x = NULL; }
#define SQR(x)	(x)*(x)
#define NET_DEFAULT_PORT 12345

#define GAME_MAX_LEVEL 6

#define PLAYER_COLL_WIDTH 0.4
#define PLAYER_COLL_HEIGHT 0.2
#define PLAYER_COLL_LENGTH 0.7

const float DEG2RAD =  0.0174532925f;	///< Grad in Radiant Umrechnungsfaktor
const float RAD2DEG = 57.2957795100f;	///< Radiant in Grad Umrechnungsfaktor

/// Spielstatus wichtig fuer Spielablauf
enum EGameStatus {GAME_STOPPED, GAME_RUNNING, GAME_PAUSED};

/// Programmstatus wichtig fuer Menueanzeige
enum EProgramStatus {
	MENU_MAIN,
	MENU_PAUSE,
	MENU_HELP,
	MENU_LEVEL,
	MENU_MPLAYER,
	MENU_MPLAYER_CREATE,
	MENU_MPLAYER_CREATE_INET,
	MENU_MPLAYER_CREATECONFIG,
	MENU_MPLAYER_PLAYERSETUP,
	MENU_GAME_OVER,
	MENU_LEVEL_END,
	MENU_GAME_COMPLETED,
	MENU_MPLAYER_JOIN,
	MENU_MPLAYER_JOIN_PASSWD,
	MENU_MPLAYER_GAMEROOM,
	MENU_MPLAYER_CHATROOM,
	MENU_MPLAYER_ENDSTATS,
	MENU_CREDITS,
	INGAME,
	PROGRAM_EXIT
};

/// Definiert Kollisions-"Box" um den Spieler anhand von 4 Testpunkten und einer Hoehe
/// (gehoert eigentlich in World.hpp, geht aber dank Klassen-Verstrickungen irgendwie nicht)
struct SPlayerCollision
{
	CVec2D vTestPoint[4];
	float fPlayerHeight;
	float fPlayerWidth;
	float fPlayerLength;
};

/// Definiert komplette Spielerdaten
struct SPlayerObj
{
	int nID;				///< Spieler-ID
	char* szName;			///< Spielername
	bool bPush;				///< Schub?
	bool bUp;				///< Bewegung nach oben?
	bool bDown;				///< Bewegung nach unten?
	bool bShowExhaust;		///< Antriebsfeuer anzeigen?
	bool bDead;				///< Spieler tot und daher jetzt "Geist"? (MP-Modus!)
	float fDeathAnimTimer;	///< Timer fuer die Todesanimation
	float fCrashAnimTimer;	///< Timer fuer die Todesanimation
	float fPlayingTime;		///< Zeit die angibt, wie lange der Spieler schon dieses Level spielt (wichtig fuer Singleplayer!)
	float fFuel;			///< Aktueller Treibstoffstand
	float fDmg;				///< Aktueller Schaden (MP-Modus)
	float fAngleX;			///< Neigung um X-Achse
	float fAngleY;			///< Neigung um Y-Achse
	float fAngleZ;			///< Neigung um Z-Achse
	float fSpeedX;			///< Fortbewegungsfaktor in X-Richtung
	float fSpeedZ;			///< Fortbewegungsfaktor in Z-Richtung
	float fPosX;			///< X-Position
	float fPosY;			///< Y-Position
	float fPosZ;			///< Z-Position
	SPlayerCollision PlayerColl;	///< Kollisions-Punkte um den Spieler herum
	int nScore;				///< Punktezahl. Wird beim Multiplayer missbraucht als Platz
	int nBonusScore;		///< Bonus-Punkte
	int nLives;				///< Leben
};

#endif
