#include "Message.hpp"
#include <iostream>

CMessage::CMessage(u16 nSize)
{
	Init(nSize, NULL, 0);
}

CMessage::CMessage(u16 nSize, u8* pBuffer)
{
	Init(nSize, pBuffer, nSize);
}

CMessage::CMessage(u16 nSize, u8* pBuffer, u16 nBufferSize)
{
	Init(nSize, pBuffer, nBufferSize);
}

void CMessage::Init(u16 nSize, u8* pBuffer, u16 nBufferSize)
{
	m_nSize = nSize;
	m_pBuffer = new u8[m_nSize];
	
	memset(m_pBuffer, 0, m_nSize);
	
	if (pBuffer != NULL)
	{
		memcpy(m_pBuffer, pBuffer, nBufferSize);
	}
}

CMessage::~CMessage()
{
	FREEMEM_ARRAY(m_pBuffer);
}

void CMessage::Resize(u16 nSize)
{
	if (nSize == m_nSize)
		return;
	
	m_pBuffer = (u8*) realloc(m_pBuffer, nSize);
	m_nSize = nSize;
}

u8*	CMessage::Data()
{
	return m_pBuffer;
}

bool CMessage::Recv(TCPsocket sSocket)
{
	return Recv(sSocket, 0, m_nSize);
}

bool CMessage::Recv(TCPsocket sSocket, u16 nOffset)
{
	return Recv(sSocket, nOffset, m_nSize - nOffset);
}

bool CMessage::Recv(TCPsocket sSocket, u16 nOffset, u16 nSize)
{
	if (nSize == 0)
		return true;
	
	if (nSize + nOffset > m_nSize)
		return false;
	
	return CMessage::SecureRecv(sSocket, m_pBuffer + nOffset, nSize);
}

bool CMessage::RecvResponse(TCPsocket sSocket)
{
	SResponseHeader* pRespHeader;

	Resize(sizeof(SResponseHeader));

	//Header holen
	if (!Recv(sSocket))
	{
		return false;
	}
	
	pRespHeader = (SResponseHeader*) m_pBuffer;

	pRespHeader->nMessageLength = SDLNet_Read16(&pRespHeader->nMessageLength);

	//Daten holen wenn's welche gibt!
	if (pRespHeader->nMessageLength > sizeof(SResponseHeader))
	{
		Resize(pRespHeader->nMessageLength);

		if (!Recv(sSocket, sizeof(SResponseHeader)))
		{
			return false;
		}
	}

	return true;
}

bool CMessage::Send(TCPsocket sSocket)
{
	return Send(sSocket, 0, m_nSize);
}

bool CMessage::Send(TCPsocket sSocket, u16 nOffset, u16 nSize)
{
	if (nSize + nOffset > m_nSize)
		return false;
	
	return CMessage::SecureSend(sSocket, m_pBuffer + nOffset, nSize);
}

bool CMessage::SecureSend(TCPsocket sSocket, u8* pData, u16 nSize)
{
	if (SDLNet_TCP_Send(sSocket, pData, nSize) < nSize)
		return false;
	else
		return true;
}

bool CMessage::SecureRecv(TCPsocket sSocket, u8* pData, u16 nSize)
{
	u16 nDone = 0;
	s32 nBytesReceived;
	
	while (nSize > nDone)
	{
		nBytesReceived = SDLNet_TCP_Recv(sSocket, pData + nDone, nSize - nDone);
		if (nBytesReceived <= 0)
		{
			return false;
		}
		else
		{
			nDone += nBytesReceived;
		}
	}
	return true;
}
