#ifndef MESSAGE_HPP_
#define MESSAGE_HPP_

#include "../globals.hpp"
#include "SocketFramework.hpp"
#include "NetworkTypes.hpp"
#include "NetworkMessages.hpp"

/// Klasse die es erm�glicht eine Nachricht dynamischer Gr��e
/// zu erzeugen und auf diese Daten zuzugreifen

class CMessage
{
public:
	/// Konstruktor
	/// @param	nSize	Die Gr��e des Datenpuffers in Byte

	CMessage(u16 nSize = 0);
	
	/// Konstruktor mit Datenpuffer der in den Puffer der Nachricht kopiert wird
	/// @param	nSize	Die Gr��e des Datenpuffers in Byte
	/// @param	pBuffer	Der Datenpuffer aus dem kopiert werden soll

	CMessage(u16 nSize, u8* pBuffer);
	
	/// Konstruktor mit Datenpuffer der in den Puffer der Nachricht kopiert wird
	/// Es werden nur nPufferSize Byte vom Puffer in den Datenpuffer kopiert
	/// @param	nSize	Die Gr��e des Datenpuffers in Byte
	/// @param	pBuffer	Der Datenpuffer aus dem kopiert werden soll
	/// @param	nBufferSize	Die Größe des zu kopierenden Datenpuffers

	CMessage(u16 nSize, u8* pBuffer, u16 nBufferSize);
	
	~CMessage();
	
	/// Gr��e des Datenpuffers �ndern
	/// @param	nSize	Die Gr��e des Datenpuffers in Byte

	void Resize(u16 nSize);
	
	/// Gibt einen Zeigen auf die Daten zur�ck
	/// @return	Einen Zeigen auf die Daten

	u8*	Data();

	/// Akt. Groesse des Datenpuffers zurueckgeben

	int GetSize() { return m_nSize; }

	/// Empfange automatische komplette Response
	/// Es wird ein Header von 3 Byte eingelesen und dann so viele Byte abgerufen wie
	/// im Laengen-Feld des Headers angegeben
	/// @param	sSocket	Der Socket ueber den empfangen werden soll
	/// @return	Einen boolean der Auskunft ueber den Erfolg des Empfangs gibt

	bool RecvResponse(TCPsocket sSocket);
	
	/// Empfange Daten aus einem Netzwerkdatenstrom und speichere
	/// sie in der Datenstruktur
	/// Es werden so viele Byte abgerufen wie die Datenstruktur gro� ist
	/// @param	sSocket	Der Socket �ber den empfangen werden soll
	/// @return	Einen boolean der Auskunft �ber den Erfolg des Empfangs gibt

	bool Recv(TCPsocket sSocket);
	
	/// Empfange Daten aus einem Netzwerkdatenstrom und speichere
	/// sie in der Datenstruktur
	/// Es werden so viele Byte abgerufen wie die Datenstruktur - nOffset groß ist
	/// @param	sSocket	Der Socket �ber den emfangen werden soll
	/// @param	nOffset	Ein Offset der angibt um wie viele Byte versetzt im
	/// 					eigenen Datenspeicher angefangen werden soll zu schreiben
	/// @return	Einen boolean der Auskunft �ber den Erfolg des Empfangs gibt
	/// 			Die Funktion gibt ebenfalls false zur�ck wenn die Anzahl
	/// 			zu empfangener Bytes nicht in den Puffer passt

	bool Recv(TCPsocket sSocket, u16 nOffset);
	
	/// Empfange Daten aus einem Netzwerkdatenstrom und speichere
	/// sie in der Datenstruktur
	/// @param	sSocket	Der Socket �ber den emfangen werden soll
	/// @param	nOffset	Ein Offset der angibt um wie viele Byte versetzt im
	/// 					eigenen Datenspeicher angefangen werden soll zu schreiben
	/// @param	nSize	Die Anzahl zu emfangener Bytes
	/// @return	Einen boolean der Auskunft �ber den Erfolg des Empfangs gibt
	/// 			Die Funktion gibt ebenfalls false zur�ck wenn die Anzahl
	/// 			zu empfangener Bytes nicht in den Puffer passt

	bool Recv(TCPsocket sSocket, u16 nOffset, u16 nSize);
	

	/// Sende alle Daten die im Puffer gespeichert sind
	/// @param	sSocket	Der Socket �ber den gesendet werden soll
	/// @return	Einen boolean der Auskunft �ber den Erfolg des Sendens gibt

	bool Send(TCPsocket sSocket);
	
	/// Sende ausgew�hlte Daten die im Puffer gespeichert sind
	/// @param	sSocket	Der Socket �ber den gesendet werden soll
	/// @param	nOffset	Ein Offset der angibt um wie viele Byte versetzt im
	/// 					eigenen Datenspeicher angefangen werden soll zu lesen
	/// @param	nSize	Die Anzahl zu sendender Bytes
	/// @return	Einen boolean der Auskunft �ber den Erfolg des Sendens gibt
	/// 			Die Funktion gibt ebenfalls false zur�ck wenn die Anzahl
	/// 			zu sendenden Bytes nicht im Puffer vorhanden sind

	bool Send(TCPsocket sSocket, u16 nOffset, u16 nSize);
	
	/// Sicheres senden von Daten �ber einen Datenstrom
	/// @param	sSocket	Der Socket �ber den gesendet werden soll
	/// @param	pData	Zeiger auf die Daten
	/// @param	nSize	Die Anzahl zu sendender Bytes
	/// @return	Einen boolean der Auskunft �ber den Erfolg des Sendens

	static bool SecureSend(TCPsocket sSocket, u8* pData, u16 nSize);
	
	/// Sicheres empfangen von Daten �ber einen Datenstrom
	/// @param	sSocket	Der Socket �ber den empfangen werden soll
	/// @param	pData	Zeiger auf die Daten
	/// @param	nSize	Die Anzahl zu empfangender Bytes
	/// @return	Einen boolean der Auskunft �ber den Erfolg des Sendens

	static bool SecureRecv(TCPsocket sSocket, u8* pData, u16 nSize);
	
private:
	/// Klasse initialisieren
	/// @param	nSize	Die Gr��e des Datenpuffers in Byte
	/// @param	pBuffer	Der Datenpuffer aus dem kopiert werden soll
	/// @param	nBufferSize	Die Größe des zu kopierenden Datenpuffers

	void Init(u16 nSize, u8* pBuffer, u16 nBufferSize);
	
	
	/// Gr��e des Datenpuffers
	u16 m_nSize;
	
	/// Datenpuffer
	u8* m_pBuffer;
};

#endif ///MESSAGE_HPP_///

