#ifndef NETWORKMESSAGES_HPP_
#define NETWORKMESSAGES_HPP_

#include "NetworkTypes.hpp"

#if defined(_MSC_VER) || defined(__MWERKS__) || defined(__BORLANDC__)
#ifdef _MSC_VER
#pragma warning(disable: 4103)
#endif
#ifdef __BORLANDC__
#pragma nopackwarning
#endif
#pragma pack(push, 1)
#define __PACK
#else
#define __PACK __attribute__((packed))
#endif

enum EMessageReturnCode
{
	CODE_UNUSED, 				// Feld wird nicht benutzt
	CODE_OK, 					// Alles i.O.
	CODE_UNAUTHORIZED, 			// Nicht möglich da nicht berechtigt
	CODE_UNAVAILABLE_INGAME,	// Fehler wenn Aktion erfragt wird die unmöglich ist
								// wenn Client an Spiel beteiligt ist
	CODE_UNAVAILABLE_OUTGAME,	// Fehler wenn Aktion erfragt wird die unmöglich ist
								// wenn Client an keinem Spiel beteiligt ist
	CODE_FAILURE,				// Genereller Fehler
};

enum EMessageType
{
	CLIENT_LOGIN, 			// Client �ffnet Verbindung
	CLIENT_LOGOUT, 			// Client schlie�t Verbindung
	CLIENT_FETCH_MESSAGES, 	// Wartende Nachrichten abrufen
	CLIENT_CHAT, 			// Chat-Nachricht senden
	CLIENT_SYNC,			// Anfrage zum abrufen der Serverzeit

	SERVER_CREATE_GAME, 	// Ein Spiel erstellen
	SERVER_COUNT_GAMES, 	// Anzahl Spiele auslesen
	SERVER_GET_GAMES, 		// Spiele-Infos auslesen
	SERVER_GET_GAME,		// Einzelne Spiele-Info auslesen
	SERVER_GET_PLAYER, 		// Spieler-Infos auslesen
	SERVER_GET_MAPS, 		// Verf�gbare Maps auslesen

	GAME_GET_MAP,			// Fragt die Kartendaten einer Karte ab
	GAME_MAP_CONFIG, 		// Maps zum Spiel hinzuf�gen/entfern.
	GAME_START, 			// Eigenen Status ver�ndern
	GAME_JOIN, 				// Spiel beitreten
	GAME_LEAVE, 			// Spiel verlassen
	GAME_PLAYER_DIE,		// Nachricht an den traxi kaputt geht
	GAME_PUSH_PROGRESS, 	// Eigenen Spielstand senden
	GAME_GET_PLAYER, 		// Spieler-Infos abrufen
	GAME_GET_PLAYERINFO, 		// Spieler-Infos abrufen
	GAME_PROGRESS, 			// Response: Spielfortschritt
	GAME_NEXT_LEVEL,			// Client erreicht das Ziel

	MESSAGE_CHAT, 			// Response: �Wartende� Chatnachr.
};

/// Header zu beginn jeder Kommunikation
struct SMessageHeader
{
	u32 nAuthID;		///< Authentifizierung des Clients
	u32 nNumMessages;	///< Anzahl zu empfangener Nachrichten
} __PACK;

/// Header f�r Anfragen vom Client
struct SRequestHeader
{
	u16 nMessageLength;	///< Message length
	u8 eMessageType;	///< Typ der Request Message
} __PACK;

/// Header f�r Antworten vom Server
struct SResponseHeader

{
	u16 nMessageLength;	///< Message length
	u8 eMessageType; 	///< Typ der Response Message
	u8 eReturnCode; 	///< Return Code
} __PACK;

/// CLIENT_LOGIN
struct SRequestClientLogin
{
	SRequestHeader sHeader;         ///< Anfrage-Header
	char szName[PLAYER_NAME_LENGTH];///< Spielername
} __PACK;

struct SResponseClientLogin
{
	SResponseHeader sHeader;        ///< Antwort-Header
	u32 nAuthID;                    ///< Eindeutige Auth-ID fuer diesen Client
	u16 nID;		                ///< Eindeutige ID des Spielers
} __PACK;

/// CLIENT_LOGOUT
struct SRequestClientLogout
{
	SRequestHeader sHeader;         ///< Anfrage-Header
} __PACK;

struct SResponseClientLogout
{
	SResponseHeader sHeader;        ///< Antwort-Header
} __PACK;

/// CLIENT_FETCH_MESSAGES
struct SRequestClientFetchMessages
{
	SRequestHeader sHeader;         ///< Anfrage-Header
} __PACK;

/// CLIENT_CHAT Client
struct SRequestClientChat
{
	SRequestHeader sHeader;         ///< Anfrage-Header
	char szMessage[MESSAGE_LENGTH]; ///< Chat-Nachricht
} __PACK;

/// CLIENT_SYNC
struct SRequestClientSync
{
	SRequestHeader sHeader;         ///< Anfrage-Header
} __PACK;


struct SResponseClientSync
{
	SResponseHeader sHeader;        ///< Antwort-Header
	u32 nServerTime;                ///< Server-Timestamp
} __PACK;

/// SERVER_CREATE_GAME
struct SRequestServerCreateGame
{
	SRequestHeader sHeader;             ///< Anfrage-Header
	char szGameName[GAME_NAME_LENGTH];  ///< Spielname
	u8 nMaxPlayer;                      ///< Maximale Anzahl von Spielern
	bool bAllowLateJoin;                ///< Nachtraegliches Eintreten ins Spiel erlauben?
	bool bAllowVisitors;                ///< Zuschauer erlauben
	char szPassword[GAME_PASSWD_LENGTH];///< Passwort, welches jeder Spieler dann kennen muss (optional)
} __PACK;

struct SResponseServerCreateGame
{
	SResponseHeader sHeader;    ///< Antwort-Header
	u16 nGameID;                ///< Eindeutige ID des Spiels
} __PACK;

/// SERVER_COUNT_GAMES
struct SRequestServerCountGames
{
	SRequestHeader sHeader;     ///< Anfrage-Header
	bool bOnlyFreeGames;        ///< Nur Spiele zaehlen, welche nicht voll sind?
} __PACK;

struct SResponseServerCountGames
{
	SResponseHeader sHeader;    ///< Antwort-Header
	u16 nNumGames;              ///< Anzahl der Spiel auf dem Server
} __PACK;

/// SERVER_GET_GAMES
struct SRequestServerGetGames
{
	SRequestHeader sHeader;     ///< Anfrage-Header
	bool bOnlyFreeGames;        ///< Nur Spiele, die noch nicht voll sind anzeigen?
	bool bUseRange;             ///< Nur eine gewisse Menge von Spielen uebertragen? -> Wirkt wie LIMIT bei SQL mit den folgenden beiden Parametern
	u16 nNumGames;              ///< Die Anzahl der Spiele (bei bUseRange Nutzung)
	u16 nOffset;                ///< Abstand (bei bUseRange Nutzung)
} __PACK;

struct SResponseServerGetGames
{
	SResponseHeader sHeader;    ///< Antwort-Header
	u16 nNumGames;              ///< Anzahl der Spiele, darauf folgen jetzt \
                                ///< SGameInfo[] sInfos; (Daten sind dynamisch lang)
} __PACK;

/// SERVER_GET_GAME
struct SRequestServerGetGame
{
	SRequestHeader sHeader;     ///< Anfrage-Header
	u16 nGameID;                ///< Eindeutige Spiele-ID
} __PACK;

struct SResponseServerGetGame
{
	SResponseHeader sHeader;    ///< Antwort-Header
	SGameInfo sInfo;            ///< Informationen ueber dieses Spiel (@see SGameInfo)
} __PACK;

/// SERVER_GET_PLAYER
struct SRequestServerGetPlayer
{
	SRequestHeader sHeader;     ///< Anfrage-Header
} __PACK;

struct SResponseServerGetPlayer
{
	SResponseHeader sHeader;    ///< Antwort-Header
	u16 nNumPlayer;             ///< Anzahl der Spieler es folgen \
                                ///< SPlayerInfo[] sInfos; (Daten sind dynamisch lang)
} __PACK;

/// SERVER_GET_MAPS
struct SRequestServerGetMaps
{
	SRequestHeader sHeader;     ///< Anfrage-Header
} __PACK;

struct SResponseServerGetMaps
{
	SResponseHeader sHeader;    ///< Antwort-Header
	u16 nNumMaps;               ///< Anzahl der Maps es folgen \
                                ///< SMapInfo[] sInfos; (Daten sind dynamisch lang )
} __PACK;

/// GAME_GET_MAP
struct SRequestGameGetMap
{
	SRequestHeader sHeader;     ///< Anfrage-Header
	u8 nLevel;
} __PACK;

struct SResponseGameGetMap
{
	SResponseHeader sHeader;    ///< Antwort-Header
	u16 nLength;                ///< Laenger der Daten die jetzt folgen (gesamte Map-Datei als ASCII)
} __PACK;

/// GAME_MAP_CONFIG
enum EAction
{
	REQUEST_ADD_MAP,            ///< Eine Map hinzufuegen zur "Playlist"
	REQUEST_REMOVE_MAP,         ///< Eine Map entfernen von der "Playlist"
};

/// GAME_MAP_CONFIG Request
struct SRequestGameMapConfig
{
	SRequestHeader sHeader;     ///< Anfrage-Header
	u8 eAction;                 ///< EAction Typ -> Aktion die ausgefuerht werden soll
	u8 nAmount;                 ///< Anzahl der Wiederholungen dieser Map
	u8 nMapID;                  ///< ID der Map @see SResponseServerGetMaps
} __PACK;

/// GAME_MAP_CONFIG Response
struct SResponseGameMapConfig
{
  SResponseHeader sHeader;      ///< Antwort-Header
} __PACK;

/// GAME_START
struct SRequestGameStart
{
	SRequestHeader sHeader;     ///< Anfrage-Header
} __PACK;

struct SResponseGameStart
{
	SResponseHeader sHeader;    ///< Antwort-Header
} __PACK;

/// GAME_JOIN
struct SRequestGameJoin
{
	SRequestHeader sHeader;             ///< Anfrage-Header
	u16 nGameID;                        ///< Eindeutige Spiel-ID
	char szPassword[GAME_PASSWD_LENGTH];///< Passwort zum Betreten
} __PACK;

struct SResponseGameJoin
{
  SResponseHeader sHeader;              ///< Antwort-Header
} __PACK;

/// GAME_LEAVE
struct SRequestGameLeave
{
	SRequestHeader sHeader;             ///< Anfrage-Header
} __PACK;

/// GAME_PLAYER_DIE
struct SRequestGamePlayerDie
{
	SRequestHeader sHeader;             ///< Anfrage-Header
} __PACK;

/// GAME_PUSH_PROGRESS
struct SRequestGamePushProgress
{
	SRequestHeader sHeader;             ///< Anfrage-Header
	SGamePlayerStats sStats;            ///< Spieler-Daten wie Position, Fortbewegung, etc. @see SGamePlayerStats
} __PACK;

/// GAME_NEXT_LEVEL
struct SRequestGameNextLevel
{
	SRequestHeader sHeader;             ///< Anfrage-Header
} __PACK;

struct SResponseGameNextLevel
{
	SResponseHeader sHeader;            ///< Antwort-Header
	SGameInfo sGameInfo;                ///< Spiel-Informationen
	u8 nPlayerStartPos;                 ///< Die Startposition, die dieser Spielerzugewiesen bekommt
	u32 nStartTime;                     ///< Die Startzeit des Spiels
} __PACK;

/// GAME_GET_PLAYER
struct SRequestGameGetPlayer
{
	SRequestHeader sHeader;             ///< Anfrage-Header
} __PACK;

struct SResponseGameGetPlayer
{
	SResponseHeader sHeader;            ///< Antwort-Header
	u16 nNumPlayer;                     ///< Anzahl der Spielerdaten, es folgen \
                                        ///< Daten die dynamisch lang sind (SPlayerInfo[] sInfos;)
} __PACK;

/// GAME_GET_PLAYERINFO
struct SRequestGameGetPlayerInfo
{
	SRequestHeader sHeader;             ///< Anfrage-Header
} __PACK;

struct SResponseGameGetPlayerInfo
{
	SResponseHeader sHeader;            ///< Antwort-Header
	u16 nNumPlayer;                     ///< Anzahl der Spielerdaten die jetzt folgen: \
                                        ///< Daten sind dynamisch lang u16[] nOrder
                                        ///< Daten sind dynamisch lang SGamePlayerInfo[] sInfos;
} __PACK;

/// GAME_GET_STATS
struct SRequestGameGetStats
{
	SRequestHeader sHeader;             ///< Anfrage-Header
} __PACK;

struct SResponseGameGetStats
{
	SResponseHeader sHeader;            ///< Antwort-Header
	u16 nNumPlayer;                     ///< Anzahl der Spielerdaten die jetzt folgen: \
                                        ///< Daten sind dynamisch lang u16[] nPlayerOrder;
                                        ///< Daten sind dynamisch lang SGamePlayerInfo[] sInfos;
} __PACK;

/// GAME_PROGRESS
struct SResponseGameProgress
{
	SResponseHeader sHeader;			///< Antwort-Header
	u16 nNumPlayer;						///< Anzahl der Spielerdaten die jetzt folgen: \
										/// Daten sind dynamisch lang u16[] nPlayerOrder;
										/// Daten sind dynamisch lang SGamePlayerStats[] sInfos;
} __PACK;

/// MESSAGE_CHAT
struct SResponseMessageChat
{
	SResponseHeader sHeader;			///< Antwort-Header
	u16 nSender;						///< Sender der Nachricht
	char szMessage[MESSAGE_LENGTH];		///< Nachrichten Text
} __PACK;

#if defined(_MSC_VER) || defined(__MWERKS__) || defined(__WATCOMC__)  || defined(__BORLANDC__)
#ifdef __BORLANDC__
#pragma nopackwarning
#endif
#pragma pack(pop)
#endif

#endif ///NETWORKMESSAGES_HPP_///

