#ifndef NETWORKTYPES_HPP
#define NETWORKTYPES_HPP

/// Globale Basic-Typdefinitionen
typedef unsigned char u8;
typedef signed char s8;

typedef unsigned short int u16;
typedef signed short int s16;

typedef unsigned int u32;
typedef signed int s32;

typedef unsigned long long int u64;
typedef signed long long int s64;

typedef float f32;
typedef double f64;

#define GAME_NAME_LENGTH 15
#define GAME_PASSWD_LENGTH 10 
#define MAP_FILENAME_LENGTH 20
#define MAP_NAME_LENGTH 10
#define PLAYER_NAME_LENGTH 10
#define MESSAGE_LENGTH 255
#define MAPDIR_LENGTH 20

#define GAME_NEXT_LEVEL_PAUSE_SEC 3

// Game-ID fur ein LAN-Spiel
#define LAN_GAME_ID 0

//Alle fuer den Server benoetigten Struct und Enums

enum EGameState
{
	SERVERGAME_CONFIG,
	SERVERGAME_STOPPED,
	SERVERGAME_RUNNING,
	SERVERGAME_PAUSED,
	SERVERGAME_END,
};

enum EPlayerState
{
	PLAYER_DONT_EXISTS,
	PLAYER_JOINED,
	PLAYER_READY,
	PLAYER_INGAME,
	PLAYER_INGAME_DEAD,
	PLAYER_CONTROL,
	PLAYER_REACHED_GOAL
};

enum EPlayerRole
{
	ADMIN,
	PARTICIPANT,
	SPECTATOR,
};


struct SGameInfo
{
	u16 nID;
	char szName[GAME_NAME_LENGTH];
	bool bUsePassword;
	u8 eState; // EPlayerState
	u8 nNumClients;
	u8 nNumPlayers;
	u8 nMaxPlayers;
	bool bLateJoin;
	bool bAllowVisitors;
	u8 nNumLevels;
	u8 nCurrentLevel;
};

struct SPlayerCollisionNet
{
	f32 vTestPoint[8];
	f32 fPlayerHeight;
	f32 fPlayerWidth;
	f32 fPlayerLength;
};

struct SGamePlayerStats
{
	f32 fFuel;
	f32 fMaxFuel;
	f32 fDamage;
	f32 fMaxDamage;
	f32 fAngleX;
	f32 fAngleY;
	f32 fAngleZ;
	f32 fSpeedX;
	f32 fSpeedZ;
	f32 fPosX;
	f32 fPosY;
	f32 fPosZ;
	SPlayerCollisionNet sPlayerColl;
};

struct SGamePlayerInfo
{
	u16 nID;
	u8 nRoundsWon;
	u8 eState; // EPlayerState
	u8 eRole; // EPlayerRole
};

struct SMapInfo
{
	u8 nID;
	char szFile[MAP_FILENAME_LENGTH];
	char szName[MAP_NAME_LENGTH];
	u8 nNumPlayer;
};

struct SPlayerInfo
{
	u16 nID;
	char szName[PLAYER_NAME_LENGTH];
};

#endif ///NETWORKTYPES_HPP///

