#ifndef SERVER_HPP_
#define SERVER_HPP_

#include "../tools/BaseThread.hpp"
#include "../net/NetworkTypes.hpp"
#include "../net/SocketFramework.hpp"
#include "ServerClient.hpp"
#include "GameManager.hpp"

#include <vector>

#define SERVER_REFRESH_INTERVAL 100

class CServerClient;
class CGameManager;

/// Serverdienst, der auf eingehende Verbindungen wartet und
/// neue Threads erzeugt, in denen dann die Kommunikation
/// abgewickelt wird
class CServer : public BaseThread
{
	public:
		/// Konstruktor
		/// @param	nPort		Portnummer auf der der Server laufen soll
		/// @param	bMultiGames	Wenn true wird der Server mit der Erweiterung
		/// 						zur Verwaltung mehrere Spiele gestartet, sonst
		/// 						ist kann jeweils nur ein Spiel gehostet werden
		/// @param	szMapDir	Verzeichnis in dem sich Level-Karten

		CServer(u16 nPort, bool bMultiGames, char* szMapDir);
		
		/// Destruktor

		~CServer();
		
		/// Beginnt mit der Ausführung des Server-Dienstes
		/// @return	false wenn der Server nicht gestartet werden konnte
		/// 			sonst beginnt der Dienst auf Anfragen zu warten und gibt
		/// 			true zurück wenn er beendet wurde
		int Run();
		
		/// Funktion um einen Client aus der Liste verbundener Clients
		/// auszutragen - dies führt dazu, dass der Client-Thread beendet wird
		void UnregisterClient(CServerClient* pClient);
		
		/// Gibt Status des Servers zurueck
		bool IsRunning();
		
		/// Gibt eine Referenz zum GameManager zurück
		/// @return	GameManager
		CGameManager* GetGameManager();
		
	private:
		/// Einen neuen Client registrieren
		/// Diese Methode erzeigt eine neues Client-Object, registriert es,
		/// und startet einen neuen Thread zur Bearbeitung
		/// @param	sClientSocket	Socket Resource Descriptor des Clients
		/// @return	True wenn ein neuer Thread gestartet wurde sonst false
		bool RegisterClient(TCPsocket sClientSocket);
		
		/// Der Server-Socket ueber den Anfragen angenommen werden
		TCPsocket m_sSocket;
		
		/// Spiel-Verwaltungs-Objekt
		CGameManager* m_pGameManager;
		
		/// Semaphore um sicher auf m_vClients zuzugreifen
		SDL_mutex* m_pMutex;
		
		/// Vektor aller vebundenen Clients
		std::vector<CServerClient*> m_vClients;
		
		/// Server-Status
		bool m_bRunning;
		
		/// Port auf dem auf Anfragen gewartet werden soll
		int m_nPort;
};

#endif ///SERVER_HPP_///

