#include "../net/SocketFramework.hpp"
#include "Server.hpp"
#include <iostream>


int main(int argc, char** argv)
{
	if (SDL_Init(0) == -1) 
	{
	    std::cout << "SDL_Init: " << SDL_GetError() << std::endl;
	    return 1;
	}
	
	if (SDLNet_Init() == -1)
	{
		std::cout << "SDLNet_Init: " << SDLNet_GetError() << std::endl;
	    return 1;
	}

	int nPort;
	
	if (argc != 2)
	{
		nPort = NET_DEFAULT_PORT;
	}
	else
	{
		nPort = atoi(argv[1]);
	}
	
	std::cout << "Starte Server auf Port " << nPort << std::endl;
	CServer* pServer = new CServer(nPort, true, "Data/Levels/race/");
	pServer->Run();
	
	SDLNet_Quit();
	SDL_Quit();
	
	return 0;
}
