#include "2DTools.hpp"

void C2DTools::Enter2DMode()
{
	glMatrixMode (GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity ();
	glMatrixMode (GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity ();

	/// Einheitsmatrix auf Orthogonale Ansicht setzen, damit der
	/// Nullpunkt links unten und die Fensterhoehe und -breite
	/// rechts oben als Koordinatensystem zur Positionierung
	/// verwendet werden knnen.
	gluOrtho2D (0, (GLsizei) SCREEN_RES_X, 0, (GLsizei) SCREEN_RES_Y);

	glDisable(GL_DEPTH_TEST); // z-Buffer aus
	glDisable(GL_LIGHTING);   // Licht deaktivieren
	glDisable(GL_TEXTURE_2D);
}

void C2DTools::Leave2DMode()
{
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_LIGHTING);   // Licht aktivieren
	glEnable(GL_DEPTH_TEST); // z-Buffer an

	glPopMatrix();
	glMatrixMode (GL_PROJECTION);
	glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
}

void C2DTools::DrawLine(int nBeginPosX, int nBeginPosY, int nEndPosX, int nEndPosY)
{
	glBegin(GL_LINE_LOOP);
		glVertex2i(nBeginPosX, nBeginPosY);
		glVertex2i(nEndPosX, nEndPosY);
	glEnd();
}

void C2DTools::DrawRect(int nPosX, int nPosY, int nWidth, int nHeight, bool bFilled)
{
	if (bFilled)
		glBegin(GL_QUADS);	//Rechteck mit Fllfarbe
	else
		glBegin(GL_LINE_LOOP);	//Rechteck ohne Fllfarbe

	glVertex2i(nPosX, nPosY);
	glVertex2i(nPosX + nWidth, nPosY);
	glVertex2i(nPosX + nWidth, nPosY + nHeight);
	glVertex2i(nPosX, nPosY + nHeight);

	glEnd();
}

/*static bool C2DTools::RectCollides(SRect rect1, SRect rect2)
{
	float fOrientation = rect1.fAngle - rect1.fAngle;	// orientation of rotated rr1
	float fCosOrient = cosf(fOrientation);				// precalculated trigonometic -
    float fSinOrient = sinf(fOrientation);				// - values for repeated use

	float t, x, a;      // temporary variables for various uses
	float dx;           // deltaX for linear equations
	float ext1, ext2;   // min/max vertical values

	// move rr2 to make rr1 cannonic
	C = rr2->C;
	rect2.vCenter -= rect1.vCenter;

	// rotate rr2 clockwise by rr2->ang to make rr2 axis-aligned
	rect2.vCenter.Rotate(-rect2.fAngle);

	// calculate vertices of (moved and axis-aligned := 'ma') rr2
	Vec2D vR2BottomLeft = rect2.vCenter - rect2.vShape;
	Vec2D vR2TopRight = rect2.vCenter + rect2.vShape;

	// calculate vertices of (rotated := 'r') rr1
	Vec2D vR1TopRight, vR1BottomLeft;

	vR1TopRight.x = -rect1.vShape.y * fSinOrient;
	vR1BottomLeft.x = vR1TopRight.x;
	t = rect1.vShape.x * fCosOrient;
	vR1TopRight.x += t;
	vR1BottomLeft.x -= t;

	vR1TopRight.y =  rect1.vShape.y * fCosOrient;
	vR1BottomLeft.y = vR1TopRight.y;
	t = rect1->vShape.x * fSinOrient;
	vR1TopRight.y += t;
	vR1BottomLeft.y -= t;

	t = fSinOrient * fCosOrient;

	// verify that vR1TopRight is vertical min/max, vR1BottomLeft is horizontal min/max
	if (t < 0)
	{
		t = vR1TopRight.x; vR1TopRight.x = vR1BottomLeft.x; vR1BottomLeft.x = t;
		t = vR1TopRight.y; vR1TopRight.y = vR1BottomLeft.y; vR1BottomLeft.y = t;
	}

	// verify that B is horizontal minimum (leftest-vertex)
	if (fSinOrient < 0) { vR1BottomLeft.x = -vR1BottomLeft.x; vR1BottomLeft.y = -vR1BottomLeft.y; }

	// if rr2(ma) isn't in the horizontal range of
	// colliding with rr1(r), collision is impossible
	if (vR1BottomLeft.x > vR2TopRight.x || vR1TopRight.x > -vR2BottomLeft.x)
		return false;

	// if rr1(r) is axis-aligned, vertical min/max are easy to get
	if (t == 0)
	{
		ext1 = vR1TopRight.y;
		ext2 = -ext1;
	}
	// else, find vertical min/max in the range [vR2BottomLeft.x, vR2TopRight.x]
	else
	{
		x = vR2BottomLeft.x - vR1TopRight.x; a = vR2TopRight.x - vR1TopRight.x;
		ext1 = vR1TopRight.y;

		// if the first vertical min/max isn't in (vR2BottomLeft.x, vR2TopRight.x), then
		// find the vertical min/max on vR2BottomLeft.x or on vR2TopRight.x
		if (a * x > 0)
		{
			dx = vR1TopRight.x;
		
			if (x < 0)
			{
				dx -= vR2BottomLeft.x; ext1 -= vR2BottomLeft.y; x = a;
			}
			else
			{
				dx += vR1BottomLeft.x;
				ext1 += vR1BottomLeft.y;
			}
			ext1 *= x;
			ext1 /= dx;
			ext1 += vR1TopRight.y;
		}

		x = vR2BottomLeft.x+vR1TopRight.x;
		a = vR2TopRight.x+vR1TopRight.x;
		ext2 = -vR1TopRight.y;

		// if the second vertical min/max isn't in (vR2BottomLeft.x, vR2TopRight.x), then
		// find the local vertical min/max on vR2BottomLeft.x or on vR2TopRight.x
		if (a * x > 0)
		{
			dx = -vR1TopRightx.x;
			if (x < 0) { dx -= vR1BottomLeft.x; ext2 -= vR1BottomLeft.y; x = a; }
			else       { dx += vR1BottomLeft.x; ext2 += vR1BottomLeft.y; }
			ext2 *= x; ext2 /= dx; ext2 -= vR1TopRight.y;
		}
	}

	// check whether rr2(ma) is in the vertical range of colliding with rr1(r)
	// (for the horizontal range of rr2)
	return !((ext1 < vR2BottomLeft.y && ext2 < vR2BottomLeft.y) ||
	  (ext1 > vR2TopRight.y && ext2 > vR2TopRight.y));
}*/