#ifndef C2DTOOLS_HPP
#define C2DTOOLS_HPP

#include "../client/PlatformFramework.hpp"
#include "../globals.hpp"

/// Enthaelt verschiedene statische Hilffunktionen zur 2D-Ausgabe
/// Wichtig sind Enter2DMode() und Leave2DMode(). Jede Funktion muss in
/// einem von Enter2DMode() und Leave2DMode() umschlossen Block aufgerufen
/// werden!
class C2DTools
{
	public:
		/// 2D Modus anschalten
		static void Enter2DMode();

		/// 2D Modus ausschalten
		static void Leave2DMode();

		/// Linie im 2D Modus zeichnen
		static void DrawLine(int nBeginPosX, int nBeginPosY, int nEndPosX, int nEndPosY);

		/// Rechteck im 2D Modus zeichnen
		static void DrawRect(int nPosX, int nPosY, int nWidth, int nHeight, bool bFilled = true);
};

#endif
