#include "3DTools.hpp"


void C3DTools::drawAxis(float fScale, bool bColorized)
{
	glDisable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);	//Beleuchtung ausschalten fr Koord.syst., damit Farben wirken!

	if (!bColorized)
	{
		glColor3f (1.0, 1.0, 1.0);
	}

	glPushMatrix();		//Aktuellen Matrixstand sichern

	if (bColorized)
		glColor3f (1.0, 0.0, 0.0);	//x=rot

	glScalef (10.0, 0.05, 0.05);
	glutSolidCube(fScale);
	glPopMatrix();		//Gesicherten Matrixstand wiederherstellen

	glPushMatrix();

	if (bColorized)
		glColor3f (0.0, 1.0, 0.0);	//y=grn

	glScalef (0.05, 10.0, 0.05);
	glutSolidCube(fScale);
	glPopMatrix();

	glPushMatrix();

	if (bColorized)
		glColor3f (0.0, 0.0, 1.0);	//z=blau

	glScalef (0.05, 0.05, 10.0);
	glutSolidCube(fScale);
	glPopMatrix();

	glColor3f (1.0, 1.0, 1.0);

	glEnable(GL_LIGHTING);	//Beleuchtung wieder an!
	glEnable(GL_TEXTURE_2D);
}
