#include "../globals.hpp"
#include "BaseThread.hpp"

BaseThread::BaseThread()
{
	m_pThread = NULL;
	m_bTerminate = false;
	m_bDone = true;
}

BaseThread::~BaseThread()
{
	Terminate();
}

bool BaseThread::Start()
{
	if (GetThreadPointer() != NULL)
		return true;

	// Neuen Thread erzeugen
	DEBUG_PRINTL("Chreate Thread");
	SDL_Thread* pThread = 
		SDL_CreateThread(BaseThread::StartThread, (void*) this);
	
	if (pThread == NULL)
	{
		DEBUG_PRINTL("Thread could not be created");
		m_bDone = true;
		return false;
	}
	else
	{
		DEBUG_PRINTL("Thread created");
		SetThreadPointer(pThread);
				
		m_bDone = false;
		return true;
	}
}

int BaseThread::Run()
{
	return 0;
}

int BaseThread::Terminate()
{
	if (m_bDone == true || m_bTerminate == true)
	{
		return 0;
	}
	
	int nResult;
	m_bTerminate = true;
	
	SDL_WaitThread(GetThreadPointer(), &nResult);
	m_bDone = true;
	return nResult;
}

void BaseThread::SetThreadPointer(SDL_Thread* pThread)
{
	m_pThread = pThread;
}

SDL_Thread* BaseThread::GetThreadPointer()
{
	return m_pThread;
}

int BaseThread::StartThread(void* pThreadObject)
{
	BaseThread* pThread = (BaseThread*) pThreadObject;
		
	// Ausfuehrung wird gestartet
	return pThread->Run();
}