#ifndef BASETHREAD_HPP_
#define BASETHREAD_HPP_

#include "../client/PlatformFramework.hpp"

/// Basis Thread Klasse

class BaseThread
{
public:
	/// Konstruktor

	BaseThread();
	
	virtual ~BaseThread();
	
	/// Thread starten
	/// @return	true wenn der Thread gestartet werden konnte, sonst false

	bool Start();
	
	/// Funktion die in einem neuen Thread ausgefuehrt wird
	/// @return	Einen Integer wert der auskunft ueber Erfolg gibt

	virtual int Run();
	
	/// Den Thread beenden
	/// @return	Rueckgabewert der Run-Funktion

	virtual int Terminate();
	
	/// Setzt den Thread-Zeiger fuer sich selbst. Ist noetig, damit
	/// SDL_WaitThread() mittels GetThreadPointer() an den Thread kommt

	void SetThreadPointer(SDL_Thread* pThread);

	/// SDL_WaitThread() braucht das, damit es an den Thread kommt und
	/// darauf warten kann, dass sich der Thread ordentlich beendet

	SDL_Thread* GetThreadPointer();
	
protected:
	/// Zeigen auf eigenen Thread
	SDL_Thread* m_pThread;		
	
	/// true wenn Thread beendet werden soll
	bool m_bTerminate;
	
	/// true wenn thread wirklich beendet wurde
	bool m_bDone;
	
	/// Hilfsfunktion zum starten des Threads
	/// @param BaseThread-objekt zum starten
	/// @return Return code von Run

	static int StartThread(void* pThreadObject);
};

#endif ///BASETHREAD_HPP_///
