#include "FileTools.hpp"

string CFileTools::ConvertWChar2String(const CHAR* const wcharArray)
{
    stringstream sstream;

	char c;
    int i = 0;
    do
	{
		c = (char) wcharArray[i];
        sstream << c;

        i++;
    } while (c != '\0');

	return sstream.str();
}

bool CFileTools::GetFiles(const char* szDir, vector<string>& vFiles)
{
#ifdef WIN32
	//WIN32 only!
	LPWIN32_FIND_DATAA findFileData = new _WIN32_FIND_DATAA;

	HANDLE hFind = FindFirstFileA((LPCSTR)szDir, findFileData);	//... beim Server LPCWSTR... ich kapiers nich! Bei mir is wieder anders ;)

    if(hFind  == INVALID_HANDLE_VALUE)
	{
        return false;
    }

    //int nFileNumber = 0;

	vFiles.push_back(ConvertWChar2String((char*)findFileData->cFileName));

    while(FindNextFileA(hFind, findFileData))
	{
        vFiles.push_back(ConvertWChar2String((char*)findFileData->cFileName));
		if(hFind  == INVALID_HANDLE_VALUE)
		{
			return false;
		}
    }

    FindClose(hFind);
#endif
#if defined(LINUX) or defined(MACOS)
    DIR *directory;
	struct dirent *entry;

    if((directory = opendir(szDir)) == NULL)
    {
    	return false;
    }

    while ((entry = readdir(directory)) != NULL)
    {
    	if (entry->d_name[0] != '.')
    	{
    		vFiles.push_back(entry->d_name);
    	}
    }
    closedir(directory);
#endif
	return true;
}

void CFileTools::TokenizeStr(const string& str, vector<string>& tokens,  const string& delimiters)
{
    // Skip delimiters at beginning.
    string::size_type lastPos = str.find_first_not_of(delimiters, 0);
    // Find first "non-delimiter".
    string::size_type pos     = str.find_first_of(delimiters, lastPos);

    while (string::npos != pos || string::npos != lastPos)
    {
        // Found a token, add it to the vector.
        tokens.push_back(str.substr(lastPos, pos - lastPos));
        // Skip delimiters.  Note the "not_of"
        lastPos = str.find_first_not_of(delimiters, pos);
        // Find next "non-delimiter"
        pos = str.find_first_of(delimiters, lastPos);
    }
}

void CFileTools::TrimStr(string& str)
{
	str.erase(0, str.find_first_not_of(" \t\n\r"));	//Whitespace vom Anfang abschneiden
	str.erase(str.find_last_not_of(" \t\n\r") + 1);		//Whitespace vom Ende abschneiden
}

void CFileTools::StrToUpper(string &str)
{
	transform(str.begin(), str.end(), str.begin(), (int(*)(int)) toupper);
}
