#ifndef FILETOOLS_HPP
#define FILETOOLS_HPP

#include <string>
#include <vector>
#include <sstream>
#include <algorithm>

#include "PlatformFileTools.hpp"

using namespace std;

class CFileTools
{
	public:
		/// Alle Dateien eines Ordners in einen Vektor einlesen
		/// Achtung: Vektor wird nicht per clear() geloescht!
		static bool GetFiles(const char* szDir, vector<string>& vFiles);

		/// WCHAR in string umwandeln
		static string ConvertWChar2String(const CHAR* const wcharArray);

		/// Einen String splitten
		/// @see http://www.oopweb.com/CPP/Documents/CPPHOWTO/Volume/C++Programming-HOWTO-7.html
		/// @author OOPWeb.com
		static void TokenizeStr(const string& str, vector<string>& tokens, const string& delimiters = " ");

		/// Whitespace am Anfang und Ende eines Strings entfernen
		static void TrimStr(string& str);

		/// Uppercase transform
		static void StrToUpper(string& str);
};

#endif
