#ifndef SINGLETON_HPP
#define SINGLETON_HPP

/// Template Klasse fr Singletonobjekte: Stellt Zugriff auf Singleton-Objekte zur
/// Verfgung. Singleton-Objekte sind solche, die im ganzen Programm
/// nur eine Instanz haben, auf die von allen anderen Objekten global
/// zugegriffen werden kann, z.B. der Timer oder das Framework
template <class T>
class TSingleton
{
	protected:
		/// Statisches Objekt
		static T *m_pSingleton;

	public:
		/// Immer der Dekonstruktor der abgeleiteten Klasse wird aufgerufen!
		virtual ~TSingleton ()
		{
		}

		/// Gibt bool zurck, ob dieses Singletonobjekt instanziiert wurde
		inline static bool IsInstantiated()
		{
			if (!m_pSingleton)
				return false;
			else
				return true;
		}

		/// Zeiger auf das Singletonobjekt zurckgeben
		/// Falls das Objekt noch nicht existiert, wird
		/// es auf dem Heap erzeugt
		inline static T* Get ()
		{
			// Existiert schon eine Instanz?
			if (!m_pSingleton)
				m_pSingleton = new T;   // Nein, dann neue Instanz erzeugen

			// Zeiger auf die Instanz zurckgeben
			return (m_pSingleton);
		}

		/// Instanz freigeben
		static void Del ()
		{
			// Gab es eine Instanz?
			if (m_pSingleton)
			{
				delete (m_pSingleton);  // Ja, dann freigeben
				m_pSingleton = NULL;    // und Zeiger auf NULL setzen
			}
		}
};

// Die statische Variable erzeugen
template <class T>
T* TSingleton<T>::m_pSingleton = 0;

#endif
