#ifndef TIMER_HPP
#define TIMER_HPP

#include <SDL/SDL.h>

#include "Singleton.hpp"

#define g_pTimer CTimer::Get ()

/// Timerklasse als Singletonobjekt.
/// Zhlt der vergangen Zeit seit dem letzten Frame. Damit lassen
/// sich Zhler und Funktionen realisieren, die unabhngig von der
/// Prozessorgeschwindigkeit sind!
class CTimer : public TSingleton<CTimer>
{
	public:
		/// Konstruktor: Initialisierung des Timers
		CTimer           ();

		/// Timer aktualisieren, d.h. bergangene Zeit seit dem letzten
		/// Frame berechnen
		void  Update     ();

		/// Vergangene Zeit seit den letzten Frame zurckgeben
		float GetElapsed () { return m_fElapsed; }

		/// Aktuelle Zeit zurckgeben
		float GetCurTime() { return m_fCurTime; }

	private:
		float m_fElapsed;	///< Vergangene Zeit seit dem letzten Frame
		float m_fCurTime;	///< Aktuelle Zeit
		float m_fLastTime;	///< Zeit des letzten Frames
};

#endif
