/*
 * Decompiled with CFR 0.152.
 */
import generativedesign.Node;
import generativedesign.Spring;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import processing.core.PApplet;
import processing.core.PFont;

public class Ue3_Konrad_markus
extends PApplet {
    IAManager iaManager = null;
    Node centerNode;
    ArrayList originList = new ArrayList();
    DataMaxima dataMax = new DataMaxima();
    int ringColor = this.color(255, 255, 255, 80);
    PFont carNodeFont;
    PFont manuNodeFont;
    PFont ringFont;
    PFont centerFont;
    static final int NODE_BOUNDARY = 10;

    public void setup() {
        Object object;
        this.size(1024, 768, "processing.opengl.PGraphicsOpenGL");
        this.lights();
        this.smooth();
        this.fill(0);
        this.textMode(4);
        this.carNodeFont = this.loadFont("MyriadPro-BoldCond-14.vlw");
        this.manuNodeFont = this.loadFont("MyriadPro-BoldCond-16.vlw");
        this.ringFont = this.loadFont("MyriadPro-BoldCond-18.vlw");
        this.centerFont = this.loadFont("MyriadPro-BoldCond-42.vlw");
        String[] stringArray = this.loadStrings("cars.txt");
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> hashMap2 = new HashMap<String, ArrayList<String>>();
        int n = 1;
        while (n < stringArray.length) {
            ArrayList<String> arrayList;
            object = new Car(stringArray[n]);
            ((Car)object).nodeFont = this.carNodeFont;
            if (hashMap.containsKey(((Car)object).origin)) {
                arrayList = (ArrayList<String>)hashMap.get(((Car)object).origin);
                if (!arrayList.contains(((Car)object).manufacturer)) {
                    arrayList.add(((Car)object).manufacturer);
                }
            } else {
                arrayList = new ArrayList<String>();
                arrayList.add(((Car)object).manufacturer);
                hashMap.put(((Car)object).origin, arrayList);
            }
            if (hashMap2.containsKey(((Car)object).manufacturer)) {
                ((ArrayList)hashMap2.get(((Car)object).manufacturer)).add(object);
            } else {
                arrayList = new ArrayList<String>();
                arrayList.add((String)object);
                hashMap2.put(((Car)object).manufacturer, arrayList);
            }
            ++n;
        }
        Ue3_Konrad_markus.println((String)("Loaded " + (stringArray.length - 1) + " cars"));
        Ue3_Konrad_markus.println((String)("Loaded " + hashMap.size() + " origins"));
        Ue3_Konrad_markus.println((String)("Loaded " + hashMap2.size() + " manufacturers"));
        Map map = this.sortByArrayListSize(hashMap);
        this.centerNode = new Node((float)(this.width / 2), (float)(this.height / 2), 0.0f);
        this.centerNode.setStrength(-2.0f);
        this.centerNode.setDamping(0.1f);
        this.centerNode.setBoundary(0.0f, 0.0f, 0.0f, (float)this.width, (float)this.height, 0.0f);
        object = map.entrySet().iterator();
        int n2 = 0;
        int n3 = 300 / map.size();
        Origin origin = new Origin("Cars", 100, this.ringColor);
        this.originList.add(origin);
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string = (String)entry.getKey();
            ArrayList arrayList = (ArrayList)entry.getValue();
            Ue3_Konrad_markus.println((String)("> Loaded origin #" + n2 + ": " + string + " with " + arrayList.size() + " manufacturers"));
            Manufacturer manufacturer = null;
            Manufacturer manufacturer2 = null;
            boolean bl = true;
            Origin origin2 = new Origin(string, 2 * (100 + n2 * n3) + 100, this.ringColor);
            origin2.ringFont = this.ringFont;
            float f = (float)Math.PI * 2 / (float)arrayList.size();
            float f2 = 0.0f;
            int n4 = 0;
            while (n4 < arrayList.size()) {
                String string2 = (String)arrayList.get(n4);
                ArrayList arrayList2 = (ArrayList)hashMap2.get(string2);
                Manufacturer manufacturer3 = new Manufacturer(string2, arrayList2, this.centerNode);
                manufacturer3.nodeFont = this.manuNodeFont;
                int n5 = this.width / 2 + (int)(Ue3_Konrad_markus.cos((float)f2) * 10.0f);
                int n6 = this.height / 2 + (int)(Ue3_Konrad_markus.sin((float)f2) * 10.0f);
                f2 += f;
                manufacturer3.createNode(n5, n6);
                manufacturer3.createSpringToCenter(100 + n2 * n3);
                if (bl) {
                    manufacturer2 = manufacturer3;
                    bl = false;
                } else {
                    manufacturer.nextManu = manufacturer3;
                }
                origin2.manus.add(manufacturer3);
                manufacturer = manufacturer3;
                ++n4;
            }
            manufacturer.nextManu = manufacturer2;
            this.originList.add(origin2);
            ++n2;
            this.iaManager = new IAManager(this.originList);
        }
    }

    public void mousePressed() {
        this.iaManager.press(this.mouseX, this.mouseY);
    }

    public void mouseClicked() {
        this.iaManager.click(this.mouseX, this.mouseY);
    }

    public void mouseDragged() {
        this.iaManager.drag(this.mouseX, this.mouseY);
    }

    public void mouseReleased() {
        this.iaManager.release(this.mouseX, this.mouseY);
    }

    public void draw() {
        this.background(0);
        this.drawContent();
        this.iaManager.drawWindows();
    }

    private void drawContent() {
        int n = 0;
        while (n < this.originList.size()) {
            Origin origin = (Origin)this.originList.get(n);
            origin.update();
            origin.draw();
            ++n;
        }
    }

    public boolean overCircle(int n, int n2, int n3, int n4, int n5) {
        float f = n3 - n;
        float f2 = n4 - n2;
        return Ue3_Konrad_markus.sqrt((float)(Ue3_Konrad_markus.sq((float)f) + Ue3_Konrad_markus.sq((float)f2))) < (float)(n5 / 2);
    }

    public boolean overRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n <= n3 + n5 && n2 >= n4 && n2 <= n4 + n6;
    }

    private Map sortByArrayListSize(Map map) {
        LinkedList linkedList = new LinkedList(map.entrySet());
        Collections.sort(linkedList, new Comparator(){

            public int compare(Object object, Object object2) {
                ArrayList arrayList = (ArrayList)((Map.Entry)object).getValue();
                ArrayList arrayList2 = (ArrayList)((Map.Entry)object2).getValue();
                Integer n = new Integer(arrayList.size());
                Integer n2 = new Integer(arrayList2.size());
                return n.compareTo(n2);
            }
        });
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry : linkedList) {
            linkedHashMap.put(entry.getKey(), entry.getValue());
        }
        return linkedHashMap;
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "Ue3_Konrad_markus"});
    }

    class Car
    implements ClickableObject {
        String car;
        String manufacturer;
        float consumption;
        int cylinders;
        float displacement;
        float horsepower;
        float weight;
        float accel;
        int year;
        String origin;
        int sphereSize = 20;
        int objColor;
        int textColor;
        PFont nodeFont;
        float textW;
        float textH;
        Car nextCar;
        Manufacturer manuObj;
        InfoWindow infoWindow;
        Node carNode;
        Spring springToNextCar;
        Spring springToManu;
        int lastClick;
        int clickTimeout;
        int wasSetToVisible;

        Car(String string) {
            this.objColor = Ue3_Konrad_markus.this.color(255, 255, 255, 255);
            this.textColor = Ue3_Konrad_markus.this.color(0, 0, 0, 255);
            this.textW = 0.0f;
            this.textH = 14.0f;
            this.nextCar = null;
            this.manuObj = null;
            this.infoWindow = null;
            this.carNode = null;
            this.springToNextCar = null;
            this.springToManu = null;
            this.lastClick = 0;
            this.clickTimeout = 500;
            this.wasSetToVisible = 0;
            String[] stringArray = Ue3_Konrad_markus.splitTokens((String)string, (String)"\t");
            int n = 0;
            this.car = stringArray[n++];
            this.manufacturer = stringArray[n++];
            this.consumption = PApplet.parseFloat((String)stringArray[n++]) * 1.609f / 3.785f;
            this.cylinders = PApplet.parseInt((String)stringArray[n++]);
            this.displacement = PApplet.parseFloat((String)stringArray[n++]) * 16.387f;
            this.horsepower = PApplet.parseFloat((String)stringArray[n++]);
            this.weight = PApplet.parseFloat((String)stringArray[n++]) * 0.4536f;
            this.accel = PApplet.parseFloat((String)stringArray[n++]);
            this.year = PApplet.parseInt((String)stringArray[n++]);
            this.origin = stringArray[n++];
            if (this.manufacturer.equals("buick")) {
                this.manufacturer = this.origin.toLowerCase().equals("american") ? String.valueOf(this.manufacturer) + " (us)" : String.valueOf(this.manufacturer) + " (eu)";
            }
            if (this.consumption > Ue3_Konrad_markus.this.dataMax.consumption) {
                Ue3_Konrad_markus.this.dataMax.consumption = this.consumption;
            }
            if (this.cylinders > Ue3_Konrad_markus.this.dataMax.cylinders) {
                Ue3_Konrad_markus.this.dataMax.cylinders = this.cylinders;
            }
            if (this.displacement > Ue3_Konrad_markus.this.dataMax.displacement) {
                Ue3_Konrad_markus.this.dataMax.displacement = this.displacement;
            }
            if (this.horsepower > Ue3_Konrad_markus.this.dataMax.horsepower) {
                Ue3_Konrad_markus.this.dataMax.horsepower = this.horsepower;
            }
            if (this.weight > Ue3_Konrad_markus.this.dataMax.weight) {
                Ue3_Konrad_markus.this.dataMax.weight = this.weight;
            }
            if (this.accel > Ue3_Konrad_markus.this.dataMax.accel) {
                Ue3_Konrad_markus.this.dataMax.accel = this.accel;
            }
            if (this.year > Ue3_Konrad_markus.this.dataMax.year) {
                Ue3_Konrad_markus.this.dataMax.year = this.year;
            }
            this.infoWindow = new InfoWindow(this);
        }

        public void createNode(int n, int n2) {
            this.carNode = new Node((float)n, (float)n2, 0.0f);
            this.carNode.setStrength(-2.0f);
            this.carNode.setDamping(0.1f);
            this.carNode.setBoundary(10.0f, 10.0f, 0.0f, (float)(Ue3_Konrad_markus.this.width - 10), (float)(Ue3_Konrad_markus.this.height - 10), 0.0f);
        }

        public void createSpringToManu() {
            this.springToManu = new Spring(this.carNode, this.manuObj.manuNode);
            this.springToManu.setStiffness(0.7f);
            this.springToManu.setDamping(0.9f);
            this.springToManu.setLength(100.0f);
        }

        public void createSpringToNextCar(int n) {
            this.springToNextCar = new Spring(this.carNode, this.nextCar.carNode);
            this.springToNextCar.setStiffness(0.7f);
            this.springToNextCar.setDamping(0.9f);
            this.springToNextCar.setLength((float)n);
        }

        public boolean clickAtPos(int n, int n2) {
            if (this.wasSetToVisible > 0 && Ue3_Konrad_markus.this.overRect(n, n2, (int)this.carNode.x - (int)this.textW / 2, (int)this.carNode.y - (int)this.textH / 2, (int)this.textW, (int)this.textH)) {
                Ue3_Konrad_markus.println((String)("Click on " + this.car));
                if (!this.infoWindow.visible) {
                    this.infoWindow.open((int)this.carNode.x, (int)this.carNode.y);
                }
                return true;
            }
            return false;
        }

        public void update() {
            this.attractToNodes();
            if (this.springToManu != null) {
                this.springToManu.update();
            }
            if (this.springToNextCar != null) {
                this.springToNextCar.update();
            }
            if (this.carNode != null) {
                this.carNode.update();
            }
            if (this.infoWindow.visible) {
                this.infoWindow.update();
            }
        }

        public void draw() {
            this.drawSelf();
            this.drawDebug();
        }

        private void drawSelf() {
            Ue3_Konrad_markus.this.noStroke();
            Ue3_Konrad_markus.this.fill(this.objColor);
            Ue3_Konrad_markus.this.pushMatrix();
            Ue3_Konrad_markus.this.translate(this.carNode.x, this.carNode.y, 1.0f);
            String string = this.car.toUpperCase();
            this.textW = Ue3_Konrad_markus.this.textWidth(string) + 2.0f;
            Ue3_Konrad_markus.this.fill(Ue3_Konrad_markus.this.color(255, 255, 255, 255));
            Ue3_Konrad_markus.this.rectMode(3);
            Ue3_Konrad_markus.this.rect(0.0f, 0.0f, this.textW, this.textH);
            Ue3_Konrad_markus.this.fill(Ue3_Konrad_markus.this.color(0, 0, 0, 255));
            Ue3_Konrad_markus.this.textFont(this.nodeFont, 14.0f);
            Ue3_Konrad_markus.this.textAlign(3);
            Ue3_Konrad_markus.this.text(string, 0.0f, 5.0f);
            Ue3_Konrad_markus.this.popMatrix();
        }

        private void drawDebug() {
            Ue3_Konrad_markus.this.stroke(255.0f, 255.0f, 0.0f, 255.0f);
            Ue3_Konrad_markus.this.strokeWeight(2.0f);
            if (this.carNode != null && this.manuObj != null && this.springToManu != null) {
                Ue3_Konrad_markus.this.line(this.carNode.x, this.carNode.y, 0.0f, this.manuObj.manuNode.x, this.manuObj.manuNode.y, 0.0f);
            }
            if (this.carNode != null && this.nextCar != null && this.springToNextCar != null) {
                Ue3_Konrad_markus.this.line(this.carNode.x, this.carNode.y, 0.0f, this.nextCar.carNode.x, this.nextCar.carNode.y, 0.0f);
            }
        }

        private void attractToNodes() {
            if (this.carNode != null && this.manuObj != null) {
                this.carNode.attract(this.manuObj.manuNode);
                this.manuObj.manuNode.attract(this.carNode);
            }
            if (this.carNode != null && this.nextCar != null) {
                this.carNode.attract(this.nextCar.carNode);
                this.nextCar.carNode.attract(this.carNode);
            }
        }

        public String toString() {
            String string = "Car: ";
            string = String.valueOf(string) + this.car + ",";
            string = String.valueOf(string) + this.manufacturer + ",";
            string = String.valueOf(string) + this.consumption + ",";
            string = String.valueOf(string) + this.cylinders + ",";
            string = String.valueOf(string) + this.displacement + ",";
            string = String.valueOf(string) + this.horsepower + ",";
            string = String.valueOf(string) + this.weight + ",";
            string = String.valueOf(string) + this.accel + ",";
            string = String.valueOf(string) + this.year + ",";
            string = String.valueOf(string) + this.origin;
            return string;
        }
    }

    static interface ClickableObject {
        public boolean clickAtPos(int var1, int var2);
    }

    class DataMaxima {
        float consumption = Float.MIN_VALUE;
        int cylinders = Integer.MIN_VALUE;
        float displacement = Float.MIN_VALUE;
        float horsepower = Float.MIN_VALUE;
        float weight = Float.MIN_VALUE;
        float accel = Float.MIN_VALUE;
        int year = Integer.MIN_VALUE;

        DataMaxima() {
        }
    }

    static interface DragableObject {
        public boolean startDragAtPos(int var1, int var2);

        public boolean dragAtPos(int var1, int var2);
    }

    class IAManager {
        ArrayList originList = null;
        ArrayList windowList = new ArrayList();
        DragableObject curDragableObj = null;

        IAManager(ArrayList arrayList) {
            this.originList = arrayList;
        }

        public void registerWindow(InfoWindow infoWindow) {
            if (!this.windowList.contains(infoWindow)) {
                this.windowList.add(infoWindow);
            }
        }

        public void unregisterWindow(InfoWindow infoWindow) {
            if (this.windowList.contains(infoWindow)) {
                this.windowList.remove(this.windowList.indexOf(infoWindow));
            }
        }

        public void drawWindows() {
            int n = 0;
            while (n < this.windowList.size()) {
                InfoWindow infoWindow = (InfoWindow)this.windowList.get(n);
                infoWindow.update();
                infoWindow.draw();
                ++n;
            }
        }

        public void click(int n, int n2) {
            Object object;
            int n3 = 0;
            while (n3 < this.windowList.size()) {
                object = (InfoWindow)this.windowList.get(n3);
                if (((InfoWindow)object).clickAtPos(n, n2)) {
                    return;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < this.originList.size()) {
                object = (Origin)this.originList.get(n3);
                int n4 = 0;
                while (n4 < ((Origin)object).manus.size()) {
                    Manufacturer manufacturer = (Manufacturer)((Origin)object).manus.get(n4);
                    if (manufacturer.clickAtPos(n, n2)) {
                        return;
                    }
                    int n5 = 0;
                    while (n5 < manufacturer.cars.size()) {
                        Car car = (Car)manufacturer.cars.get(n5);
                        if (car.clickAtPos(n, n2)) {
                            return;
                        }
                        ++n5;
                    }
                    ++n4;
                }
                ++n3;
            }
        }

        public void press(int n, int n2) {
            int n3 = 0;
            while (n3 < this.windowList.size()) {
                InfoWindow infoWindow = (InfoWindow)this.windowList.get(n3);
                if (infoWindow.startDragAtPos(n, n2)) {
                    this.curDragableObj = infoWindow;
                    Ue3_Konrad_markus.println((String)("Start to drag with window#" + n3));
                    return;
                }
                ++n3;
            }
        }

        public void release(int n, int n2) {
            this.curDragableObj = null;
        }

        public void drag(int n, int n2) {
            if (this.curDragableObj != null) {
                this.curDragableObj.dragAtPos(n, n2);
            }
        }
    }

    class InfoWindow
    implements DragableObject,
    ClickableObject {
        Car car;
        boolean visible = false;
        int x;
        int y;
        int w = 400;
        int h = 170;
        int headerH = 30;
        int closeX = this.headerH / 2 + 1;
        int closeY = this.headerH / 2;
        int closeCircleDia = this.headerH - 5;
        int startDragX;
        int startDragY;
        int borderColor;
        int bgColor;
        int closeButtonColor;
        int headerColor;
        int headerTextColor;
        int contentTextColor;
        PFont headerFont;
        PFont contentFont;

        InfoWindow(Car car) {
            this.borderColor = Ue3_Konrad_markus.this.color(255, 255, 255, 192);
            this.bgColor = Ue3_Konrad_markus.this.color(0, 0, 0, 196);
            this.closeButtonColor = Ue3_Konrad_markus.this.color(40, 40, 40, 255);
            this.headerColor = Ue3_Konrad_markus.this.color(255, 255, 255, 64);
            this.headerTextColor = Ue3_Konrad_markus.this.color(255, 255, 255, 255);
            this.contentTextColor = Ue3_Konrad_markus.this.color(255, 255, 255, 255);
            this.car = car;
            this.headerFont = Ue3_Konrad_markus.this.manuNodeFont;
            this.contentFont = Ue3_Konrad_markus.this.carNodeFont;
        }

        public boolean startDragAtPos(int n, int n2) {
            if (Ue3_Konrad_markus.this.overRect(n, n2, this.x, this.y, this.w, this.headerH)) {
                if (Ue3_Konrad_markus.this.overCircle(n, n2, this.x + this.closeX - this.closeCircleDia / 2, this.y + this.closeY, this.closeCircleDia + 5)) {
                    this.close();
                    return true;
                }
                this.startDragX = n - this.x;
                this.startDragY = n2 - this.y;
                return true;
            }
            return false;
        }

        public boolean dragAtPos(int n, int n2) {
            this.x = n - this.startDragX;
            this.y = n2 - this.startDragY;
            return false;
        }

        public boolean clickAtPos(int n, int n2) {
            if (Ue3_Konrad_markus.this.overRect(n, n2, this.x, this.y, this.w, this.h)) {
                if (Ue3_Konrad_markus.this.overCircle(n, n2, this.x + this.closeX - this.closeCircleDia / 2, this.y + this.closeY, this.closeCircleDia + 5)) {
                    this.close();
                }
                return true;
            }
            return false;
        }

        public void open(int n, int n2) {
            if (this.visible) {
                return;
            }
            this.visible = true;
            this.setAtCenterPos(n, n2);
            Ue3_Konrad_markus.this.iaManager.registerWindow(this);
        }

        public void close() {
            if (!this.visible) {
                return;
            }
            this.visible = false;
            Ue3_Konrad_markus.this.iaManager.unregisterWindow(this);
        }

        public void setAtCenterPos(int n, int n2) {
            this.x = n - this.w / 2;
            this.y = n2 - this.h / 2;
            if (this.y < 0) {
                this.y = 0;
            }
        }

        public void draw() {
            if (this.visible) {
                Ue3_Konrad_markus.this.pushMatrix();
                Ue3_Konrad_markus.this.translate(this.x, this.y, 20.0f);
                this.drawWindow();
                this.drawHeader();
                this.drawContent();
                Ue3_Konrad_markus.this.popMatrix();
            }
        }

        public void update() {
        }

        private void drawWindow() {
            Ue3_Konrad_markus.this.strokeWeight(1.0f);
            Ue3_Konrad_markus.this.stroke(this.borderColor);
            Ue3_Konrad_markus.this.fill(this.bgColor);
            Ue3_Konrad_markus.this.rectMode(0);
            Ue3_Konrad_markus.this.rect(0.0f, 0.0f, this.w, this.h);
        }

        private void drawHeader() {
            Ue3_Konrad_markus.this.noStroke();
            Ue3_Konrad_markus.this.fill(this.headerColor);
            Ue3_Konrad_markus.this.rectMode(0);
            Ue3_Konrad_markus.this.rect(0.0f, 0.0f, this.w, this.headerH);
            Ue3_Konrad_markus.this.fill(this.headerTextColor);
            Ue3_Konrad_markus.this.textFont(this.headerFont, 16.0f);
            Ue3_Konrad_markus.this.textAlign(3);
            Ue3_Konrad_markus.this.text((String.valueOf(this.car.manufacturer) + " " + this.car.car + " ('" + this.car.year + ")").toUpperCase(), this.w / 2, this.headerH / 2 + 5);
            Ue3_Konrad_markus.this.ellipseMode(3);
            Ue3_Konrad_markus.this.fill(this.closeButtonColor);
            Ue3_Konrad_markus.this.noStroke();
            Ue3_Konrad_markus.this.ellipse(this.closeX, this.closeY, this.closeCircleDia, this.closeCircleDia);
            Ue3_Konrad_markus.this.stroke(Ue3_Konrad_markus.this.color(255, 255, 255, 255));
            Ue3_Konrad_markus.this.strokeWeight(2.0f);
            Ue3_Konrad_markus.this.line(this.closeX - 5, this.closeY - 5, this.closeX + 5, this.closeY + 5);
            Ue3_Konrad_markus.this.line(this.closeX - 5, this.closeY + 5, this.closeX + 5, this.closeY - 5);
        }

        private void drawContent() {
            int n = 10;
            int n2 = this.headerH + 10;
            int n3 = 280;
            int n4 = 15;
            int n5 = 5;
            this.drawBar(n, n2, n3, n4, "Consuption", this.car.consumption, "km / liter", Ue3_Konrad_markus.this.dataMax.consumption, 2);
            this.drawBar(n, n2 += n4 + n5, n3, n4, "Weight", this.car.weight, "kg", Ue3_Konrad_markus.this.dataMax.weight, 2);
            this.drawBar(n, n2 += n4 + n5, n3, n4, "Displacement", this.car.displacement, "ccm", Ue3_Konrad_markus.this.dataMax.displacement, 2);
            this.drawBar(n, n2 += n4 + n5, n3, n4, "Horsepower", this.car.horsepower, " HP", Ue3_Konrad_markus.this.dataMax.horsepower, 0);
            this.drawBar(n, n2 += n4 + n5, n3, n4, "Cylinders", this.car.cylinders, "", Ue3_Konrad_markus.this.dataMax.cylinders, 0);
            this.drawBar(n, n2 += n4 + n5, n3, n4, "Acceleration", this.car.accel, " sec", Ue3_Konrad_markus.this.dataMax.accel, 2);
        }

        private void drawBar(int n, int n2, int n3, int n4, String string, float f, String string2, float f2, int n5) {
            float f3 = f / f2;
            int n6 = (int)(f3 * (float)n3);
            int n7 = Ue3_Konrad_markus.this.color(50.0f + 200.0f * f3, 250.0f - 200.0f * f3, 0.0f);
            Ue3_Konrad_markus.this.noStroke();
            Ue3_Konrad_markus.this.fill(this.contentTextColor);
            Ue3_Konrad_markus.this.textFont(this.contentFont, 14.0f);
            Ue3_Konrad_markus.this.textAlign(37);
            Ue3_Konrad_markus.this.text(string, n, n2 + 12);
            Ue3_Konrad_markus.this.fill(n7);
            Ue3_Konrad_markus.this.rect(n + 100, n2, n6, n4);
            Ue3_Konrad_markus.this.fill(this.contentTextColor);
            Ue3_Konrad_markus.this.textFont(this.contentFont, 14.0f);
            Ue3_Konrad_markus.this.textAlign(39);
            Ue3_Konrad_markus.this.text(String.valueOf(Ue3_Konrad_markus.nf((float)f, (int)1, (int)n5)) + " " + string2, n + 100 + n3, n2 + 12);
        }
    }

    class Manufacturer
    implements ClickableObject {
        String name;
        int sphereSize = 30;
        int objColor;
        int textColor;
        PFont nodeFont;
        Manufacturer nextManu;
        ArrayList cars;
        Node centerNode;
        Node manuNode;
        Spring springToCenter;
        Spring springToNextManu;
        boolean showCars;
        int maxCarsPerGroup;
        int curGroupNum;
        int carStartNum;
        int carEndNum;
        int carNumGroups;
        int lastClick;
        int clickTimout;

        Manufacturer(String string, ArrayList arrayList, Node node) {
            this.objColor = Ue3_Konrad_markus.this.color(255, 255, 255, 192);
            this.textColor = Ue3_Konrad_markus.this.color(0, 0, 0, 255);
            this.centerNode = null;
            this.manuNode = null;
            this.springToCenter = null;
            this.springToNextManu = null;
            this.showCars = false;
            this.maxCarsPerGroup = 12;
            this.curGroupNum = 0;
            this.carStartNum = 0;
            this.carEndNum = 0;
            this.carNumGroups = 0;
            this.lastClick = 0;
            this.clickTimout = 500;
            this.name = string;
            this.centerNode = node;
            if (arrayList == null) {
                this.cars = new ArrayList();
            } else {
                this.cars = arrayList;
                this.curGroupNum = -1;
                this.carNumGroups = Ue3_Konrad_markus.ceil((float)(this.cars.size() / this.maxCarsPerGroup)) + 1;
                int n = 0;
                while (n < this.cars.size()) {
                    Car car = (Car)this.cars.get(n);
                    car.manuObj = this;
                    ++n;
                }
            }
        }

        public void createNode(int n, int n2) {
            this.manuNode = new Node((float)n, (float)n2, 0.0f);
            this.manuNode.setStrength(-2.0f);
            this.manuNode.setDamping(0.1f);
            this.manuNode.setBoundary(10.0f, 10.0f, 0.0f, (float)(Ue3_Konrad_markus.this.width - 10), (float)(Ue3_Konrad_markus.this.height - 10), 0.0f);
            this.manuNode.setDiameter((float)this.sphereSize);
            int n3 = 0;
            while (n3 < this.cars.size()) {
                Car car = (Car)this.cars.get(n3);
                car.createNode(0, 0);
                car.createSpringToManu();
                ++n3;
            }
        }

        public void createSpringToCenter(int n) {
            this.springToCenter = new Spring(this.manuNode, this.centerNode);
            this.springToCenter.setStiffness(0.7f);
            this.springToCenter.setDamping(0.9f);
            this.springToCenter.setLength((float)n);
        }

        public void createSpringToNextManu(int n) {
            this.springToNextManu = new Spring(this.manuNode, this.nextManu.manuNode);
            this.springToNextManu.setStiffness(0.7f);
            this.springToNextManu.setDamping(0.9f);
            this.springToNextManu.setLength((float)n);
        }

        public boolean clickAtPos(int n, int n2) {
            if (Ue3_Konrad_markus.this.overCircle(n, n2, (int)this.manuNode.x, (int)this.manuNode.y, this.sphereSize)) {
                Ue3_Konrad_markus.println((String)("Click on " + this.name));
                if (this.curGroupNum < 0 && !this.showCars) {
                    this.showCars = true;
                }
                ++this.curGroupNum;
                if (this.curGroupNum >= this.carNumGroups) {
                    this.showCars = false;
                    this.curGroupNum = -1;
                }
                this.carStartNum = this.curGroupNum * this.maxCarsPerGroup;
                this.carEndNum = this.carStartNum + this.maxCarsPerGroup;
                if (this.carEndNum > this.cars.size()) {
                    this.carEndNum = this.cars.size();
                }
                if (this.showCars) {
                    this.initCarNodePositions();
                } else {
                    this.hideCarNodes();
                }
                return true;
            }
            return false;
        }

        public void update() {
            if (this.showCars) {
                int n = this.carStartNum;
                while (n < this.carEndNum) {
                    Car car = (Car)this.cars.get(n);
                    car.update();
                    ++n;
                }
            }
            this.attractToNodes();
            if (this.springToCenter != null) {
                this.springToCenter.update();
            }
            if (this.springToNextManu != null) {
                this.springToNextManu.update();
            }
            if (this.manuNode != null) {
                this.manuNode.update();
            }
        }

        public void draw() {
            if (this.showCars) {
                int n = this.carStartNum;
                while (n < this.carEndNum) {
                    Car car = (Car)this.cars.get(n);
                    car.draw();
                    ++n;
                }
            }
            this.drawSelf();
        }

        private void drawSelf() {
            Ue3_Konrad_markus.this.noStroke();
            Ue3_Konrad_markus.this.fill(this.objColor);
            Ue3_Konrad_markus.this.pushMatrix();
            Ue3_Konrad_markus.this.translate(this.manuNode.x, this.manuNode.y, 0.0f);
            Ue3_Konrad_markus.this.fill(this.objColor);
            Ue3_Konrad_markus.this.ellipse(0.0f, 0.0f, this.sphereSize, this.sphereSize);
            Ue3_Konrad_markus.this.fill(this.objColor);
            Ue3_Konrad_markus.this.ellipse((float)this.sphereSize / 2.25f, (float)this.sphereSize / 2.25f, (float)this.sphereSize / 1.15f, (float)this.sphereSize / 1.15f);
            String string = this.showCars ? String.valueOf(this.carStartNum + 1) + "-" + this.carEndNum : "" + this.cars.size();
            Ue3_Konrad_markus.this.fill(this.textColor);
            Ue3_Konrad_markus.this.textFont(Ue3_Konrad_markus.this.carNodeFont, 14.0f);
            Ue3_Konrad_markus.this.textAlign(3);
            Ue3_Konrad_markus.this.text(string, (float)this.sphereSize / 2.25f, (float)this.sphereSize / 2.25f + 5.0f);
            Ue3_Konrad_markus.this.fill(this.textColor);
            Ue3_Konrad_markus.this.textFont(this.nodeFont, 16.0f);
            Ue3_Konrad_markus.this.textAlign(3);
            Ue3_Konrad_markus.this.text(this.name.toUpperCase(), 0.0f, 5.0f);
            Ue3_Konrad_markus.this.popMatrix();
        }

        private void drawDebug() {
            Ue3_Konrad_markus.this.stroke(0.0f, 255.0f, 255.0f, 255.0f);
            Ue3_Konrad_markus.this.strokeWeight(4.0f);
            if (this.manuNode != null && this.centerNode != null && this.springToCenter != null) {
                Ue3_Konrad_markus.this.line(this.manuNode.x, this.manuNode.y, 0.0f, this.centerNode.x, this.centerNode.y, 0.0f);
            }
            if (this.manuNode != null && this.nextManu != null && this.springToNextManu != null) {
                Ue3_Konrad_markus.this.line(this.manuNode.x, this.manuNode.y, 0.0f, this.nextManu.manuNode.x, this.nextManu.manuNode.y, 0.0f);
            }
        }

        private void attractToNodes() {
            if (this.manuNode != null && this.centerNode != null) {
                this.manuNode.attract(this.centerNode);
                this.centerNode.attract(this.manuNode);
            }
            if (this.manuNode != null && this.nextManu != null) {
                this.manuNode.attract(this.nextManu.manuNode);
                this.nextManu.manuNode.attract(this.manuNode);
            }
        }

        protected void initCarNodePositions() {
            int n = this.carEndNum - this.carStartNum;
            float f = (float)Math.PI * 2 / (float)n;
            float f2 = 0.0f;
            int n2 = this.carStartNum;
            while (n2 < this.carEndNum) {
                Car car = (Car)this.cars.get(n2);
                car.wasSetToVisible = Ue3_Konrad_markus.this.millis();
                car.carNode.x = this.manuNode.x + Ue3_Konrad_markus.cos((float)f2) * 10.0f;
                car.carNode.y = this.manuNode.y + Ue3_Konrad_markus.sin((float)f2) * 10.0f;
                f2 += f;
                ++n2;
            }
        }

        protected void hideCarNodes() {
            int n = 0;
            while (n < this.cars.size()) {
                Car car = (Car)this.cars.get(n);
                car.wasSetToVisible = 0;
                ++n;
            }
        }
    }

    class Origin {
        String name;
        int ringDiameter;
        int ringColor;
        PFont ringFont;
        int textColor;
        ArrayList manus;

        Origin(String string, int n, int n2) {
            this.textColor = Ue3_Konrad_markus.this.color(0, 0, 0, 255);
            Ue3_Konrad_markus.println((String)("> New origin " + string + "(" + n + ")"));
            this.name = string;
            this.ringDiameter = n;
            this.ringColor = n2;
            this.manus = new ArrayList();
        }

        public void update() {
        }

        public void draw() {
            Ue3_Konrad_markus.this.fill(this.ringColor);
            Ue3_Konrad_markus.this.noStroke();
            Ue3_Konrad_markus.this.ellipse(Ue3_Konrad_markus.this.width / 2, Ue3_Konrad_markus.this.height / 2, this.ringDiameter, this.ringDiameter);
            if (this.name != null && this.name.length() > 0) {
                Ue3_Konrad_markus.this.fill(this.textColor);
                if (this.ringDiameter <= 100) {
                    Ue3_Konrad_markus.this.textFont(Ue3_Konrad_markus.this.centerFont, 48.0f);
                    Ue3_Konrad_markus.this.stroke(this.textColor);
                    Ue3_Konrad_markus.this.strokeWeight(4.0f);
                    Ue3_Konrad_markus.this.textAlign(3);
                    Ue3_Konrad_markus.this.text(this.name.toUpperCase(), Ue3_Konrad_markus.this.width / 2, Ue3_Konrad_markus.this.height / 2 + 15);
                } else {
                    Ue3_Konrad_markus.this.textFont(this.ringFont, 18.0f);
                    Ue3_Konrad_markus.this.textAlign(3);
                    Ue3_Konrad_markus.this.text(this.name.toUpperCase(), Ue3_Konrad_markus.this.width / 2 + this.ringDiameter / 2 - 55, Ue3_Konrad_markus.this.height / 2 - 30);
                }
            }
            int n = 0;
            while (n < this.manus.size()) {
                Manufacturer manufacturer = (Manufacturer)this.manus.get(n);
                manufacturer.update();
                manufacturer.draw();
                ++n;
            }
        }
    }
}

