/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import jpen.PLevelEmulator;
import jpen.PenEvent;
import jpen.PenManager;
import jpen.PenScheduler;
import jpen.PenState;
import jpen.event.PenListener;
import jpen.internal.ThreadUtils;
import jpen.internal.ThrowableUtils;

public class Pen
extends PenState {
    private static final Logger L = Logger.getLogger(Pen.class.getName());
    public static final int DEFAULT_FREQUENCY = 60;
    public final PenManager penManager;
    private int frequency;
    private volatile MyThread thread;
    private PenEvent lastDispatchedEvent = new PenEvent.Dummy();
    final PenScheduler scheduler;
    public final PenState lastScheduledState;
    private final List<PenListener> listeners = new ArrayList<PenListener>();
    private PenListener[] listenersArray;
    private boolean firePenTockOnSwing;
    public final PLevelEmulator levelEmulator;

    Pen(PenManager penManager) {
        this.penManager = penManager;
        this.scheduler = new PenScheduler(this);
        this.lastScheduledState = this.scheduler.lastScheduledState;
        this.levelEmulator = new PLevelEmulator(this);
        this.setFrequencyLater(60);
    }

    void processNewEvents() {
        this.thread.processNewEvents();
    }

    PenEvent getLastDispatchedEvent() {
        return this.lastDispatchedEvent;
    }

    public boolean getFirePenTockOnSwing() {
        return this.firePenTockOnSwing;
    }

    public void setFirePenTockOnSwing(boolean firePenTockOnSwing) {
        this.firePenTockOnSwing = firePenTockOnSwing;
    }

    public void setFrequencyLater(int frequency) {
        this.setFrequency(frequency, false);
    }

    private synchronized void setFrequency(int frequency, boolean wait) {
        if (frequency <= 0) {
            throw new IllegalArgumentException();
        }
        if (frequency == this.frequency) {
            return;
        }
        if (wait && SwingUtilities.isEventDispatchThread()) {
            throw new Error("Cannot call setFrequency(int, <true>) from the event dispatcher thread");
        }
        L.finest("v");
        MyThread oldThread = this.thread;
        if (oldThread != null) {
            oldThread.stop(wait);
        }
        this.frequency = frequency;
        this.thread = new MyThread(oldThread);
        this.thread.start();
        L.finest("^");
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getPeriodMillis() {
        return this.thread.periodMillis;
    }

    public synchronized Exception getThreadException() {
        return this.thread.exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PenListener l) {
        List<PenListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
            this.listenersArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PenListener l) {
        List<PenListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
            this.listenersArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PenListener[] getListenersArray() {
        List<PenListener> list = this.listeners;
        synchronized (list) {
            if (this.listenersArray == null) {
                this.listenersArray = this.listeners.toArray(new PenListener[this.listeners.size()]);
            }
            return this.listenersArray;
        }
    }

    private final class MyThread
    extends Thread {
        final int periodMillis;
        long beforeTime;
        long waitTime;
        long availablePeriod;
        PenEvent event;
        boolean waitedNewEvents;
        Exception exception;
        private final Waiter waiter = new Waiter();
        volatile boolean stopRunning;
        Thread oldThread;
        private final Runnable penTockFirer = new Runnable(){

            public void run() {
                for (PenListener l : Pen.this.getListenersArray()) {
                    l.penTock(MyThread.this.availablePeriodLeft());
                }
            }
        };

        MyThread(Thread oldThread) {
            this.periodMillis = 1000 / Pen.this.frequency;
            this.oldThread = oldThread;
            this.setName("jpen-Pen-[" + this.periodMillis + "ms]");
            this.setDaemon(true);
        }

        public void run() {
            try {
                L.finest("v");
                if (this.oldThread != null) {
                    this.oldThread.join();
                }
                this.oldThread = null;
                while (!this.stopRunning) {
                    this.waitedNewEvents = this.waitNewEvents();
                    this.beforeTime = System.currentTimeMillis();
                    if (this.waitedNewEvents) {
                        this.waitTime = 0L;
                    } else {
                        MyThread.yield();
                    }
                    while ((this.event = ((Pen)Pen.this).lastDispatchedEvent.next) != null && this.event.getTime() <= this.beforeTime) {
                        this.event.copyTo(Pen.this);
                        this.event.dispatch();
                        ((Pen)Pen.this).lastDispatchedEvent.next = null;
                        Pen.this.lastDispatchedEvent = this.event;
                    }
                    this.availablePeriod = (long)this.periodMillis + this.waitTime;
                    this.firePenTock();
                    this.waitTime = this.availablePeriodLeft();
                    if (this.waitTime <= 0L) continue;
                    ThreadUtils.sleepUninterrupted(this.waitTime);
                    this.waitTime = 0L;
                }
            }
            catch (Exception ex) {
                L.severe("jpen-Pen thread threw an exception: " + ThrowableUtils.evalStackTraceString(ex));
                this.exception = ex;
            }
            L.finest("^");
        }

        private long evalCurrentProcTime() {
            return System.currentTimeMillis() - this.beforeTime;
        }

        private long availablePeriodLeft() {
            return this.availablePeriod - this.evalCurrentProcTime();
        }

        private boolean waitNewEvents() throws InterruptedException {
            if (((Pen)Pen.this).lastDispatchedEvent.next != null) {
                return false;
            }
            this.waiter.doWait(0L);
            return true;
        }

        private void firePenTock() throws InterruptedException, InvocationTargetException {
            if (Pen.this.getListenersArray().length == 0) {
                return;
            }
            if (Pen.this.firePenTockOnSwing) {
                SwingUtilities.invokeAndWait(this.penTockFirer);
            } else {
                this.penTockFirer.run();
            }
        }

        void processNewEvents() {
            this.waiter.doNotify();
        }

        void stop(boolean join) {
            this.stopRunning = true;
            this.processNewEvents();
            if (join) {
                try {
                    this.join();
                }
                catch (InterruptedException ex) {
                    throw new Error(ex);
                }
            }
        }

        final class Waiter {
            Waiter() {
            }

            synchronized void doWait(long timeout) throws InterruptedException {
                if (!MyThread.this.stopRunning) {
                    this.wait(timeout);
                }
            }

            synchronized void doNotify() {
                this.notify();
            }
        }
    }
}

