/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import jpen.EmulationProvider;
import jpen.PButton;
import jpen.PLevel;
import jpen.PScroll;
import jpen.Pen;
import jpen.PenDevice;
import jpen.PenProvider;
import jpen.PenScheduler;
import jpen.event.PenManagerListener;
import jpen.internal.BuildInfo;
import jpen.owner.PenOwner;
import jpen.owner.awt.AwtPenOwner;
import jpen.provider.system.SystemProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PenManager {
    private static final Logger L = Logger.getLogger(PenManager.class.getName());
    public final Pen pen = new Pen(this);
    public final PenOwner penOwner;
    private final Set<PenProvider.Constructor> providerConstructors = new HashSet<PenProvider.Constructor>();
    private final Set<PenProvider.Constructor> providerConstructorsA = Collections.unmodifiableSet(this.providerConstructors);
    private final Map<Byte, PenDevice> deviceIdToDevice = new HashMap<Byte, PenDevice>(127, 1.0f);
    private final Collection<PenDevice> devicesA = Collections.unmodifiableCollection(this.deviceIdToDevice.values());
    private byte nextDeviceId;
    private volatile boolean paused = true;
    private final List<PenManagerListener> listeners = new ArrayList<PenManagerListener>();
    private PenManagerListener[] listenersArray;
    final PenDevice emulationDevice;
    private PenProvider systemMouseProvider;

    public static String getJPenFullVersion() {
        return BuildInfo.getFullVersion();
    }

    public PenManager(Component component) {
        this(new AwtPenOwner(component));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PenManager(PenOwner penOwner) {
        this.penOwner = penOwner;
        PenScheduler penScheduler = this.pen.scheduler;
        synchronized (penScheduler) {
            EmulationProvider.Constructor emulationProviderConstructor = new EmulationProvider.Constructor();
            this.addProvider(emulationProviderConstructor);
            EmulationProvider emulationProvider = (EmulationProvider)emulationProviderConstructor.getConstructed();
            this.emulationDevice = emulationProvider.device;
            for (PenProvider.Constructor penProviderConstructor : penOwner.getPenProviderConstructors()) {
                this.addProvider(penProviderConstructor);
            }
            penOwner.setPenManagerHandle(new PenOwner.PenManagerHandle(){

                public final PenManager getPenManager() {
                    return PenManager.this;
                }

                public final Object getPenSchedulerLock() {
                    return PenManager.this.pen.scheduler;
                }

                public final void setPenManagerPaused(boolean paused) {
                    PenManager.this.setPaused(paused);
                }
            });
        }
    }

    public PenProvider getSystemMouseProvider() {
        return this.systemMouseProvider;
    }

    public boolean isSystemMouseDevice(PenDevice device) {
        return device.getProvider() == this.systemMouseProvider;
    }

    private PenProvider addProvider(PenProvider.Constructor providerConstructor) {
        if (providerConstructor.constructable(this)) {
            if (!this.providerConstructors.add(providerConstructor)) {
                throw new IllegalArgumentException("constructor already added");
            }
            if (providerConstructor.construct(this)) {
                PenProvider provider = providerConstructor.getConstructed();
                if (provider instanceof SystemProvider) {
                    if (this.systemMouseProvider != null) {
                        this.providerConstructors.remove(providerConstructor);
                        throw new IllegalStateException("system provider already added");
                    }
                    this.systemMouseProvider = provider;
                }
                for (PenDevice device : provider.getDevices()) {
                    this.firePenDeviceAdded(providerConstructor, device);
                }
                return provider;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PenManagerListener l) {
        List<PenManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
            this.listenersArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PenManagerListener l) {
        List<PenManagerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
            this.listenersArray = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PenManagerListener[] getListenersArray() {
        List<PenManagerListener> list = this.listeners;
        synchronized (list) {
            if (this.listenersArray == null) {
                this.listenersArray = this.listeners.toArray(new PenManagerListener[this.listeners.size()]);
            }
            return this.listenersArray;
        }
    }

    public void firePenDeviceAdded(PenProvider.Constructor constructor, PenDevice device) {
        byte nextDeviceId = this.getNextDeviceId();
        device.penManagerSetId(nextDeviceId);
        if (this.deviceIdToDevice.put(nextDeviceId, device) != null) {
            throw new AssertionError();
        }
        for (PenManagerListener l : this.getListenersArray()) {
            l.penDeviceAdded(constructor, device);
        }
    }

    private byte getNextDeviceId() {
        Set<Byte> deviceIds = this.deviceIdToDevice.keySet();
        while (deviceIds.contains(this.nextDeviceId)) {
            this.nextDeviceId = (byte)(this.nextDeviceId + 1);
        }
        if (this.nextDeviceId < 0) {
            throw new IllegalStateException();
        }
        return this.nextDeviceId;
    }

    public void firePenDeviceRemoved(PenProvider.Constructor constructor, PenDevice device) {
        if (this.deviceIdToDevice.remove(device.getId()) == null) {
            throw new IllegalArgumentException("device not found");
        }
        for (PenManagerListener l : this.getListenersArray()) {
            l.penDeviceRemoved(constructor, device);
        }
    }

    public PenDevice getDevice(byte deviceId) {
        return this.deviceIdToDevice.get(deviceId);
    }

    public Collection<PenDevice> getDevices() {
        return this.devicesA;
    }

    public Set<PenProvider.Constructor> getConstructors() {
        return this.providerConstructorsA;
    }

    void setPaused(boolean paused) {
        if (this.paused == paused) {
            return;
        }
        this.pen.scheduler.setPaused(paused);
        this.paused = paused;
        for (PenProvider.Constructor providerConstructor : this.providerConstructors) {
            PenProvider penProvider = providerConstructor.getConstructed();
            if (penProvider == null) continue;
            penProvider.penManagerPaused(paused);
        }
    }

    public boolean getPaused() {
        return this.paused;
    }

    public void scheduleButtonEvent(PenDevice device, long deviceTime, PButton button) {
        if (this.paused) {
            return;
        }
        this.pen.scheduler.scheduleButtonEvent(device, deviceTime, button);
    }

    public void scheduleScrollEvent(PenDevice device, long deviceTime, PScroll scroll) {
        if (this.paused) {
            return;
        }
        this.pen.scheduler.scheduleScrollEvent(device, deviceTime, scroll);
    }

    public boolean scheduleLevelEvent(PenDevice device, long deviceTime, Collection<PLevel> levels) {
        return this.scheduleLevelEvent(device, deviceTime, levels, false);
    }

    public boolean scheduleLevelEvent(PenDevice device, long deviceTime, Collection<PLevel> levels, boolean levelsOnScreen) {
        if (this.paused) {
            return false;
        }
        return this.pen.scheduler.scheduleLevelEvent(device, deviceTime, levels, levelsOnScreen);
    }
}

