/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.PKind;
import jpen.PKindEvent;
import jpen.PLevel;
import jpen.PLevelEvent;
import jpen.PScroll;
import jpen.PScrollEvent;
import jpen.Pen;
import jpen.PenDevice;
import jpen.PenEvent;
import jpen.PenManager;
import jpen.PenState;
import jpen.internal.filter.RelativeLocationFilter;
import jpen.owner.PenOwner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class PenScheduler {
    static final Logger L = Logger.getLogger(PenScheduler.class.getName());
    private final Pen pen;
    private PenEvent lastScheduledEvent;
    public final PenState lastScheduledState = new PenState();
    private final SystemMouseFilter systemMouseFilter;
    private final List<PLevel> scheduledLevels = new ArrayList<PLevel>();
    private volatile boolean firstScheduleAfterPause;
    private final Point clipLocationOnScreen = new Point();
    private final Point2D.Float scheduledLocation = new Point2D.Float();
    private final RelativeLocationFilter relativeLocationFilter = new RelativeLocationFilter();

    PenScheduler(Pen pen) {
        this.pen = pen;
        this.lastScheduledEvent = pen.getLastDispatchedEvent();
        this.systemMouseFilter = new SystemMouseFilter(pen.penManager);
    }

    synchronized void setPaused(boolean paused) {
        if (paused) {
            this.scheduleEmulatedZeroPressureEvent();
            this.scheduleButtonReleasedEvents();
        } else {
            this.firstScheduleAfterPause = true;
            this.relativeLocationFilter.reset();
        }
    }

    private synchronized void scheduleEmulatedZeroPressureEvent() {
        if (this.lastScheduledState.levels.getValue(PLevel.Type.PRESSURE) > 0.0f) {
            this.scheduleLevelEvent(new PLevelEvent(this.getEmulationDevice(), System.currentTimeMillis(), new PLevel[]{new PLevel(PLevel.Type.PRESSURE, 0.0f)}));
        }
    }

    private void scheduleLevelEvent(PLevelEvent levelEvent) {
        this.lastScheduledState.levels.setValues(levelEvent);
        this.schedule(levelEvent);
        this.systemMouseFilter.setLastLevelEvent(levelEvent);
    }

    synchronized boolean scheduleLevelEvent(PenDevice device, long deviceTime, Collection<PLevel> levels, boolean levelsOnScreen) {
        PenOwner penOwner;
        if (device.getProvider().getUseRelativeLocationFilter() && this.relativeLocationFilter.filter(this.lastScheduledState, device, levels, levelsOnScreen)) {
            switch (this.relativeLocationFilter.getState()) {
                case RELATIVE: {
                    device.penManagerSetUseFractionalMovements(false);
                    break;
                }
                case ABSOLUTE: {
                    device.penManagerSetUseFractionalMovements(true);
                    break;
                }
            }
        }
        if (this.getEmulationDevice() != device && this.systemMouseFilter.filterOut(device)) {
            return false;
        }
        if (device.getKindTypeNumber() != PKind.Type.IGNORE.ordinal() && device.getKindTypeNumber() != this.lastScheduledState.getKind().typeNumber) {
            PKind newKind = PKind.valueOf(device.getKindTypeNumber());
            if (L.isLoggable(Level.FINE)) {
                L.fine("changing kind to:" + newKind);
                L.fine("scheduledLevels: " + this.scheduledLevels);
                L.fine("device: " + device);
            }
            this.lastScheduledState.setKind(newKind);
            this.scheduleEmulatedZeroPressureEvent();
            this.schedule(new PKindEvent(device, deviceTime, newKind));
        }
        this.scheduledLevels.clear();
        float scheduledPressure = -1.0f;
        boolean scheduledMovement = false;
        this.scheduledLocation.x = this.lastScheduledState.levels.getValue(PLevel.Type.X);
        this.scheduledLocation.y = this.lastScheduledState.levels.getValue(PLevel.Type.Y);
        PenOwner penOwner2 = penOwner = this.pen.penManager == null ? null : this.pen.penManager.penOwner;
        if (penOwner != null && levelsOnScreen) {
            penOwner.getPenClip().evalLocationOnScreen(this.clipLocationOnScreen);
        }
        for (PLevel level : levels) {
            if (device != this.getEmulationDevice() && this.pen.levelEmulator != null && this.pen.levelEmulator.onActivePolicy(((PKind.Type)((Object)this.lastScheduledState.getKind().getType())).ordinal(), level.typeNumber)) continue;
            if (level.isMovement()) {
                float levelValue = ((Float)level.value).floatValue();
                switch ((PLevel.Type)((Object)level.getType())) {
                    case X: {
                        if (levelsOnScreen) {
                            levelValue -= (float)this.clipLocationOnScreen.x;
                        }
                        this.scheduledLocation.x = levelValue;
                        break;
                    }
                    case Y: {
                        if (levelsOnScreen) {
                            levelValue -= (float)this.clipLocationOnScreen.y;
                        }
                        this.scheduledLocation.y = levelValue;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                level.value = Float.valueOf(levelValue);
                if (!this.firstScheduleAfterPause && ((Float)level.value).floatValue() == this.lastScheduledState.getLevelValue(level.typeNumber)) continue;
                scheduledMovement = true;
            } else {
                if (!this.firstScheduleAfterPause && ((Float)level.value).floatValue() == this.lastScheduledState.getLevelValue(level.typeNumber)) continue;
                switch ((PLevel.Type)((Object)level.getType())) {
                    case PRESSURE: {
                        scheduledPressure = ((Float)level.value).floatValue();
                        break;
                    }
                }
            }
            this.scheduledLevels.add(level);
        }
        if (this.scheduledLevels.isEmpty()) {
            return false;
        }
        if (scheduledMovement && penOwner != null && !penOwner.getPenClip().contains(this.scheduledLocation) && !penOwner.isDraggingOut()) {
            return false;
        }
        this.scheduleOnPressureButtonEvent(scheduledPressure);
        this.scheduleLevelEvent(new PLevelEvent(device, deviceTime, this.scheduledLevels.toArray(new PLevel[this.scheduledLevels.size()])));
        this.firstScheduleAfterPause = false;
        return true;
    }

    private void scheduleOnPressureButtonEvent(float scheduledPressure) {
        if (scheduledPressure == -1.0f) {
            return;
        }
        boolean isOnPressure = this.lastScheduledState.getButtonValue(PButton.Type.ON_PRESSURE);
        if (scheduledPressure > 0.0f) {
            if (isOnPressure) {
                return;
            }
            this.scheduleEmulatedButtonEvent(new PButton(PButton.Type.ON_PRESSURE.ordinal(), true));
        } else if (isOnPressure) {
            this.scheduleEmulatedButtonEvent(new PButton(PButton.Type.ON_PRESSURE.ordinal(), false));
        }
    }

    synchronized void scheduleButtonReleasedEvents() {
        int i = PButton.Type.VALUES.size();
        while (--i >= 0) {
            this.scheduleEmulatedButtonEvent(new PButton(i, false));
        }
        for (Integer extButtonTypeNumber : this.lastScheduledState.extButtonTypeNumberToValue.keySet()) {
            this.scheduleEmulatedButtonEvent(new PButton((int)extButtonTypeNumber, false));
        }
    }

    private void scheduleEmulatedButtonEvent(PButton button) {
        this.scheduleButtonEvent(this.getEmulationDevice(), System.currentTimeMillis(), button);
    }

    private PenDevice getEmulationDevice() {
        return this.pen.penManager.emulationDevice;
    }

    synchronized void scheduleButtonEvent(PenDevice device, long deviceTime, PButton button) {
        if (this.lastScheduledState.setButtonValue(button.typeNumber, (Boolean)button.value)) {
            if (L.isLoggable(Level.FINE)) {
                L.fine("scheduling button event: " + button);
            }
            PButtonEvent buttonEvent = new PButtonEvent(device, deviceTime, button);
            this.schedule(buttonEvent);
            if (this.pen.levelEmulator != null) {
                this.pen.levelEmulator.scheduleEmulatedEvent(buttonEvent);
            }
        }
    }

    synchronized void scheduleScrollEvent(PenDevice device, long deviceTime, PScroll scroll) {
        this.schedule(new PScrollEvent(device, deviceTime, scroll));
    }

    private void schedule(PenEvent ev) {
        ev.time = System.currentTimeMillis();
        this.lastScheduledEvent.next = ev;
        this.lastScheduledEvent = ev;
        this.pen.processNewEvents();
    }

    private static class SystemMouseFilter {
        public static int THRESHOLD_PERIOD = 100;
        private final PenManager penManager;
        private PenDevice lastDevice;
        private PLevelEvent lastLevelEvent;
        boolean filteredFirstInSecuence;
        private long time;
        private long firstInSecuenceTime;

        SystemMouseFilter(PenManager penManager) {
            this.penManager = penManager;
        }

        boolean filterOut(PenDevice device) {
            if (this.penManager.isSystemMouseDevice(device)) {
                this.time = System.currentTimeMillis();
                if (this.lastDevice != null && this.lastDevice != device && this.lastLevelEvent != null && this.time - this.lastLevelEvent.time <= (long)THRESHOLD_PERIOD) {
                    return true;
                }
                if (!this.filteredFirstInSecuence) {
                    L.fine("filtered first in sequence to prioritize digitized input in race");
                    this.filteredFirstInSecuence = true;
                    this.firstInSecuenceTime = System.currentTimeMillis();
                    return true;
                }
                if (this.time - this.firstInSecuenceTime <= (long)THRESHOLD_PERIOD) {
                    L.fine("filtering after the first for a period to allow digitized input to come and win the race");
                    return true;
                }
                L.fine("non digitized input going as event");
            } else {
                this.filteredFirstInSecuence = false;
            }
            this.lastDevice = device;
            return false;
        }

        void setLastLevelEvent(PLevelEvent lastLevelEvent) {
            this.lastLevelEvent = lastLevelEvent;
        }

        PLevelEvent getLastLevelEvent() {
            return this.lastLevelEvent;
        }
    }
}

