/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.util.EnumMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.Pen;
import jpen.demo.DataDisplay;
import jpen.event.PenAdapter;

class ButtonsPanel {
    private final Map<PButton.Type, Display> buttonTypeToDisplay = new EnumMap<PButton.Type, Display>(PButton.Type.class);
    public final Box panel;

    ButtonsPanel(Pen pen) {
        for (PButton.Type buttonType : PButton.Type.VALUES) {
            this.buttonTypeToDisplay.put(buttonType, new Display(buttonType));
        }
        this.panel = Box.createVerticalBox();
        for (PButton.Type buttonType : PButton.Type.VALUES) {
            this.panel.add(this.buttonTypeToDisplay.get((Object)((Object)buttonType)).component);
        }
        pen.addListener(new PenAdapter(){
            private Pen pen;

            public void penButtonEvent(PButtonEvent ev) {
                this.pen = ev.pen;
                PButton.Type buttonType = (PButton.Type)((Object)ev.button.getType());
                Display display = (Display)ButtonsPanel.this.buttonTypeToDisplay.get((Object)buttonType);
                if (display != null) {
                    display.setIsDirty(true);
                }
            }

            public void penTock(long availableMillis) {
                if (this.pen == null) {
                    return;
                }
                for (Display display : ButtonsPanel.this.buttonTypeToDisplay.values()) {
                    display.update(this.pen);
                }
                this.pen = null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Display
    extends DataDisplay<JCheckBox> {
        final PButton.Type buttonType;

        Display(PButton.Type buttonType) {
            super(new JCheckBox(buttonType.toString()));
            this.buttonType = buttonType;
            ((JCheckBox)this.component).setEnabled(false);
        }

        @Override
        void updateImp(Pen pen) {
            ((JCheckBox)this.component).setSelected(pen.getButtonValue(this.buttonType));
        }
    }
}

