/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jpen.PenManager;
import jpen.demo.MainPanel;
import jpen.demo.PenCanvas;
import jpen.demo.StatusReport;
import jpen.demo.StatusReportPanel;
import jpen.demo.inspect.Inspector;

public class JPenDemoControl {
    private static final Logger L = Logger.getLogger(JPenDemoControl.class.getName());
    final PenCanvas penCanvas;
    final MainPanel mainPanel;
    final JButton statusReportButton = new JButton("Status Report...");

    public JPenDemoControl() {
        this.penCanvas = new PenCanvas();
        this.mainPanel = new MainPanel(this.penCanvas);
        this.setSupportCustomPKinds(true);
        this.statusReportButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                StatusReportPanel statusReportPanel = new StatusReportPanel(new StatusReport(JPenDemoControl.this.penCanvas.penManager));
                JOptionPane.showMessageDialog(JPenDemoControl.this.mainPanel.panel, statusReportPanel.panel, "JPen Status Report", 1);
            }
        });
    }

    public void setSupportCustomPKinds(boolean supportCustomPKinds) {
        this.mainPanel.devicesPanel.devicesTableModel.setSupportCustomPKinds(supportCustomPKinds);
    }

    public JComponent getMainPanelComponent() {
        return this.mainPanel.panel;
    }

    public JButton getStatusReportButton() {
        return this.statusReportButton;
    }

    public void showDialog(JComponent parent, String title) {
        String closeOption = "Close";
        Object[] options = new Object[]{this.statusReportButton, closeOption};
        JOptionPane.showOptionDialog(null, this.getMainPanelComponent(), title, -1, -1, null, options, closeOption);
    }

    public static void main(String ... args) throws IOException, NumberFormatException {
        JPenDemoControl.setupLookAndFeel();
        JPenDemoControl jpenDemoControl = new JPenDemoControl();
        JPenDemoControl.startInspector(jpenDemoControl.penCanvas.penManager);
        jpenDemoControl.showDialog(null, "JPen Demo");
        System.exit(0);
    }

    static void setupLookAndFeel() {
        try {
            if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (Exception ex) {
            L.warning("The \"system\" look and feel couldn't be set.");
        }
    }

    static void startInspector(PenManager penManager) throws IOException {
        String inspectorPeriodProperty = System.getProperty("jpen.demo.inspectorPeriod");
        if (inspectorPeriodProperty != null) {
            int inspectorPeriod = Integer.valueOf(inspectorPeriodProperty);
            Inspector inspector = new Inspector(penManager, "jpen", inspectorPeriod);
            L.info("inspector constructed");
        }
    }
}

