/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import jpen.PKind;
import jpen.PenDevice;
import jpen.PenManager;
import jpen.PenProvider;
import jpen.internal.ThrowableUtils;

public class StatusReport {
    private final StringBuilder report = new StringBuilder();
    private static final Set<String> PRIVATE_SYSTEM_PROPERTIES = new HashSet<String>(Arrays.asList("user.dir", "java.io.tmpdir", "line.separator", "user.home", "user.name"));

    public StatusReport(PenManager penManager) {
        this.appendHeader(penManager);
        this.appendPenThreadCrashInfo(penManager);
        this.appendProvidersInfo(penManager);
        this.appendSystemInfo(penManager);
        this.appendFooter(penManager);
    }

    private void appendLine(String line) {
        this.appendLine(line, 0);
    }

    private void appendLine(String line, int indent) {
        line = line.trim();
        int i = indent;
        while (--i >= 0) {
            this.report.append("   ");
        }
        this.report.append(line);
        if (!line.endsWith("\n")) {
            this.report.append("\n");
        }
    }

    private void appendHeader(PenManager penManager) {
        this.appendLine("===== JPen - Status Report =====");
        this.appendLine("JPen Version: " + PenManager.getJPenFullVersion());
        this.appendLine("Date: " + new Date());
    }

    private void appendPenThreadCrashInfo(PenManager penManager) {
        Exception penThreadCrashException = penManager.pen.getThreadException();
        if (penThreadCrashException != null) {
            this.appendLine("Pen Thread Crashed: " + ThrowableUtils.evalStackTraceString(penThreadCrashException));
        }
    }

    private void appendFooter(PenManager penManager) {
        this.appendLine("===== ===== =====");
    }

    private void appendSystemInfo(PenManager penManager) {
        this.appendLine("System Properties:");
        try {
            TreeSet<Object> properties = new TreeSet<Object>(System.getProperties().keySet());
            for (Object property : properties) {
                String propertyName = property.toString();
                if (PRIVATE_SYSTEM_PROPERTIES.contains(propertyName)) continue;
                this.appendLine(propertyName + ": " + System.getProperty(propertyName), 1);
            }
        }
        catch (SecurityException ex) {
            this.appendLine("System Properties are not readable. You can install JPen as a Java Extension to avoid security restrictions.", 1);
        }
    }

    private void appendProvidersInfo(PenManager penManager) {
        this.appendLine("Providers:");
        for (PenProvider.Constructor constructor : penManager.getConstructors()) {
            this.appendLine("Constructor: " + constructor.getName(), 1);
            PenProvider.ConstructionException constructionException = constructor.getConstructionException();
            String constructionExceptionStackTrace = "none";
            if (constructionException != null) {
                constructionExceptionStackTrace = ThrowableUtils.evalStackTraceString(constructionException);
            }
            this.appendLine("Construction Exception: " + constructionExceptionStackTrace, 2);
            PenProvider penProvider = constructor.getConstructed();
            if (penProvider == null) continue;
            int nativeVersion = constructor.getNativeVersion();
            if (nativeVersion != -1) {
                this.appendLine("Native Version-Build(Expected): " + constructor.getNativeVersion() + "-" + constructor.getNativeBuild() + "(" + constructor.getExpectedNativeBuild() + ")", 2);
            }
            Collection<PenDevice> penDevices = penProvider.getDevices();
            for (PenDevice penDevice : penDevices) {
                this.appendLine((penManager.isSystemMouseDevice(penDevice) ? "Device (System Mouse): " : "Device: ") + penDevice.getName() + " (" + penDevice.getPhysicalId() + ")", 2);
                this.appendLine("Enabled: " + penDevice.getEnabled(), 3);
                this.appendLine("Kind: " + PKind.valueOf(penDevice.getKindTypeNumber()), 3);
                this.appendLine("Fractional Movements: " + penDevice.getUseFractionalMovements(), 3);
            }
        }
    }

    public String toString() {
        return this.report.toString();
    }
}

