/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo.inspect;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import jpen.PenManager;
import jpen.demo.inspect.InspectorThread;

public class Inspector {
    static final Logger L = Logger.getLogger(Inspector.class.getName());
    final PenManager penManager;
    final FileHandler fileHandler;
    final InspectorThread inspectorThread;

    public Inspector(PenManager penManager, String loggerName, int periodInSec) throws IOException {
        this.penManager = penManager;
        String fileHandlerName = this.evalFileHandlerName(loggerName);
        this.fileHandler = new FileHandler(fileHandlerName);
        this.fileHandler.setFormatter(new SimpleFormatter());
        this.fileHandler.setLevel(Level.ALL);
        L.info("logging to file:" + fileHandlerName);
        Logger logger = Logger.getLogger(loggerName);
        logger.setLevel(Level.ALL);
        logger.addHandler(this.fileHandler);
        this.inspectorThread = new InspectorThread(this, periodInSec * 1000 / 2, 2L);
    }

    private String evalFileHandlerName(String loggerName) {
        StringBuilder sb = new StringBuilder(loggerName);
        sb.append("-inspect-");
        sb.append(new SimpleDateFormat("yyMMddHHmmss").format(new Date()));
        sb.append(".txt");
        return sb.toString();
    }

    static {
        L.setLevel(Level.ALL);
    }
}

