/*
 * Decompiled with CFR 0.152.
 */
package jpen.internal.filter;

import jpen.internal.filter.RelativeLocationFilter;

class AbsoluteOnARowRule
implements RelativeLocationFilter.Rule {
    static final float THRESHOLD = 7.0f;
    static final int ROW_COUNT_TO_ABSOLUTE = 20;
    private int missedPoints;
    int rowCount;

    AbsoluteOnARowRule() {
    }

    public void reset() {
        this.missedPoints = -1;
        this.rowCount = 0;
    }

    public RelativeLocationFilter.State evalFilterNextState(RelativeLocationFilter filter) {
        ++this.missedPoints;
        if (!filter.samplePoint.isComplete) {
            return null;
        }
        ++this.rowCount;
        if (filter.absDeviation.x > 7.0f || filter.absDeviation.y > 7.0f) {
            this.rowCount = 0;
        }
        if (this.rowCount >= 20) {
            return RelativeLocationFilter.State.ABSOLUTE;
        }
        return null;
    }
}

