/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;

public class Ue1_Konrad_markus
extends PApplet {
    final int APP_STATE_START = 1;
    final int APP_STATE_TEST = 2;
    final int APP_STATE_RESULTS = 3;
    final int APP_STATE_RESULTS_ALL = 4;
    final int SHAPE_TYPE_CIRCLE = 1;
    final int SHAPE_TYPE_RECT = 2;
    final int SCREEN_W = 800;
    final int SCREEN_H = 600;
    final boolean DEBUG_VIS = false;
    int appState;
    int shapeType;
    PFont fontHeader;
    AppStart appStart;
    AppTest appTest;
    AppResults appResults;
    ArrayList results = new ArrayList();

    public void setup() {
        this.appState = 1;
        this.shapeType = 1;
        this.smooth();
        this.size(800, 600);
        this.stroke(255);
        this.background(0.0f, 0.0f, 0.0f);
        this.fontHeader = this.loadFont("SansSerif-28.vlw");
        this.appStart = new AppStart();
        this.appTest = new AppTest();
        this.appResults = new AppResults();
        int n = 0;
        while (n < this.appTest.testMax) {
            Result result = new Result();
            result.testNum = n++;
            this.results.add(result);
        }
    }

    public void draw() {
        this.background(0.0f, 0.0f, 0.0f);
        this.showHeader();
        this.updateMain();
        this.showMain();
        this.showFooter();
    }

    public void showHeader() {
        this.fill(255);
        String string = "";
        switch (this.appState) {
            case 1: {
                string = "W\u00e4hle eine Form";
                break;
            }
            case 2: {
                string = "Testphase";
                break;
            }
            case 3: {
                string = "Individuelle Resultate";
                break;
            }
            case 4: {
                string = "Resulte vergangener Kandidaten";
            }
        }
        this.textFont(this.fontHeader, 28.0f);
        this.textAlign(37);
        this.text(string, 20.0f, 50.0f);
    }

    public void updateMain() {
        switch (this.appState) {
            case 1: {
                this.appStart.update();
                break;
            }
            case 2: {
                this.appTest.update();
                break;
            }
            case 3: 
            case 4: {
                this.appResults.update();
            }
        }
    }

    public void showMain() {
        switch (this.appState) {
            case 1: {
                this.appStart.display();
                break;
            }
            case 2: {
                this.appTest.display();
                break;
            }
            case 3: 
            case 4: {
                this.appResults.display();
            }
        }
    }

    public void showFooter() {
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "Ue1_Konrad_markus"});
    }

    class AppResults {
        boolean firstCall = true;
        float avgValue = 0.0f;
        float avgDeviation = 0.0f;
        float avgLinDeviation = 0.0f;
        float[] deviationData = null;
        float deviationDataMin = Float.MAX_VALUE;
        float deviationDataMax = Float.MIN_VALUE;
        float[] linDeviationData = null;
        float linDeviationDataMin = Float.MAX_VALUE;
        float linDeviationDataMax = Float.MIN_VALUE;
        PFont fontHeaderText;
        PFont fontVisValues;
        TextButton prevButton;

        AppResults() {
            this.fontHeaderText = Ue1_Konrad_markus.this.loadFont("SansSerif-20.vlw");
            this.fontVisValues = Ue1_Konrad_markus.this.loadFont("SansSerif-9.vlw");
            this.prevButton = new TextButton(370, 550, 60, 20, "OK", Ue1_Konrad_markus.this.color(180), Ue1_Konrad_markus.this.color(220), true);
        }

        public void display() {
            Ue1_Konrad_markus.this.textFont(this.fontHeaderText, 20.0f);
            Ue1_Konrad_markus.this.textAlign(37);
            Ue1_Konrad_markus.this.fill(200);
            Ue1_Konrad_markus.this.text("Logarithmische Abweichung x = log A' / log A", 50.0f, 100.0f);
            this.displayVisualizationData(this.deviationData, 50, 300, 600, 300, Ue1_Konrad_markus.max((float)Ue1_Konrad_markus.abs((float)this.deviationDataMax), (float)Ue1_Konrad_markus.abs((float)this.deviationDataMin)), 1.0f);
            this.displayMinAvgMax(680, 305, this.deviationDataMin, this.avgValue, this.avgDeviation, this.deviationDataMax);
            this.prevButton.display();
        }

        public void displayVisualizationData(float[] fArray, int n, int n2, int n3, int n4, float f, float f2) {
            int n5;
            float f3;
            if (fArray == null) {
                return;
            }
            Ue1_Konrad_markus.this.stroke(100);
            int n6 = 5;
            int n7 = n3 / fArray.length - 2 * n6;
            float f4 = 0.9f * (float)n4 / f;
            float f5 = (float)((int)(8.0f / (float)Ue1_Konrad_markus.ceil((float)f) * 100.0f)) / 100.0f;
            if (f5 < 0.25f) {
                f5 = 0.1f;
            } else if (f5 < 0.5f) {
                f5 = 0.25f;
            } else if (f5 < 1.0f) {
                f5 = 0.5f;
            } else if (f5 > 4.0f) {
                f5 = 4.0f;
            }
            Ue1_Konrad_markus.println((String)("dataMaximum: " + f));
            Ue1_Konrad_markus.println((String)("scaleSteps: " + f5));
            Ue1_Konrad_markus.this.color(255);
            Ue1_Konrad_markus.this.fill(50);
            Ue1_Konrad_markus.this.rectMode(0);
            Ue1_Konrad_markus.this.stroke(180);
            Ue1_Konrad_markus.this.rect(n, (float)n2 - (float)n4 * 0.5f, n3, n4);
            int n8 = n2 - (int)((this.avgValue - 1.0f) * f4);
            Ue1_Konrad_markus.this.noStroke();
            int n9 = (int)(this.avgDeviation * f4);
            Ue1_Konrad_markus.this.rectMode(0);
            Ue1_Konrad_markus.this.fill(80);
            Ue1_Konrad_markus.this.rect(n + 1, n2 - n9, n3 - 1, n9 * 2);
            Ue1_Konrad_markus.this.stroke(200.0f, 200.0f, 0.0f);
            Ue1_Konrad_markus.this.line(n, n8, n + n3, n8);
            Ue1_Konrad_markus.this.stroke(180);
            int n10 = (int)((float)Ue1_Konrad_markus.ceil((float)(f / 2.0f)) * f5);
            Ue1_Konrad_markus.println((String)("lineMax: " + n10));
            float f6 = -n10;
            while (f6 <= (float)n10) {
                f3 = f6 / f5;
                n5 = n2 + (int)(f3 * f4);
                if (!((float)n5 <= (float)n2 - (float)n4 * 0.5f) && !((float)n5 >= (float)n2 + (float)n4 * 0.5f)) {
                    Ue1_Konrad_markus.this.line(n, n5, n + n3, n5);
                    Ue1_Konrad_markus.this.fill(200);
                    Ue1_Konrad_markus.this.textFont(this.fontVisValues, 9.0f);
                    Ue1_Konrad_markus.this.textAlign(39);
                    Ue1_Konrad_markus.this.text(this.formatValue2(-f3 + f2), n - 5, n5 + 5);
                }
                f6 += 1.0f;
            }
            Ue1_Konrad_markus.this.fill(200);
            Ue1_Konrad_markus.this.textFont(this.fontVisValues, 9.0f);
            Ue1_Konrad_markus.this.textAlign(37);
            Ue1_Konrad_markus.this.text("Versuch", n + n3 + 10, n2 - n4 / 2 - 5);
            Ue1_Konrad_markus.this.fill(200);
            Ue1_Konrad_markus.this.textFont(this.fontVisValues, 9.0f);
            Ue1_Konrad_markus.this.textAlign(37);
            Ue1_Konrad_markus.this.text("Versuchserg. x", n + n3 + 10, n2 + n4 / 2 + 17);
            int n11 = 0;
            f3 = Ue1_Konrad_markus.max((float)(this.deviationDataMax - f2), (float)(f2 - this.deviationDataMin));
            n5 = 0;
            while (n5 < fArray.length) {
                float f7 = fArray[n5];
                float f8 = f7 >= 0.0f ? f7 / f3 : -f7 / f3;
                Ue1_Konrad_markus.this.fill(200.0f * f8, 200.0f * (1.0f - f8), 0.0f);
                Ue1_Konrad_markus.this.rectMode(0);
                Ue1_Konrad_markus.this.rect(n + n11 + n6, n2, n7, -f7 * f4);
                Ue1_Konrad_markus.this.fill(200);
                Ue1_Konrad_markus.this.textFont(this.fontVisValues, 9.0f);
                Ue1_Konrad_markus.this.textAlign(3);
                Ue1_Konrad_markus.this.text(n5 + 1, n + n11 + n6 + n7 / 2, n2 - n4 / 2 - 5);
                Ue1_Konrad_markus.this.text(this.formatValue2(f7 + f2), n + n11 + n6 + n7 / 2, n2 + n4 / 2 + 17);
                n11 += n7 + 2 * n6;
                ++n5;
            }
        }

        public void displayMinAvgMax(int n, int n2, float f, float f2, float f3, float f4) {
            Ue1_Konrad_markus.this.fill(200);
            Ue1_Konrad_markus.this.textFont(this.fontHeaderText, 20.0f);
            Ue1_Konrad_markus.this.textAlign(37);
            Ue1_Konrad_markus.this.fill(200.0f, 0.0f, 0.0f);
            Ue1_Konrad_markus.this.text("Max.: " + this.roundByValue(f4, 100.0f), n, n2 - 30);
            Ue1_Konrad_markus.this.fill(200.0f, 200.0f, 0.0f);
            Ue1_Konrad_markus.this.text("Mittel: " + this.roundByValue(f2, 100.0f), n, n2);
            Ue1_Konrad_markus.this.fill(80);
            Ue1_Konrad_markus.this.text("Sigma: " + this.roundByValue(f3, 100.0f), n, n2 + 30);
            Ue1_Konrad_markus.this.fill(200.0f, 0.0f, 0.0f);
            Ue1_Konrad_markus.this.text("Min.: " + this.roundByValue(f, 100.0f), n, n2 + 60);
        }

        public void update() {
            if (this.firstCall) {
                this.buildVisualizationData();
                this.firstCall = false;
            }
            this.prevButton.update();
            if (this.prevButton.pressed()) {
                Ue1_Konrad_markus.this.appState = 1;
            }
        }

        public void buildVisualizationData() {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            this.deviationData = new float[Ue1_Konrad_markus.this.results.size()];
            this.linDeviationData = new float[Ue1_Konrad_markus.this.results.size()];
            int n = 0;
            while (n < Ue1_Konrad_markus.this.results.size()) {
                Result result = (Result)Ue1_Konrad_markus.this.results.get(n);
                this.deviationData[n] = result.userDeviation - 1.0f;
                this.linDeviationData[n] = result.userLinDeviation;
                f += (result.userDeviation - 1.0f) * (result.userDeviation - 1.0f);
                f2 += result.userDeviation;
                f3 += result.userLinDeviation;
                if (result.userDeviation > this.deviationDataMax) {
                    this.deviationDataMax = result.userDeviation;
                }
                if (result.userDeviation < this.deviationDataMin) {
                    this.deviationDataMin = result.userDeviation;
                }
                if (result.userLinDeviation > this.linDeviationDataMax) {
                    this.linDeviationDataMax = result.userLinDeviation;
                }
                if (result.userLinDeviation < this.linDeviationDataMin) {
                    this.linDeviationDataMin = result.userLinDeviation;
                }
                ++n;
            }
            this.avgValue = f2 / (float)Ue1_Konrad_markus.this.results.size();
            this.avgDeviation = Ue1_Konrad_markus.sqrt((float)(f / (float)Ue1_Konrad_markus.this.results.size()));
            this.avgLinDeviation = f3 / (float)Ue1_Konrad_markus.this.results.size();
        }

        public float roundByValue(float f, float f2) {
            return (float)Ue1_Konrad_markus.round((float)(f * f2)) / f2;
        }

        public String formatValue1(float f) {
            DecimalFormat decimalFormat = new DecimalFormat("0.0");
            return decimalFormat.format(f);
        }

        public String formatValue2(float f) {
            DecimalFormat decimalFormat = new DecimalFormat("0.0#");
            return decimalFormat.format(f);
        }
    }

    class AppStart {
        CircleButton circleButton;
        RectButton rectButton;

        AppStart() {
            int n = 100;
            this.circleButton = new CircleButton(400 - n, 300, n, Ue1_Konrad_markus.this.color(180, 0, 0), Ue1_Konrad_markus.this.color(220, 0, 0), true);
            this.rectButton = new RectButton(400 + n, 300, n, Ue1_Konrad_markus.this.color(180, 0, 0), Ue1_Konrad_markus.this.color(220, 0, 0), true);
        }

        public void display() {
            this.circleButton.display();
            this.rectButton.display();
        }

        public void update() {
            this.circleButton.update();
            this.rectButton.update();
            if (this.circleButton.pressed()) {
                Ue1_Konrad_markus.this.appState = 2;
                Ue1_Konrad_markus.this.shapeType = 1;
            }
            if (this.rectButton.pressed()) {
                Ue1_Konrad_markus.this.appState = 2;
                Ue1_Konrad_markus.this.shapeType = 2;
            }
        }
    }

    class AppTest {
        int testNum = 0;
        int testMax = 20;
        int testType;
        PFont fontHeaderText;
        float[] shapeTestSizes = new float[]{0.25f, 0.33f, 0.5f, 0.75f, 1.5f, 2.0f, 2.5f, 3.0f, 4.0f, 5.0f};
        int baseShapeSize;
        float baseShapeArea;
        float origShapeAreaRatio;
        float origShapeArea;
        int origShapeSize;
        float expectedAreaRatio;
        float userShapeArea;
        int userShapeSize;
        int selectedRatioIndex = -1;
        int expAreaSize = 300;
        int leftAreaCenterX = 400 - (this.expAreaSize / 2 + 10);
        int rightAreaCenterX = 400 + (this.expAreaSize / 2 + 10);
        int areaCenterY = 280;
        RectButton areaLeft;
        RectButton areaRight;
        TriangleButton nextButton;
        ArrayList answerSelection;

        AppTest() {
            this.fontHeaderText = Ue1_Konrad_markus.this.loadFont("SansSerif-20.vlw");
            this.baseShapeSize = 50;
            this.baseShapeArea = this.calcArea(this.baseShapeSize);
            this.userShapeSize = 0;
            this.areaLeft = new RectButton(this.leftAreaCenterX, this.areaCenterY, this.expAreaSize, Ue1_Konrad_markus.this.color(40), Ue1_Konrad_markus.this.color(40), false);
            this.areaRight = new RectButton(this.rightAreaCenterX, this.areaCenterY, this.expAreaSize, Ue1_Konrad_markus.this.color(40), Ue1_Konrad_markus.this.color(40), false);
            this.nextButton = new TriangleButton(690, 550, 20, 30, 270.0f, Ue1_Konrad_markus.this.color(180), Ue1_Konrad_markus.this.color(220), true);
            this.answerSelection = new ArrayList();
            int n = 0;
            while (n < this.shapeTestSizes.length) {
                String string = this.generateStringFromRatio(this.shapeTestSizes[n]);
                int n2 = n % (this.shapeTestSizes.length / 2);
                int n3 = n / (this.shapeTestSizes.length / 2);
                TextButton textButton = new TextButton(150 + n2 * 125, 500 + n3 * 35, 120, 30, string, Ue1_Konrad_markus.this.color(180), Ue1_Konrad_markus.this.color(220), true);
                this.answerSelection.add(textButton);
                ++n;
            }
            this.initValues();
        }

        public void display() {
            Ue1_Konrad_markus.this.fill(200);
            Ue1_Konrad_markus.this.textAlign(37);
            Ue1_Konrad_markus.this.textFont(this.fontHeaderText, 20.0f);
            Ue1_Konrad_markus.this.text("Test #" + (this.testNum + 1) + "/" + this.testMax + ":", 20.0f, 80.0f);
            this.displayShapeTest();
            this.displayFooter();
        }

        public void displayFooter() {
            if (this.testType == 0 && this.userShapeSize > 0) {
                this.nextButton.display();
            }
        }

        public void update() {
            if (this.testNum >= this.testMax) {
                Ue1_Konrad_markus.this.appState = 3;
                this.testNum = 0;
                this.initValues();
                return;
            }
            this.updateShapeTest();
            this.updateFooter();
        }

        public void updateFooter() {
            if (this.testType == 0 && this.userShapeSize > 0) {
                this.nextButton.update();
                if (this.nextButton.pressed()) {
                    this.saveResults();
                    ++this.testNum;
                }
            }
        }

        public void saveResults() {
            Result result = (Result)Ue1_Konrad_markus.this.results.get(this.testNum);
            result.expectedRatio = this.expectedAreaRatio;
            result.testType = this.testType;
            result.origShapeArea = this.origShapeArea;
            if (this.testType == 0) {
                result.userShapeArea = this.calcArea(this.userShapeSize);
                result.userRatio = result.userShapeArea / result.origShapeArea;
            } else {
                result.userShapeArea = result.origShapeArea * this.shapeTestSizes[this.selectedRatioIndex];
                result.userRatio = this.shapeTestSizes[this.selectedRatioIndex];
            }
            result.userDeviation = this.logAB(result.origShapeArea * result.expectedRatio, result.userShapeArea);
            float f = result.origShapeArea * result.expectedRatio;
            result.userLinDeviation = f <= result.userShapeArea ? result.userShapeArea / f : -f / result.userShapeArea;
            this.initValues();
        }

        public void initValues() {
            this.selectedRatioIndex = -1;
            this.userShapeSize = 0;
            this.testType = (this.testNum + 1) / this.shapeTestSizes.length;
            int n = (int)Ue1_Konrad_markus.this.random(this.shapeTestSizes.length);
            this.origShapeAreaRatio = this.shapeTestSizes[n];
            this.origShapeArea = this.baseShapeArea * this.origShapeAreaRatio;
            this.origShapeSize = (int)this.calcWidthFromArea(this.origShapeArea);
            int n2 = 0;
            int n3 = this.shapeTestSizes.length;
            if (n < 3) {
                n2 = 3;
            } else if (n > 6) {
                n3 = 6;
            }
            this.expectedAreaRatio = this.shapeTestSizes[(int)Ue1_Konrad_markus.this.random(n2, n3)];
            if (this.testType == 1) {
                this.userShapeArea = this.origShapeArea * this.expectedAreaRatio;
                this.userShapeSize = (int)this.calcWidthFromArea(this.userShapeArea);
            }
        }

        public void displayShapeTest() {
            Ue1_Konrad_markus.this.fill(200);
            Ue1_Konrad_markus.this.textFont(this.fontHeaderText, 20.0f);
            Ue1_Konrad_markus.this.textAlign(3);
            if (this.testType == 0) {
                Ue1_Konrad_markus.this.text("Mache die Form auf der rechten Seite " + this.generateStringFromRatio(this.expectedAreaRatio) + " wie die auf der linken.", 400.0f, 110.0f);
            } else {
                Ue1_Konrad_markus.this.text("W\u00e4hle die richtige Antwort f\u00fcr die rechte Seite aus.", 400.0f, 110.0f);
                Ue1_Konrad_markus.this.text("Die Form auf der rechten Seite ist...", 400.0f, 460.0f);
            }
            this.areaLeft.display();
            this.areaRight.display();
            if (this.testType == 1) {
                int n = 0;
                while (n < this.answerSelection.size()) {
                    TextButton textButton = (TextButton)this.answerSelection.get(n);
                    textButton.display();
                    ++n;
                }
            }
            Ue1_Konrad_markus.this.fill(180.0f, 0.0f, 0.0f);
            if (Ue1_Konrad_markus.this.shapeType == 1) {
                Ue1_Konrad_markus.this.ellipse(this.leftAreaCenterX, this.areaCenterY, this.origShapeSize, this.origShapeSize);
            } else {
                Ue1_Konrad_markus.this.rect(this.leftAreaCenterX, this.areaCenterY, this.origShapeSize, this.origShapeSize);
            }
            Ue1_Konrad_markus.this.fill(180.0f, 0.0f, 0.0f);
            if (Ue1_Konrad_markus.this.shapeType == 1) {
                Ue1_Konrad_markus.this.ellipse(this.rightAreaCenterX, this.areaCenterY, this.userShapeSize, this.userShapeSize);
            } else {
                Ue1_Konrad_markus.this.rect(this.rightAreaCenterX, this.areaCenterY, this.userShapeSize, this.userShapeSize);
            }
        }

        public void updateShapeTest() {
            block3: {
                block2: {
                    if (this.testType != 0) break block2;
                    this.areaRight.update();
                    if (!this.areaRight.pressed()) break block3;
                    this.userShapeSize = (int)Ue1_Konrad_markus.dist((float)Ue1_Konrad_markus.this.mouseX, (float)Ue1_Konrad_markus.this.mouseY, (float)this.rightAreaCenterX, (float)this.areaCenterY) * 2;
                    if (this.userShapeSize <= this.expAreaSize - 5) break block3;
                    this.userShapeSize = this.expAreaSize - 5;
                    break block3;
                }
                int n = 0;
                while (n < this.answerSelection.size()) {
                    TextButton textButton = (TextButton)this.answerSelection.get(n);
                    textButton.update();
                    if (textButton.pressed()) {
                        this.selectedRatioIndex = n;
                        this.saveResults();
                        ++this.testNum;
                        return;
                    }
                    ++n;
                }
            }
        }

        public float calcArea(float f) {
            if (Ue1_Konrad_markus.this.shapeType == 2) {
                return f * f;
            }
            return 0.7853982f * f * f;
        }

        public float calcWidthFromArea(float f) {
            if (Ue1_Konrad_markus.this.shapeType == 2) {
                return Ue1_Konrad_markus.sqrt((float)f);
            }
            return Ue1_Konrad_markus.sqrt((float)(f / (float)Math.PI)) * 2.0f;
        }

        public String generateStringFromRatio(float f) {
            String string = String.valueOf(f) + " mal gr\u00f6\u00dfer";
            if (f == 0.25f) {
                string = "4 mal kleiner";
            }
            if (f == 0.33f) {
                string = "3 mal kleiner";
            }
            if (f == 0.5f) {
                string = "halb so gro\u00df";
            }
            if (f == 0.75f) {
                string = "3/4 so gro\u00df";
            }
            return string;
        }

        public float logAB(float f, float f2) {
            return Ue1_Konrad_markus.log((float)f2) / Ue1_Konrad_markus.log((float)f);
        }
    }

    class Button {
        int x;
        int y;
        int sizeW;
        int sizeH;
        int basecolor;
        int highlightcolor;
        int currentcolor;
        boolean over = false;
        boolean pressed = false;
        int lastClick = 0;
        int clickLockTime = 0;

        Button() {
        }

        public void update() {
            this.currentcolor = this.over() ? this.highlightcolor : this.basecolor;
        }

        public boolean pressed() {
            if (this.clickLockTime > 0) {
                boolean bl;
                boolean bl2 = bl = Ue1_Konrad_markus.this.millis() - this.lastClick > this.clickLockTime && Ue1_Konrad_markus.this.mousePressed && this.over;
                if (bl) {
                    this.lastClick = Ue1_Konrad_markus.this.millis();
                }
                return bl;
            }
            return Ue1_Konrad_markus.this.mousePressed && this.over;
        }

        public boolean over() {
            return true;
        }

        public boolean overRect(int n, int n2, int n3, int n4) {
            return Ue1_Konrad_markus.this.mouseX >= n && Ue1_Konrad_markus.this.mouseX <= n + n3 && Ue1_Konrad_markus.this.mouseY >= n2 && Ue1_Konrad_markus.this.mouseY <= n2 + n4;
        }

        public boolean overCircle(int n, int n2, int n3) {
            float f = n - Ue1_Konrad_markus.this.mouseX;
            float f2 = n2 - Ue1_Konrad_markus.this.mouseY;
            return Ue1_Konrad_markus.sqrt((float)(Ue1_Konrad_markus.sq((float)f) + Ue1_Konrad_markus.sq((float)f2))) < (float)(n3 / 2);
        }
    }

    class CircleButton
    extends Button {
        CircleButton(int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n3;
            this.basecolor = n4;
            this.highlightcolor = n5;
            this.currentcolor = this.basecolor;
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overCircle(this.x, this.y, this.sizeW)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue1_Konrad_markus.this.stroke(255);
            Ue1_Konrad_markus.this.fill(this.currentcolor);
            Ue1_Konrad_markus.this.ellipse(this.x, this.y, this.sizeW, this.sizeW);
        }
    }

    class RectButton
    extends Button {
        RectButton(int n, int n2, int n3, int n4, int n5, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n3;
            this.basecolor = n4;
            this.highlightcolor = n5;
            this.currentcolor = this.basecolor;
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overRect(this.x - this.sizeW / 2, this.y - this.sizeW / 2, this.sizeW, this.sizeW)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue1_Konrad_markus.this.stroke(255);
            Ue1_Konrad_markus.this.fill(this.currentcolor);
            Ue1_Konrad_markus.this.rectMode(3);
            Ue1_Konrad_markus.this.rect(this.x, this.y, this.sizeW, this.sizeW);
        }
    }

    class Result {
        int testNum = 0;
        int testType = 0;
        float expectedRatio = 0.0f;
        float origShapeArea = 0.0f;
        float userRatio = 0.0f;
        float userShapeArea = 0.0f;
        float userDeviation = 0.0f;
        float userLinDeviation = 0.0f;

        Result() {
        }

        public String toString() {
            return "Result for Test#" + this.testNum + ":\n" + " testType: " + this.testType + "\n" + " expectedRatio: " + this.expectedRatio + "\n" + " origShapeArea: " + this.origShapeArea + "\n" + " userRatio: " + this.userRatio + "\n" + " userShapeArea: " + this.userShapeArea + "\n" + " userDeviation: " + this.userDeviation + "\n" + " userLinDeviation: " + this.userLinDeviation;
        }
    }

    class TextButton
    extends Button {
        PFont labelFont;
        String label;

        TextButton(int n, int n2, int n3, int n4, String string, int n5, int n6, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n4;
            this.label = string;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.labelFont = Ue1_Konrad_markus.this.loadFont("SansSerif-14.vlw");
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overRect(this.x - this.sizeW / 2, this.y - this.sizeH / 2, this.sizeW, this.sizeH)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue1_Konrad_markus.this.stroke(255);
            Ue1_Konrad_markus.this.fill(this.currentcolor);
            Ue1_Konrad_markus.this.rectMode(3);
            Ue1_Konrad_markus.this.rect(this.x, this.y, this.sizeW, this.sizeH);
            Ue1_Konrad_markus.this.fill(255);
            Ue1_Konrad_markus.this.textFont(this.labelFont, 14.0f);
            Ue1_Konrad_markus.this.textAlign(3);
            Ue1_Konrad_markus.this.text(this.label, this.x, this.y + 5);
        }
    }

    class TriangleButton
    extends Button {
        float angle;

        TriangleButton(int n, int n2, int n3, int n4, float f, int n5, int n6, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n4;
            this.angle = Ue1_Konrad_markus.radians((float)f);
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overRect(this.x - this.sizeW / 2, this.y - this.sizeH / 2, this.sizeW, this.sizeH)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue1_Konrad_markus.this.pushMatrix();
            Ue1_Konrad_markus.this.stroke(255);
            Ue1_Konrad_markus.this.fill(this.currentcolor);
            Ue1_Konrad_markus.this.translate(this.x, this.y);
            Ue1_Konrad_markus.this.rotate(this.angle);
            Ue1_Konrad_markus.this.triangle(-this.sizeW / 2, -this.sizeH / 2, (float)this.sizeW / 2.5f, -this.sizeH / 2, 0.0f, this.sizeH / 2);
            Ue1_Konrad_markus.this.popMatrix();
        }
    }
}

