/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;

public class Ue2_Konrad_markus
extends PApplet {
    final int APP_STATE_START = 0;
    final int APP_STATE_TEST_0 = 1;
    final int APP_STATE_TEST_1 = 2;
    final int APP_STATE_TEST_2 = 3;
    final int APP_STATE_TEST_3 = 4;
    final int APP_STATE_TEST_4 = 5;
    final int APP_STATE_TEST_5 = 6;
    final int APP_STATE_TEST_6 = 7;
    final int APP_STATE_TEST_7 = 8;
    final int APP_STATE_TEST_8 = 9;
    final int APP_STATE_TEST_9 = 10;
    final int APP_STATE_RESULTS = 11;
    final int SCREEN_W = 800;
    final int SCREEN_H = 600;
    final boolean DEBUG_VIS = false;
    int appState;
    PFont fontHeader;
    AppTest appTest;
    AppResults appResults;
    ArrayList results = new ArrayList();
    ArrayList testTitles = new ArrayList();

    public void setup() {
        this.appState = 1;
        if (this.appState == 0) {
            this.appState = 1;
        }
        this.smooth();
        this.size(800, 600);
        this.stroke(255);
        this.background(0.0f, 0.0f, 0.0f);
        this.fontHeader = this.loadFont("SansSerif-28.vlw");
        this.appTest = new AppTest();
        this.appResults = new AppResults();
        int n = 0;
        while (n < this.appTest.testMax) {
            Result result = new Result();
            result.testNum = n++;
            this.results.add(result);
        }
        this.testTitles.add("Einfacher Reaktionst.");
        this.testTitles.add("Farbe");
        this.testTitles.add("Form");
        this.testTitles.add("Gr\u00f6\u00dfe");
        this.testTitles.add("Distr.vielfalt I");
        this.testTitles.add("Distr.vielfalt II");
        this.testTitles.add("Distr.vielfalt III");
        this.testTitles.add("Zusammenges. Eig. I");
        this.testTitles.add("Zusammenges. Eig. II");
        this.testTitles.add("Zusammenges. Eig. III");
    }

    public void draw() {
        this.background(0.0f, 0.0f, 0.0f);
        this.showHeader();
        this.updateMain();
        this.showMain();
        this.showFooter();
    }

    public void showHeader() {
        this.fill(255);
        String string = "";
        switch (this.appState) {
            default: {
                string = (String)this.testTitles.get(this.appState - 1);
                break;
            }
            case 11: {
                string = "Individuelle Resultate";
            }
        }
        this.textFont(this.fontHeader, 28.0f);
        this.textAlign(37);
        this.text(string, 20.0f, 50.0f);
    }

    public void updateMain() {
        if (this.appState != 11) {
            this.appTest.update();
        } else {
            this.appResults.update();
        }
    }

    public void showMain() {
        if (this.appState != 11) {
            this.appTest.display();
        } else {
            this.appResults.display();
        }
    }

    public void showFooter() {
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#FFFFFF", "Ue2_Konrad_markus"});
    }

    class AppResults {
        boolean firstCall = true;
        int testTypeCount = 10;
        int testsPerType = 5;
        ArrayList resultData;
        ArrayList resultDataMax;
        ArrayList resultDataMin;
        ArrayList resultDataAvg;
        float absResultDataMax = Float.MIN_VALUE;
        float avgReactionTime = 0.0f;
        PFont fontHeaderText;
        PFont fontVisValues;
        TextButton prevButton;

        AppResults() {
            this.fontHeaderText = Ue2_Konrad_markus.this.loadFont("SansSerif-12.vlw");
            this.fontVisValues = Ue2_Konrad_markus.this.loadFont("SansSerif-9.vlw");
            this.prevButton = new TextButton(370, 570, 60, 20, "OK", Ue2_Konrad_markus.this.color(180), Ue2_Konrad_markus.this.color(220), true);
        }

        public void display() {
            int n = 125;
            int n2 = 100;
            int n3 = 25;
            int n4 = 100;
            Ue2_Konrad_markus.this.textFont(this.fontHeaderText, 12.0f);
            Ue2_Konrad_markus.this.textAlign(37);
            Ue2_Konrad_markus.this.fill(200);
            Ue2_Konrad_markus.this.text("Bei allen Tests nach dem einfachen Reaktionstest wurde die durchschn. Reaktionsgeschw. von " + Ue2_Konrad_markus.nf((float)this.avgReactionTime, (int)1, (int)2) + "Sek. abgezogen", 25.0f, 100.0f);
            Ue2_Konrad_markus.this.text("Alle Angaben sind in Sekunden.", 25.0f, 113.0f);
            int n5 = 0;
            while (n5 < this.testTypeCount) {
                int n6 = n5 / this.testsPerType;
                int n7 = n5 % this.testsPerType;
                int n8 = n3 + n7 * (n + n3);
                int n9 = 140 + n6 * (n2 + n4);
                Ue2_Konrad_markus.this.textFont(this.fontHeaderText, 12.0f);
                Ue2_Konrad_markus.this.textAlign(37);
                Ue2_Konrad_markus.this.fill(200);
                Ue2_Konrad_markus.this.text((String)Ue2_Konrad_markus.this.testTitles.get(n5), n8, n9);
                this.displayVisualizationData(n5, n8, n9 + n2 / 2 + 25, n, n2);
                ++n5;
            }
            this.prevButton.display();
        }

        public void displayVisualizationData(int n, int n2, int n3, int n4, int n5) {
            if (this.resultData == null) {
                return;
            }
            ArrayList arrayList = (ArrayList)this.resultData.get(n);
            float f = ((Float)this.resultDataMax.get(n)).floatValue();
            float f2 = ((Float)this.resultDataMin.get(n)).floatValue();
            float f3 = ((Float)this.resultDataAvg.get(n)).floatValue();
            Ue2_Konrad_markus.this.stroke(100);
            int n6 = 2;
            int n7 = n4 / arrayList.size() - 2 * n6;
            float f4 = 0.9f * (float)n5 / this.absResultDataMax;
            Ue2_Konrad_markus.this.color(255);
            Ue2_Konrad_markus.this.fill(50);
            Ue2_Konrad_markus.this.rectMode(0);
            Ue2_Konrad_markus.this.stroke(180);
            Ue2_Konrad_markus.this.rect(n2, (float)n3 - (float)n5 * 0.5f, n4, n5);
            int n8 = n3 + n5 / 2 - (int)(f3 * f4);
            Ue2_Konrad_markus.this.stroke(200.0f, 200.0f, 0.0f);
            Ue2_Konrad_markus.this.line(n2, n8, n2 + n4, n8);
            int n9 = 0;
            int n10 = 0;
            while (n10 < arrayList.size()) {
                float f5 = ((Float)arrayList.get(n10)).floatValue();
                float f6 = f5 / this.absResultDataMax;
                Ue2_Konrad_markus.this.fill(200.0f * f6, 200.0f * (1.0f - f6), 0.0f);
                Ue2_Konrad_markus.this.rectMode(0);
                Ue2_Konrad_markus.this.rect(n2 + n9 + n6, n3 + n5 / 2, n7, -f5 * f4);
                Ue2_Konrad_markus.this.fill(200);
                Ue2_Konrad_markus.this.textFont(this.fontVisValues, 9.0f);
                Ue2_Konrad_markus.this.textAlign(3);
                Ue2_Konrad_markus.this.text(n10 + 1, n2 + n9 + n6 + n7 / 2, n3 - n5 / 2 - 5);
                Ue2_Konrad_markus.this.text(Ue2_Konrad_markus.nf((float)f5, (int)1, (int)2), n2 + n9 + n6 + n7 / 2, n3 + n5 / 2 + 17);
                n9 += n7 + 2 * n6;
                ++n10;
            }
            this.displayMinAvgMax(n2, n3 + n5 / 2 + 30, f2, f3, f);
        }

        public void displayMinAvgMax(int n, int n2, float f, float f2, float f3) {
            Ue2_Konrad_markus.this.fill(200);
            Ue2_Konrad_markus.this.textFont(this.fontVisValues, 9.0f);
            Ue2_Konrad_markus.this.textAlign(37);
            Ue2_Konrad_markus.this.text("min: " + Ue2_Konrad_markus.nf((float)f, (int)1, (int)2), n, n2);
            Ue2_Konrad_markus.this.text("avg: " + Ue2_Konrad_markus.nf((float)f2, (int)1, (int)2), n, n2 + 12);
            Ue2_Konrad_markus.this.text("max: " + Ue2_Konrad_markus.nf((float)f3, (int)1, (int)2), n, n2 + 24);
        }

        public void update() {
            if (this.firstCall) {
                this.buildVisualizationData();
                this.firstCall = false;
            }
            this.prevButton.update();
            if (this.prevButton.pressed()) {
                Ue2_Konrad_markus.this.exit();
            }
        }

        public void buildVisualizationData() {
            this.resultData = new ArrayList();
            this.resultDataMax = new ArrayList();
            this.resultDataMin = new ArrayList();
            this.resultDataAvg = new ArrayList();
            int n = 0;
            while (n < this.testTypeCount) {
                ArrayList<Float> arrayList = new ArrayList<Float>();
                int n2 = n * this.testsPerType;
                float f = 0.0f;
                float f2 = Float.MIN_VALUE;
                float f3 = Float.MAX_VALUE;
                int n3 = n2;
                while (n3 < n2 + this.testsPerType) {
                    float f4 = ((Result)Ue2_Konrad_markus.this.results.get((int)n3)).reactionTime;
                    if (n2 > 0) {
                        f4 -= this.avgReactionTime;
                    }
                    f += f4 / (float)this.testsPerType;
                    if (f4 > f2) {
                        f2 = f4;
                    }
                    if (f4 < f3) {
                        f3 = f4;
                    }
                    arrayList.add(new Float(f4));
                    ++n3;
                }
                if (n2 == 0) {
                    this.avgReactionTime = f;
                    Ue2_Konrad_markus.println((float)this.avgReactionTime);
                }
                if (f2 > this.absResultDataMax) {
                    this.absResultDataMax = f2;
                }
                this.resultData.add(arrayList);
                this.resultDataMax.add(new Float(f2));
                this.resultDataMin.add(new Float(f3));
                this.resultDataAvg.add(new Float(f));
                ++n;
            }
        }
    }

    class AppTest {
        int testNum = 0;
        int testMax = 50;
        PFont fontHeaderText;
        int testTime;
        int testStartTime;
        float avgReactionTime;
        int testAreaSizeX = 600;
        int testAreaSizeY = 400;
        int fullAreaCenterX = 400;
        int areaCenterY = 350;
        boolean testIsRunning = false;
        RectButton testArea;
        Button objectToClick;
        int objColor;
        int distrColor;
        int prevObjX;
        int prevObjY;
        ArrayList distractorObjects;
        TextButton infoOkButton;
        TriangleButton nextButton;

        AppTest() {
            this.fontHeaderText = Ue2_Konrad_markus.this.loadFont("SansSerif-20.vlw");
            this.infoOkButton = new TextButton(400, 530, 50, 30, "Ok", Ue2_Konrad_markus.this.color(40), Ue2_Konrad_markus.this.color(60), true);
            this.nextButton = new TriangleButton(690, 550, 30, 50, 270.0f, Ue2_Konrad_markus.this.color(180), Ue2_Konrad_markus.this.color(220), true);
            this.distractorObjects = new ArrayList();
            this.initValues();
        }

        public void display() {
            Ue2_Konrad_markus.this.fill(200);
            Ue2_Konrad_markus.this.textAlign(37);
            Ue2_Konrad_markus.this.textFont(this.fontHeaderText, 20.0f);
            Ue2_Konrad_markus.this.text("Test #" + (this.testNum + 1) + "/" + this.testMax + ":", 20.0f, 80.0f);
            if (this.testIsRunning) {
                this.displayTest();
            } else {
                this.displayInfo();
            }
            this.displayFooter();
        }

        public void displayFooter() {
        }

        public void initValues() {
            Ue2_Konrad_markus.this.appState = (this.testNum + 1) / 5 + 1;
            this.distractorObjects.clear();
            switch (Ue2_Konrad_markus.this.appState) {
                case 1: {
                    int n = (int)Ue2_Konrad_markus.this.random(0.0f, this.testAreaSizeX - 100) + 100;
                    int n2 = (int)Ue2_Konrad_markus.this.random(0.0f, this.testAreaSizeY - 100) + 150;
                    this.objectToClick = new RectButton(n, n2, 50, 50, Ue2_Konrad_markus.this.color(180, 0, 0), Ue2_Konrad_markus.this.color(180, 0, 0), false);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    int n = 50;
                    int n3 = 50;
                    int n4 = this.distrColor;
                    int n5 = this.objColor;
                    int n6 = 10 + 5 * (this.testNum - 4);
                    if (Ue2_Konrad_markus.this.appState == 3) {
                        n = 50;
                        n6 = 10 + 5 * (this.testNum - 9);
                        n4 = this.distrColor = Ue2_Konrad_markus.this.color(180);
                        n5 = this.distrColor;
                    } else if (Ue2_Konrad_markus.this.appState == 4 || Ue2_Konrad_markus.this.appState == 7) {
                        n6 = 15;
                        if (Ue2_Konrad_markus.this.appState == 4) {
                            n = 50 + (20 - this.testNum) * 5;
                            n4 = this.distrColor = Ue2_Konrad_markus.this.color(180);
                            n5 = this.distrColor;
                        } else {
                            n5 = (int)Ue2_Konrad_markus.this.random(2.0f) == 1 ? n4 : this.objColor;
                            n = 50 + (38 - this.testNum) * 5;
                        }
                    } else if (Ue2_Konrad_markus.this.appState == 5 || Ue2_Konrad_markus.this.appState == 6) {
                        n = 50;
                        n6 = 15;
                    }
                    if (Ue2_Konrad_markus.this.appState == 2 || Ue2_Konrad_markus.this.appState == 5 || Ue2_Konrad_markus.this.appState == 6) {
                        this.objectToClick = new RectButton(0, 0, n, n, n5, n5, false);
                    } else if (Ue2_Konrad_markus.this.appState == 3 || Ue2_Konrad_markus.this.appState == 4 || Ue2_Konrad_markus.this.appState == 7) {
                        this.objectToClick = new CircleButton(0, 0, n, n5, n5, false);
                    } else if (Ue2_Konrad_markus.this.appState == 8 || Ue2_Konrad_markus.this.appState == 9 || Ue2_Konrad_markus.this.appState == 10) {
                        n6 = 15;
                    }
                    Ue2_Konrad_markus.println((String)("APPSTATE: " + Ue2_Konrad_markus.this.appState));
                    Ue2_Konrad_markus.println((String)("thisDistrColor: " + n4));
                    int n7 = 5;
                    int n8 = n6 / n7 + 1;
                    int n9 = this.testAreaSizeX / n7;
                    int n10 = this.testAreaSizeY / n8;
                    int n11 = (int)Ue2_Konrad_markus.this.random(n8);
                    int n12 = (int)Ue2_Konrad_markus.this.random(n7);
                    Button button = null;
                    int n13 = 0;
                    while (n13 < n8) {
                        int n14 = 0;
                        while (n14 < n7) {
                            int n15 = n14 * n9 + (int)Ue2_Konrad_markus.this.random(0.0f, n9 - n / 2) + 100;
                            int n16 = n13 * n10 + (int)Ue2_Konrad_markus.this.random(0.0f, n10 - n / 2) + 150;
                            if (n11 == n13 && n12 == n14) {
                                this.objectToClick.x = n15;
                                this.objectToClick.y = n16;
                            } else {
                                if (Ue2_Konrad_markus.this.appState == 2) {
                                    button = new RectButton(n15, n16, n3, n3, n4, Ue2_Konrad_markus.this.color(0), false);
                                }
                                if (Ue2_Konrad_markus.this.appState == 4) {
                                    button = new CircleButton(n15, n16, n3, n4, Ue2_Konrad_markus.this.color(0), false);
                                } else {
                                    if (Ue2_Konrad_markus.this.appState == 5) {
                                        n4 = this.randColor(n5);
                                    } else if (Ue2_Konrad_markus.this.appState == 6 || Ue2_Konrad_markus.this.appState == 7 || Ue2_Konrad_markus.this.appState == 8 || Ue2_Konrad_markus.this.appState == 9 || Ue2_Konrad_markus.this.appState == 10) {
                                        n4 = (int)Ue2_Konrad_markus.this.random(2.0f) == 1 ? this.objColor : this.distrColor;
                                    }
                                    int n17 = 0;
                                    float f = 0.0f;
                                    int n18 = 0;
                                    int n19 = 0;
                                    if (Ue2_Konrad_markus.this.appState == 6 || Ue2_Konrad_markus.this.appState == 7 || Ue2_Konrad_markus.this.appState == 8 || Ue2_Konrad_markus.this.appState == 9 || Ue2_Konrad_markus.this.appState == 10) {
                                        n17 = (int)Ue2_Konrad_markus.this.random(3.0f);
                                        f = Ue2_Konrad_markus.this.random(360.0f);
                                        n18 = (int)Ue2_Konrad_markus.this.random(-n3 / 2, n3 / 2);
                                        n19 = (int)Ue2_Konrad_markus.this.random(-n3 / 2, n3 / 2);
                                    }
                                    switch (n17) {
                                        default: {
                                            button = new RectButton(n15, n16, n3 + n18, n3 + n19, n4, Ue2_Konrad_markus.this.color(0), false);
                                            break;
                                        }
                                        case 1: {
                                            button = new CircleButton(n15, n16, n3 + n18, n3 + n19, n4, Ue2_Konrad_markus.this.color(0), false);
                                            break;
                                        }
                                        case 2: {
                                            button = new TriangleButton(n15, n16, n3 + n18, n3 + n19, f, n4, Ue2_Konrad_markus.this.color(0), false);
                                        }
                                    }
                                }
                                Ue2_Konrad_markus.println((String)("Added distractor: " + button));
                                Ue2_Konrad_markus.println((String)("With color: " + button.basecolor));
                                this.distractorObjects.add(button);
                            }
                            ++n14;
                        }
                        ++n13;
                    }
                    break;
                }
            }
        }

        public void resetTimers() {
            this.testStartTime = Ue2_Konrad_markus.this.millis();
            this.testTime = 0;
        }

        public void update() {
            if (this.testNum >= this.testMax) {
                Ue2_Konrad_markus.this.appState = 11;
                this.testNum = 0;
                this.initValues();
                return;
            }
            if (this.testIsRunning) {
                this.updateTest();
            } else {
                this.updateInfo();
            }
            this.updateFooter();
        }

        public void updateFooter() {
        }

        public void saveResults() {
            Result result = (Result)Ue2_Konrad_markus.this.results.get(this.testNum);
            result.reactionTime = (float)this.testTime / 1000.0f;
            if (this.testNum == 4) {
                this.testIsRunning = false;
                this.avgReactionTime = 0.0f;
                int n = 0;
                while (n < this.testNum + 1) {
                    Result result2 = (Result)Ue2_Konrad_markus.this.results.get(n);
                    this.avgReactionTime += result2.reactionTime / (float)(this.testNum + 1);
                    ++n;
                }
                this.distrColor = this.randColor();
                this.objColor = this.randColor(this.distrColor);
            } else if ((this.testNum + 1) % 5 == 0) {
                this.testIsRunning = false;
                this.distrColor = this.randColor();
                this.objColor = this.randColor(this.distrColor);
                if (Ue2_Konrad_markus.this.appState >= 7) {
                    int n = 50;
                    int n2 = (int)Ue2_Konrad_markus.this.random(3.0f);
                    int n3 = 0;
                    int n4 = 0;
                    int n5 = (int)Ue2_Konrad_markus.this.random(360.0f);
                    n3 = (int)Ue2_Konrad_markus.this.random(-n / 2, n / 2);
                    n4 = (int)Ue2_Konrad_markus.this.random(-n / 2, n / 2);
                    switch (n2) {
                        default: {
                            this.objectToClick = new RectButton(0, 0, n + n3, n + n4, this.objColor, this.objColor, false);
                            break;
                        }
                        case 1: {
                            this.objectToClick = new CircleButton(0, 0, n + n3, n + n4, this.objColor, this.objColor, false);
                            break;
                        }
                        case 2: {
                            this.objectToClick = new TriangleButton(0, 0, n + n3, n + n4, n5, this.objColor, this.objColor, false);
                        }
                    }
                }
            }
            this.initValues();
            this.resetTimers();
            ++this.testNum;
            Ue2_Konrad_markus.println((String)("Saved result:" + result));
        }

        public void displayInfo() {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.objectToClick.x = 400;
            this.objectToClick.y = 450;
            boolean bl = false;
            if (Ue2_Konrad_markus.this.appState == 2) {
                arrayList.add("Ihre durchschnittl. Reaktionsgeschwindigkeit ist " + Ue2_Konrad_markus.nf((float)this.avgReactionTime, (int)1, (int)2) + "s");
            }
            if (Ue2_Konrad_markus.this.appState == 4 || Ue2_Konrad_markus.this.appState == 7) {
                arrayList.add("Klicken Sie schnellstm\u00f6glich auf den gr\u00f6\u00dften Kreis!");
                bl = true;
            }
            if (!bl) {
                arrayList.add("Klicken Sie jetzt im n\u00e4chsten Test so schnell wie m\u00f6glich auf folgendes Objekt:");
                this.objectToClick.display();
            }
            Ue2_Konrad_markus.this.fill(200);
            Ue2_Konrad_markus.this.textFont(this.fontHeaderText, 20.0f);
            Ue2_Konrad_markus.this.textAlign(3);
            int n = 0;
            while (n < arrayList.size()) {
                Ue2_Konrad_markus.this.text((String)arrayList.get(n), 400.0f, 330 + n * 30);
                ++n;
            }
            this.infoOkButton.display();
        }

        public void updateInfo() {
            this.infoOkButton.update();
            if (this.infoOkButton.pressed()) {
                this.resetTimers();
                this.testIsRunning = true;
                this.objectToClick.x = (int)Ue2_Konrad_markus.this.random(this.testAreaSizeX - 100) + 100;
                this.objectToClick.y = (int)Ue2_Konrad_markus.this.random(this.testAreaSizeY - 100) + 150;
            }
        }

        public void displayTest() {
            Ue2_Konrad_markus.this.fill(200);
            Ue2_Konrad_markus.this.textFont(this.fontHeaderText, 20.0f);
            Ue2_Konrad_markus.this.textAlign(3);
            Ue2_Konrad_markus.this.textAlign(39);
            Ue2_Konrad_markus.this.text(String.valueOf(Ue2_Konrad_markus.nf((float)((float)this.testTime / 1000.0f), (int)1, (int)2)) + " s", 700.0f, 80.0f);
            if (Ue2_Konrad_markus.this.appState > 1) {
                int n = 0;
                while (n < this.distractorObjects.size()) {
                    ((Button)this.distractorObjects.get(n)).display();
                    ++n;
                }
            }
            this.objectToClick.display();
        }

        public void updateTest() {
            this.testTime = Ue2_Konrad_markus.this.millis() - this.testStartTime;
            this.objectToClick.update();
            if (this.objectToClick.pressed()) {
                this.saveResults();
            }
        }

        public int randColor() {
            return Ue2_Konrad_markus.this.color((int)Ue2_Konrad_markus.this.random(55.0f, 255.0f), (int)Ue2_Konrad_markus.this.random(55.0f, 255.0f), (int)Ue2_Konrad_markus.this.random(55.0f, 255.0f));
        }

        public int randColor(int n) {
            int n2;
            float f;
            while ((f = this.colorDist(n2 = this.randColor(), n)) < 30000.0f) {
            }
            return n2;
        }

        public float colorDist(int n, int n2) {
            float f = Ue2_Konrad_markus.this.red(n) - Ue2_Konrad_markus.this.red(n2);
            float f2 = Ue2_Konrad_markus.this.green(n) - Ue2_Konrad_markus.this.green(n2);
            float f3 = Ue2_Konrad_markus.this.blue(n) - Ue2_Konrad_markus.this.blue(n2);
            return f * f + f2 * f2 + f3 * f3;
        }
    }

    abstract class Button {
        int x;
        int y;
        int sizeW;
        int sizeH;
        int basecolor;
        int highlightcolor;
        int currentcolor;
        boolean over = false;
        boolean pressed = false;
        int lastClick = 0;
        int clickLockTime = 0;

        Button() {
        }

        public void update() {
            this.currentcolor = this.over() ? this.highlightcolor : this.basecolor;
        }

        public abstract void display();

        public boolean pressed() {
            if (this.clickLockTime > 0) {
                boolean bl;
                boolean bl2 = bl = Ue2_Konrad_markus.this.millis() - this.lastClick > this.clickLockTime && Ue2_Konrad_markus.this.mousePressed && this.over;
                if (bl) {
                    this.lastClick = Ue2_Konrad_markus.this.millis();
                }
                return bl;
            }
            return Ue2_Konrad_markus.this.mousePressed && this.over;
        }

        public boolean over() {
            return true;
        }

        public boolean overRect(int n, int n2, int n3, int n4) {
            return Ue2_Konrad_markus.this.mouseX >= n && Ue2_Konrad_markus.this.mouseX <= n + n3 && Ue2_Konrad_markus.this.mouseY >= n2 && Ue2_Konrad_markus.this.mouseY <= n2 + n4;
        }

        public boolean overCircle(int n, int n2, int n3) {
            float f = n - Ue2_Konrad_markus.this.mouseX;
            float f2 = n2 - Ue2_Konrad_markus.this.mouseY;
            return Ue2_Konrad_markus.sqrt((float)(Ue2_Konrad_markus.sq((float)f) + Ue2_Konrad_markus.sq((float)f2))) < (float)(n3 / 2);
        }
    }

    class CircleButton
    extends Button {
        CircleButton(int n, int n2, int n3, int n4, int n5, boolean bl) {
            this(n, n2, n3, n3, n4, n5, bl);
        }

        CircleButton(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n4;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overCircle(this.x, this.y, this.sizeW)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue2_Konrad_markus.this.noStroke();
            Ue2_Konrad_markus.this.fill(this.currentcolor);
            Ue2_Konrad_markus.this.ellipse(this.x, this.y, this.sizeW, this.sizeH);
        }
    }

    class RectButton
    extends Button {
        RectButton(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n4;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overRect(this.x - this.sizeW / 2, this.y - this.sizeW / 2, this.sizeW, this.sizeW)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue2_Konrad_markus.this.noStroke();
            Ue2_Konrad_markus.this.fill(this.currentcolor);
            Ue2_Konrad_markus.this.rectMode(3);
            Ue2_Konrad_markus.this.rect(this.x, this.y, this.sizeW, this.sizeH);
        }
    }

    class Result {
        int testNum = 0;
        int testType = 0;
        float reactionTime = 0.0f;

        Result() {
        }

        public String toString() {
            return "Result for Test#" + this.testNum + ":\n" + " testType: " + this.testType + "\n" + " reactionTime: " + this.reactionTime;
        }
    }

    class TextButton
    extends Button {
        PFont labelFont;
        String label;

        TextButton(int n, int n2, int n3, int n4, String string, int n5, int n6, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n4;
            this.label = string;
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.labelFont = Ue2_Konrad_markus.this.loadFont("SansSerif-14.vlw");
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overRect(this.x - this.sizeW / 2, this.y - this.sizeH / 2, this.sizeW, this.sizeH)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue2_Konrad_markus.this.stroke(255);
            Ue2_Konrad_markus.this.fill(this.currentcolor);
            Ue2_Konrad_markus.this.rectMode(3);
            Ue2_Konrad_markus.this.rect(this.x, this.y, this.sizeW, this.sizeH);
            Ue2_Konrad_markus.this.fill(255);
            Ue2_Konrad_markus.this.textFont(this.labelFont, 14.0f);
            Ue2_Konrad_markus.this.textAlign(3);
            Ue2_Konrad_markus.this.text(this.label, this.x, this.y + 5);
        }
    }

    class TriangleButton
    extends Button {
        float angle;

        TriangleButton(int n, int n2, int n3, int n4, float f, int n5, int n6, boolean bl) {
            this.x = n;
            this.y = n2;
            this.sizeW = n3;
            this.sizeH = n4;
            this.angle = Ue2_Konrad_markus.radians((float)f);
            this.basecolor = n5;
            this.highlightcolor = n6;
            this.currentcolor = this.basecolor;
            this.clickLockTime = bl ? 500 : 0;
        }

        public boolean over() {
            if (this.overRect(this.x - this.sizeW / 2, this.y - this.sizeH / 2, this.sizeW, this.sizeH)) {
                this.over = true;
                return true;
            }
            this.over = false;
            return false;
        }

        public void display() {
            Ue2_Konrad_markus.this.pushMatrix();
            Ue2_Konrad_markus.this.noStroke();
            Ue2_Konrad_markus.this.fill(this.currentcolor);
            Ue2_Konrad_markus.this.translate(this.x, this.y);
            Ue2_Konrad_markus.this.rotate(this.angle);
            Ue2_Konrad_markus.this.triangle(-this.sizeW / 2, -this.sizeH / 2, (float)this.sizeW / 2.5f, -this.sizeH / 2, 0.0f, this.sizeH / 2);
            Ue2_Konrad_markus.this.popMatrix();
        }
    }
}

