/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.Node;
import processing.core.PApplet;
import processing.core.PVector;

public class Attractor
extends Node {
    public static final int BASIC = 0;
    public static final int SMOOTH = 1;
    public static final int TWIRL = 2;
    public int mode = 1;
    public float strength = 1.0f;
    Node[] nodes = new Node[0];

    public Attractor() {
    }

    public Attractor(float theX, float theY) {
        super(theX, theY);
    }

    public Attractor(float theX, float theY, float theZ) {
        super(theX, theY, theZ);
    }

    public Attractor(PVector theVector) {
        super(theVector);
    }

    public void attachNode(Node theNode) {
        this.nodes = (Node[])PApplet.append((Object)this.nodes, (Object)((Object)theNode));
    }

    public void attract() {
        int i = 0;
        while (i < this.nodes.length) {
            this.attract(this.nodes[i]);
            ++i;
        }
    }

    public void attract(Node theNode) {
        float d = this.dist(theNode);
        float f = 0.0f;
        switch (this.mode) {
            case 0: {
                if (!(d > 0.0f) || !(d < this.radius)) break;
                float s = d / this.radius;
                f = 1.0f / PApplet.pow((float)s, (float)(0.5f * this.ramp)) - 1.0f;
                f = this.strength * f / this.radius;
                break;
            }
            case 1: {
                if (!(d > 0.0f) || !(d < this.radius)) break;
                float s = PApplet.pow((float)(d / this.radius), (float)(1.0f / this.ramp));
                f = s * 9.0f * this.strength * (1.0f / (s + 1.0f) + (s - 3.0f) / 4.0f) / d;
                break;
            }
            case 2: {
                if (!(d > 0.0f) || !(d < this.radius)) break;
                float s = PApplet.pow((float)(d / this.radius), (float)(1.0f / this.ramp));
                f = s * 9.0f * this.strength * (1.0f / (s + 1.0f) + (s - 3.0f) / 4.0f) / d;
            }
        }
        PVector df = PVector.sub((PVector)this, (PVector)theNode);
        df.mult(f);
        if (this.mode != 2) {
            theNode.velocity.x += df.x;
            theNode.velocity.y += df.y;
            theNode.velocity.z += df.z;
        } else {
            theNode.velocity.x += df.y;
            theNode.velocity.y -= df.x;
            theNode.velocity.z += df.z;
        }
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int theMode) {
        this.mode = theMode;
    }

    public float getStrength() {
        return this.strength;
    }

    public void setStrength(float theStrength) {
        this.strength = theStrength;
    }

    public Node[] getNodes() {
        return this.nodes;
    }

    public void setNodes(Node[] nodes) {
        this.nodes = nodes;
    }
}

